/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro.nbm.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class NestedBodyMacroAssessmentResult {
    @JsonProperty
    private String serverId;
    @JsonProperty
    private String instanceTimezone;
    @JsonProperty
    private String assessmentStartingDate;
    @JsonProperty
    private long duration;
    @JsonProperty
    private List<String> nestedBodyMacroSequence;
    @JsonProperty
    private Long numberOfOccurrences;
    @JsonProperty
    private Set<Long> pageIds;

    public NestedBodyMacroAssessmentResult(List<String> nestedMacroSequence, Long numberOfOccurrences, Set<Long> pageIds) {
        this.nestedBodyMacroSequence = nestedMacroSequence;
        this.numberOfOccurrences = numberOfOccurrences;
        this.pageIds = pageIds != null ? pageIds : new HashSet();
    }

    public void updateOccurrenceAndPageIds(Long contentId) {
        Long l = this.numberOfOccurrences;
        this.numberOfOccurrences = this.numberOfOccurrences + 1L;
        this.pageIds.add(contentId);
    }

    public void addIdentification(String serverId, String instanceTimezone, String assessmentStartingDate) {
        this.serverId = serverId;
        this.instanceTimezone = instanceTimezone;
        this.assessmentStartingDate = assessmentStartingDate;
    }

    public void addExecutionStats(long duration) {
        this.duration = duration;
    }

    @JsonCreator
    public NestedBodyMacroAssessmentResult(@JsonProperty(value="serverId") String serverId, @JsonProperty(value="instanceTimezone") String instanceTimezone, @JsonProperty(value="assessmentStartingDate") String assessmentStartingDate, @JsonProperty(value="duration") long duration, @JsonProperty(value="nestedMacroSequence") List<String> nestedMacroSequence, @JsonProperty(value="numberOfOccurrences") Long numberOfOccurrences, @JsonProperty(value="pageIds") Set<Long> pageIds) {
        this.serverId = serverId;
        this.instanceTimezone = instanceTimezone;
        this.assessmentStartingDate = assessmentStartingDate;
        this.duration = duration;
        this.nestedBodyMacroSequence = nestedMacroSequence;
        this.numberOfOccurrences = numberOfOccurrences;
        this.pageIds = pageIds;
    }

    public static String createKey(List<String> nestedMacroNames) {
        return String.join((CharSequence)"|", nestedMacroNames);
    }

    @Generated
    public String getServerId() {
        return this.serverId;
    }

    @Generated
    public String getInstanceTimezone() {
        return this.instanceTimezone;
    }

    @Generated
    public String getAssessmentStartingDate() {
        return this.assessmentStartingDate;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public List<String> getNestedBodyMacroSequence() {
        return this.nestedBodyMacroSequence;
    }

    @Generated
    public Long getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    @Generated
    public Set<Long> getPageIds() {
        return this.pageIds;
    }

    @Generated
    public String toString() {
        return "NestedBodyMacroAssessmentResult(serverId=" + this.getServerId() + ", instanceTimezone=" + this.getInstanceTimezone() + ", assessmentStartingDate=" + this.getAssessmentStartingDate() + ", duration=" + this.getDuration() + ", nestedBodyMacroSequence=" + this.getNestedBodyMacroSequence() + ", numberOfOccurrences=" + this.getNumberOfOccurrences() + ", pageIds=" + this.getPageIds() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NestedBodyMacroAssessmentResult)) {
            return false;
        }
        NestedBodyMacroAssessmentResult other = (NestedBodyMacroAssessmentResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        Long this$numberOfOccurrences = this.getNumberOfOccurrences();
        Long other$numberOfOccurrences = other.getNumberOfOccurrences();
        if (this$numberOfOccurrences == null ? other$numberOfOccurrences != null : !((Object)this$numberOfOccurrences).equals(other$numberOfOccurrences)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        String this$instanceTimezone = this.getInstanceTimezone();
        String other$instanceTimezone = other.getInstanceTimezone();
        if (this$instanceTimezone == null ? other$instanceTimezone != null : !this$instanceTimezone.equals(other$instanceTimezone)) {
            return false;
        }
        String this$assessmentStartingDate = this.getAssessmentStartingDate();
        String other$assessmentStartingDate = other.getAssessmentStartingDate();
        if (this$assessmentStartingDate == null ? other$assessmentStartingDate != null : !this$assessmentStartingDate.equals(other$assessmentStartingDate)) {
            return false;
        }
        List<String> this$nestedBodyMacroSequence = this.getNestedBodyMacroSequence();
        List<String> other$nestedBodyMacroSequence = other.getNestedBodyMacroSequence();
        if (this$nestedBodyMacroSequence == null ? other$nestedBodyMacroSequence != null : !((Object)this$nestedBodyMacroSequence).equals(other$nestedBodyMacroSequence)) {
            return false;
        }
        Set<Long> this$pageIds = this.getPageIds();
        Set<Long> other$pageIds = other.getPageIds();
        return !(this$pageIds == null ? other$pageIds != null : !((Object)this$pageIds).equals(other$pageIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NestedBodyMacroAssessmentResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        Long $numberOfOccurrences = this.getNumberOfOccurrences();
        result = result * 59 + ($numberOfOccurrences == null ? 43 : ((Object)$numberOfOccurrences).hashCode());
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        String $instanceTimezone = this.getInstanceTimezone();
        result = result * 59 + ($instanceTimezone == null ? 43 : $instanceTimezone.hashCode());
        String $assessmentStartingDate = this.getAssessmentStartingDate();
        result = result * 59 + ($assessmentStartingDate == null ? 43 : $assessmentStartingDate.hashCode());
        List<String> $nestedBodyMacroSequence = this.getNestedBodyMacroSequence();
        result = result * 59 + ($nestedBodyMacroSequence == null ? 43 : ((Object)$nestedBodyMacroSequence).hashCode());
        Set<Long> $pageIds = this.getPageIds();
        result = result * 59 + ($pageIds == null ? 43 : ((Object)$pageIds).hashCode());
        return result;
    }

    @JsonProperty
    @Generated
    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    @JsonProperty
    @Generated
    public void setInstanceTimezone(String instanceTimezone) {
        this.instanceTimezone = instanceTimezone;
    }

    @JsonProperty
    @Generated
    public void setAssessmentStartingDate(String assessmentStartingDate) {
        this.assessmentStartingDate = assessmentStartingDate;
    }

    @JsonProperty
    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @JsonProperty
    @Generated
    public void setNestedBodyMacroSequence(List<String> nestedBodyMacroSequence) {
        this.nestedBodyMacroSequence = nestedBodyMacroSequence;
    }

    @JsonProperty
    @Generated
    public void setNumberOfOccurrences(Long numberOfOccurrences) {
        this.numberOfOccurrences = numberOfOccurrences;
    }

    @JsonProperty
    @Generated
    public void setPageIds(Set<Long> pageIds) {
        this.pageIds = pageIds;
    }
}

