/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro.nbm.manager;

import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.service.guardrails.AssessmentOutputFileGenerator;
import com.atlassian.migration.agent.service.guardrails.OutputFileGeneratorException;
import com.atlassian.migration.agent.service.guardrails.OutputFilenames;
import com.atlassian.migration.agent.service.guardrails.OutputPathGenerator;
import com.atlassian.migration.agent.service.guardrails.macro.nbm.manager.NestedBodyMacroAssessmentService;
import com.atlassian.migration.agent.service.guardrails.macro.nbm.manager.NestedBodyMacroAssessmentStore;
import com.atlassian.migration.agent.service.guardrails.macro.nbm.model.NestedBodyMacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.util.SerializationUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedBodyMacroAssessmentOutputFileGenerator
implements AssessmentOutputFileGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NestedBodyMacroAssessmentOutputFileGenerator.class);
    private final NestedBodyMacroAssessmentService nestedBodyMacroAssessmentService;
    private final NestedBodyMacroAssessmentStore nestedBodyMacroAssessmentStore;
    private final OutputPathGenerator outputPathGenerator;

    @Override
    public Set<Path> generate(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto, boolean example) throws OutputFileGeneratorException {
        try {
            List<NestedBodyMacroAssessmentResult> results;
            List<NestedBodyMacroAssessmentResult> list = results = example ? this.nestedBodyMacroAssessmentService.example() : this.nestedBodyMacroAssessmentStore.getNestedBodyMacroAssessmentResult(today);
            if (results == null || results.isEmpty()) {
                return Collections.emptySet();
            }
            for (NestedBodyMacroAssessmentResult result : results) {
                result.addIdentification(instanceMetadataDto.getServerId(), instanceMetadataDto.getInstanceTimezone(), instanceMetadataDto.getAssessmentDate());
            }
            Path outputPath = this.outputPathGenerator.jsonFilePath(OutputFilenames.NESTED_BODY_MACROS.getFilename(date));
            SerializationUtil.saveJsonL(outputPath.toFile(), results);
            return Collections.singleton(outputPath);
        }
        catch (IOException e) {
            log.error("Error generating Nested Body Macro Assessment output file", (Throwable)e);
            throw new OutputFileGeneratorException(e.getMessage());
        }
    }

    @Generated
    public NestedBodyMacroAssessmentOutputFileGenerator(NestedBodyMacroAssessmentService nestedBodyMacroAssessmentService, NestedBodyMacroAssessmentStore nestedBodyMacroAssessmentStore, OutputPathGenerator outputPathGenerator) {
        this.nestedBodyMacroAssessmentService = nestedBodyMacroAssessmentService;
        this.nestedBodyMacroAssessmentStore = nestedBodyMacroAssessmentStore;
        this.outputPathGenerator = outputPathGenerator;
    }
}

