/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.cloud;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ServiceInitializeException;
import com.google.common.base.Ticker;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class NonceService {
    private static final Logger log = ContextLoggerFactory.getLogger(NonceService.class);
    private static final String NONCE_ATTRIBUTE = "confluence.migration.nonce";
    private static final String NONCE_CREATE_TIME_ATTRIBUTE = "confluence.migration.nonce.createtime";
    private static final long TTL_NS = TimeUnit.MINUTES.toNanos(30L);
    private static final Supplier<Object> DEFAULT_SESSION_SUPPLIER = () -> {
        try {
            Method getRequestMethod = ServletContextThreadLocal.class.getMethod("getRequest", new Class[0]);
            Object request = getRequestMethod.invoke(null, new Object[0]);
            Method getSessionMethod = request.getClass().getMethod("getSession", new Class[0]);
            Object session = getSessionMethod.invoke(request, new Object[0]);
            Objects.requireNonNull(session, "session is not available");
            return session;
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to get session", e);
        }
    };
    private final Ticker ticker;
    private final Supplier<Object> sessionSupplier;
    private final MigrationAgentConfiguration configuration;

    public NonceService(MigrationAgentConfiguration configuration) {
        this(configuration, Ticker.systemTicker(), DEFAULT_SESSION_SUPPLIER);
    }

    @VisibleForTesting
    NonceService(MigrationAgentConfiguration configuration, Ticker ticker, Supplier<Object> sessionSupplier) {
        this.configuration = configuration;
        this.ticker = ticker;
        this.sessionSupplier = sessionSupplier;
    }

    public String generateAndSaveNonce() {
        String nonce = UUID.randomUUID().toString();
        Object session = this.getSession();
        this.setSessionAttribute(session, NONCE_ATTRIBUTE, nonce);
        this.setSessionAttribute(session, NONCE_CREATE_TIME_ATTRIBUTE, this.ticker.read());
        return nonce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAndDeleteNonce(String nonce) {
        if (this.configuration.isSkipNonceCheck()) {
            log.debug("Nonce check is disabled in plugin configuration. Will skip nonce check...");
            return true;
        }
        Object session = this.getSession();
        try {
            String existingNonce = (String)this.getSessionAttribute(session, NONCE_ATTRIBUTE);
            Long existingNonceCreationTime = (Long)this.getSessionAttribute(session, NONCE_CREATE_TIME_ATTRIBUTE);
            if (existingNonce == null || existingNonceCreationTime == null) {
                boolean bl = false;
                return bl;
            }
            boolean isNotExpired = existingNonceCreationTime + TTL_NS > this.ticker.read();
            boolean bl = isNotExpired && existingNonce.equals(nonce);
            return bl;
        }
        finally {
            this.removeSessionAttribute(session, NONCE_ATTRIBUTE);
            this.removeSessionAttribute(session, NONCE_CREATE_TIME_ATTRIBUTE);
        }
    }

    private Object getSession() {
        return this.sessionSupplier.get();
    }

    private void setSessionAttribute(Object session, String name, Object value) {
        try {
            Method setAttributeMethod = session.getClass().getMethod("setAttribute", String.class, Object.class);
            setAttributeMethod.invoke(session, name, value);
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to set session attribute: " + name, e);
        }
    }

    private Object getSessionAttribute(Object session, String name) {
        try {
            Method getAttributeMethod = session.getClass().getMethod("getAttribute", String.class);
            return getAttributeMethod.invoke(session, name);
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to get session attribute: " + name, e);
        }
    }

    private void removeSessionAttribute(Object session, String name) {
        try {
            Method removeAttributeMethod = session.getClass().getMethod("removeAttribute", String.class);
            removeAttributeMethod.invoke(session, name);
        }
        catch (Exception e) {
            throw new ServiceInitializeException("Failed to remove session attribute: " + name, e);
        }
    }
}

