/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.catalogue;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.AppsProgressDto;
import com.atlassian.migration.agent.dto.ConcurrencySettingsEnum;
import com.atlassian.migration.agent.dto.util.UserMigrationType;
import com.atlassian.migration.agent.entity.AbstractSpaceTask;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.ExcludeApp;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.ExecutionType;
import com.atlassian.migration.agent.entity.MapiPlanMapping;
import com.atlassian.migration.agent.entity.MapiTaskMapping;
import com.atlassian.migration.agent.entity.MigrateAppsTask;
import com.atlassian.migration.agent.entity.MigrateGlobalEntitiesTask;
import com.atlassian.migration.agent.entity.MigrateUsersTask;
import com.atlassian.migration.agent.entity.MigrationStatus;
import com.atlassian.migration.agent.entity.MigrationTag;
import com.atlassian.migration.agent.entity.NeededInCloudApp;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.SpaceAttachmentsOnlyTask;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.entity.TransferStatus;
import com.atlassian.migration.agent.mapi.entity.MapiTaskStatus;
import com.atlassian.migration.agent.mapi.job.scope.SpaceMode;
import com.atlassian.migration.agent.service.ClusterLimits;
import com.atlassian.migration.agent.service.FeatureFlagService;
import com.atlassian.migration.agent.service.MigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.FeatureFlagActionSubject;
import com.atlassian.migration.agent.service.analytics.builders.MCSAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.app.AppListenerIssueService;
import com.atlassian.migration.agent.service.app.PluginManager;
import com.atlassian.migration.agent.service.catalogue.CloudLocation;
import com.atlassian.migration.agent.service.catalogue.ContainerCreateRequest;
import com.atlassian.migration.agent.service.catalogue.ContainersFetchResponse;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.agent.service.catalogue.MigrationCreateRequest;
import com.atlassian.migration.agent.service.catalogue.MigrationCreateRequestV2;
import com.atlassian.migration.agent.service.catalogue.MigrationDetails;
import com.atlassian.migration.agent.service.catalogue.MigrationLocationType;
import com.atlassian.migration.agent.service.catalogue.MigrationScopeCreateRequest;
import com.atlassian.migration.agent.service.catalogue.ServerLocation;
import com.atlassian.migration.agent.service.catalogue.TransferProgressRequest;
import com.atlassian.migration.agent.service.catalogue.TransferStatusesUpdateRequest;
import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.catalogue.model.AppContainer;
import com.atlassian.migration.agent.service.catalogue.model.ConfluenceLicenseDetails;
import com.atlassian.migration.agent.service.catalogue.model.ConfluenceSpaceContainer;
import com.atlassian.migration.agent.service.catalogue.model.MigrationDomainsAllowlistResponse;
import com.atlassian.migration.agent.service.catalogue.model.PackedConfluenceSpaceContainer;
import com.atlassian.migration.agent.service.catalogue.model.SiteContainer;
import com.atlassian.migration.agent.service.catalogue.model.TransferResponseList;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.impl.AppAssessmentFacade;
import com.atlassian.migration.agent.service.impl.ConcurrencySettingsService;
import com.atlassian.migration.agent.service.impl.DefaultPlanService;
import com.atlassian.migration.agent.service.impl.MapiPlanMappingService;
import com.atlassian.migration.agent.service.impl.MapiTaskMappingService;
import com.atlassian.migration.agent.service.impl.MigrationAppAggregatorService;
import com.atlassian.migration.agent.service.impl.MigrationPlatformService;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.packing.Pack;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.agent.v4.migration.PlatformMigrationStatus;
import com.atlassian.migration.agent.v4.recipe.RecipeConstants;
import com.atlassian.migration.agent.v4.recipe.RecipeContext;
import com.atlassian.migration.agent.v4.recipe.RecipeExecutionActionRequest;
import com.atlassian.migration.agent.v4.recipe.RecipeExecutionRequest;
import com.atlassian.migration.agent.v4.recipe.RecipeMigrationDetails;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.DefaultRegistrar;
import com.atlassian.migration.app.dto.AppContainerDetails;
import com.atlassian.migration.app.dto.MigrationPath;
import com.atlassian.migration.prc.model.CommandName;
import com.atlassian.migration.utils.MigrationStatusCalculator;
import com.atlassian.plugin.Plugin;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Pair;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlatformService.class);
    private static final int CONTAINERS_PAGE_SIZE = 250;
    private static final int IMPORT_CONCURRENCY_V4_OVERRIDE = 25;
    private static final int IMPORT_CONCURRENCY_V4_OVERRIDE_MAX = 64;
    private static final int IMPORT_CONCURRENCY_V4_OVERRIDE_INDEX = 8;
    public static final String LICENSES_PROPERTIES_ENTRY = "Licenses";
    private static final String MIGRATION_SCOPE_CACHE = "com.atlassian.migration.agent.migrationScopeCache";
    private final Cache<String, String> migrationScopeCache;
    private final SENSupplier senSupplier;
    private final LicenseHandler licenseHandler;
    private final SystemInformationService systemInformationService;
    private final SpaceManager spaceManager;
    private final EnterpriseGatekeeperClient enterpriseGatekeeperClient;
    private final DefaultRegistrar defaultRegistrar;
    private final PluginManager pluginManager;
    private final PluginVersionManager pluginVersionManager;
    private final MigrationAppAggregatorService appAggregatorService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final FeatureFlagService featureFlagService;
    private final AnalyticsEventService analyticsEventService;
    private final MapiTaskMappingService mapiTaskMappingService;
    private final ClusterLimits clusterLimits;
    private final MigrationPlatformService migrationPlatformService;
    private final AppListenerIssueService appListenerIssueService;
    private final CloudSiteService cloudSiteService;
    private final MapiPlanMappingService mapiPlanMappingService;
    private final MCSAnalyticsEventBuilder mcsAnalyticsEventBuilder;
    private final ConcurrencySettingsService concurrencySettingsService;
    private static final String STATUS = "status";
    private static final String PROGRESS = "progress";

    public PlatformService(SENSupplier senSupplier, LicenseHandler licenseHandler, SystemInformationService systemInformationService, SpaceManager spaceManager, EnterpriseGatekeeperClient enterpriseGatekeeperClient, DefaultRegistrar defaultRegistrar, MigrationAppAggregatorService appAggregatorService, PluginManager pluginManager, PluginVersionManager pluginVersionManager, MigrationDarkFeaturesManager migrationDarkFeaturesManager, FeatureFlagService featureFlagService, AnalyticsEventService analyticsEventService, MapiTaskMappingService mapiTaskMappingService, MapiPlanMappingService mapiPlanMappingService, MCSAnalyticsEventBuilder mcsAnalyticsEventBuilder, CacheManager cacheManager, ClusterLimits clusterLimits, MigrationPlatformService migrationPlatformService, AppListenerIssueService appListenerIssueService, CloudSiteService cloudSiteService, ConcurrencySettingsService concurrencySettingsService) {
        this.senSupplier = senSupplier;
        this.licenseHandler = licenseHandler;
        this.systemInformationService = systemInformationService;
        this.spaceManager = spaceManager;
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
        this.defaultRegistrar = defaultRegistrar;
        this.appAggregatorService = appAggregatorService;
        this.pluginManager = pluginManager;
        this.pluginVersionManager = pluginVersionManager;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.featureFlagService = featureFlagService;
        this.analyticsEventService = analyticsEventService;
        this.mapiTaskMappingService = mapiTaskMappingService;
        this.mapiPlanMappingService = mapiPlanMappingService;
        this.mcsAnalyticsEventBuilder = mcsAnalyticsEventBuilder;
        this.clusterLimits = clusterLimits;
        this.migrationPlatformService = migrationPlatformService;
        this.appListenerIssueService = appListenerIssueService;
        this.cloudSiteService = cloudSiteService;
        this.concurrencySettingsService = concurrencySettingsService;
        this.migrationScopeCache = cacheManager.getCache(MIGRATION_SCOPE_CACHE, null, new CacheSettingsBuilder().remote().replicateViaCopy().expireAfterWrite(5L, TimeUnit.MINUTES).build());
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    void preDestroy() {
        this.migrationScopeCache.removeAll();
        log.info("Migration scope cache has been cleared.");
    }

    public MigrationDetails publishMigrationDetailsForAllListeners(Plan plan) {
        String cloudId = plan.getCloudSite().getCloudId();
        MigrationDetails mcsMigrationDetails = this.createMigrationInMcs(cloudId, plan);
        return new MigrationDetails(mcsMigrationDetails.migrationScopeId, mcsMigrationDetails.migrationId);
    }

    public Set<AppContainerDetails> getAppContainers(String cloudId, String migrationId) {
        return this.getContainers(cloudId, migrationId, AbstractContainer.ContainerType.App, false).stream().map(container -> {
            AppContainer appContainer = (AppContainer)container;
            return new AppContainerDetails(appContainer.getSourceKey(), appContainer.getDestinationKey(), appContainer.getContainerId(), Collections.emptyMap());
        }).collect(Collectors.toSet());
    }

    @VisibleForTesting
    List<AbstractContainer> getContainers(String cloudId, String migrationId, AbstractContainer.ContainerType type, boolean expand) {
        ArrayList<AbstractContainer> containers = new ArrayList<AbstractContainer>();
        String nextId = null;
        do {
            ContainersFetchResponse response = this.enterpriseGatekeeperClient.getContainersForMigration(cloudId, migrationId, type, 250, nextId, expand, false);
            List<AbstractContainer> containersInPage = response.getContainers();
            nextId = response.getNextId();
            if (containersInPage == null) continue;
            containers.addAll(containersInPage);
        } while (nextId != null);
        return containers;
    }

    public Optional<AppsProgressDto> getAppsProgress(Plan plan) {
        try {
            List<AppsProgressDto.App> apps = Collections.emptyList();
            Optional<MigrateAppsTask> maybeMigrateAppsTask = DefaultPlanService.getMigrateAppsTask(plan);
            MigrationStatusCalculator.OverallAppMigrationStatus aggregateStatus = null;
            if (maybeMigrateAppsTask.isPresent()) {
                MigrateAppsTask migrateAppsTask = maybeMigrateAppsTask.get();
                aggregateStatus = this.getAppAggregateStatus(migrateAppsTask.getProgress());
                String migrationId = plan.getMigrationId();
                String cloudId = plan.getCloudSite().getCloudId();
                if (this.shouldRetrieveAppsProgress(plan)) {
                    apps = this.getMigratableAppsProgress(cloudId, migrationId);
                    apps.addAll(this.getInstallOnlyAppsProgress(migrateAppsTask));
                } else {
                    Set<String> appKeys = this.getAutomatedServerAppKeysForMigration(migrateAppsTask, true);
                    apps = appKeys.stream().map(appKey -> this.createStubAppsProgressDto((String)appKey, 0, AbstractContainer.ContainerStatus.READY.name(), "Ready to start migration.")).collect(Collectors.toList());
                }
            }
            apps.sort(Comparator.comparing(AppsProgressDto.App::getServerAppName));
            return Optional.of(new AppsProgressDto(aggregateStatus, apps));
        }
        catch (Exception e) {
            log.error("Error when trying to get app progress for plan {}.", (Object)plan.getId(), (Object)e);
            return Optional.empty();
        }
    }

    public void triggerMigrationRecipe(String cloudId, Plan plan, @Nullable @jakarta.annotation.Nullable String originalPlanId, List<Pack> packs) {
        RecipeExecutionRequest recipeExecutionRequest = this.getMigrationRecipe(cloudId, plan, originalPlanId, packs);
        CloudSite cloudSite = plan.getCloudSite();
        this.migrationPlatformService.executeRecipe(cloudSite.getContainerToken(), plan.getMigrationId(), plan.getMigrationScopeId(), recipeExecutionRequest);
        log.info("Triggered recipe with migration ID {}, for cloud {}", (Object)plan.getMigrationId(), (Object)cloudId);
    }

    public RecipeExecutionRequest getMigrationRecipe(String cloudId, Plan plan, @Nullable @jakarta.annotation.Nullable String originalPlanId, List<Pack> packs) {
        CloudSite cloudSite = plan.getCloudSite();
        CloudLocation cloudLocation = new CloudLocation(cloudId, cloudSite.getCloudUrl(), MigrationLocationType.CloudLocation, this.cloudSiteService.getCloudMicrosRegion(cloudSite));
        ServerLocation serverLocation = new ServerLocation(this.systemInformationService.getConfluenceInfo().getBaseUrl(), this.licenseHandler.getServerId(), Collections.singletonMap("confluence", this.senSupplier.get()), MigrationLocationType.ServerLocation);
        RecipeMigrationDetails migrationDetails = new RecipeMigrationDetails(plan.getMigrationScopeId(), plan.getMigrationId(), serverLocation, cloudLocation, new HashMap<String, Object>(), originalPlanId);
        RecipeExecutionRequest.CommonContext commonContext = new RecipeExecutionRequest.CommonContext(migrationDetails);
        Map<String, Object> migrationProperties = this.createV4MigrationProperties(plan, !packs.isEmpty());
        List<AbstractContainer> spaceItemsList = packs.isEmpty() ? this.getSpaceItems(plan) : this.getSpaceItemsFromPacks(packs, plan.getTasks());
        RecipeConstants.Recipe recipe = RecipeConstants.getRecipe(this.migrationDarkFeaturesManager);
        log.info("Creating recipe execution request for migration ID {} with recipe name {} and version {}", new Object[]{plan.getMigrationId(), recipe.getName(), recipe.getVersion()});
        MigrationPlatformService.WorkplanConfigResponse workplanConfigResponse = null;
        if (recipe.getName().equals("confluence-s2c-lithium-migration")) {
            workplanConfigResponse = this.migrationPlatformService.getWorkplanConfig(cloudSite.getContainerToken(), cloudId, cloudLocation.getMicrosRegion(), plan.getMigrationScopeId());
        }
        RecipeContext recipeContext = new RecipeContext(this.getSiteItems(plan), spaceItemsList, migrationProperties, workplanConfigResponse != null ? workplanConfigResponse.getWorkplanConfig() : Collections.emptyMap());
        return new RecipeExecutionRequest(recipe, recipeContext, commonContext, RecipeExecutionRequest.RecipeCommand.START);
    }

    private List<AbstractContainer> buildPackedSpaceContainers(List<Pack> packs, List<Task> tasks) {
        ArrayList<AbstractContainer> containers = new ArrayList<AbstractContainer>();
        Map<String, String> spaceKeyToContainerId = this.buildSpaceKeyToContainerIdMap(tasks);
        for (Pack pack : packs) {
            List<PackedConfluenceSpaceContainer.SpaceInfo> infos = pack.getSpaces().stream().map(s -> this.spaceManager.getSpace(s.getKey())).filter(Objects::nonNull).map(space -> new PackedConfluenceSpaceContainer.SpaceInfo(Long.toString(space.getId()), space.getKey(), space.getName())).collect(Collectors.toList());
            if (infos.isEmpty()) continue;
            String containerId = infos.stream().map(PackedConfluenceSpaceContainer.SpaceInfo::getKey).map(spaceKeyToContainerId::get).filter(Objects::nonNull).findFirst().orElse(null);
            containers.add(new PackedConfluenceSpaceContainer(infos, (Set<ConfluenceSpaceContainer.SpaceSelection>)ImmutableSet.of((Object)((Object)ConfluenceSpaceContainer.SpaceSelection.DATA), (Object)((Object)ConfluenceSpaceContainer.SpaceSelection.ATTACHMENTS)), containerId));
        }
        return containers;
    }

    private Map<String, String> buildSpaceKeyToContainerIdMap(List<Task> tasks) {
        HashMap<String, String> spaceKeyToContainerId = new HashMap<String, String>();
        for (Task task : tasks) {
            if (!(task instanceof AbstractSpaceTask)) continue;
            AbstractSpaceTask spaceTask = (AbstractSpaceTask)task;
            String spaceKey = spaceTask.getSpaceKey();
            String containerId = spaceTask.getContainerId();
            if (spaceKey == null || containerId == null) continue;
            spaceKeyToContainerId.putIfAbsent(spaceKey, containerId);
        }
        return spaceKeyToContainerId;
    }

    private List<AbstractContainer> getSpaceItemsFromPacks(List<Pack> packs, List<Task> tasks) {
        List<AbstractContainer> spaceItems = this.buildPackedSpaceContainers(packs, tasks);
        return spaceItems.isEmpty() ? null : spaceItems;
    }

    public void stopMigrationRecipe(String migrationId, String migrationScopeId, String cloudId, String containerToken) {
        RecipeExecutionActionRequest recipeExecutionActionRequest = new RecipeExecutionActionRequest(RecipeExecutionActionRequest.ActionType.TERMINATE, migrationId);
        if (this.migrationDarkFeaturesManager.isMSEndpointUsageEnabled()) {
            RecipeConstants.Recipe recipe = RecipeConstants.getRecipe(this.migrationDarkFeaturesManager);
            this.migrationPlatformService.stopRecipe(containerToken, migrationId, migrationScopeId, recipeExecutionActionRequest, recipe.getName());
        } else {
            this.enterpriseGatekeeperClient.stopRecipe(recipeExecutionActionRequest, cloudId, containerToken);
        }
        log.info("Triggered stop recipe with migration ID {}, for cloud {}", (Object)migrationId, (Object)cloudId);
    }

    Map<String, Object> createV4MigrationProperties(Plan plan, boolean isSpacePackingEnabled) {
        log.info("Create Migration properties for V4 Migration");
        HashMap<String, Object> migrationProperties = new HashMap<String, Object>();
        Map<String, Object> maxConcurrency = this.getConcurrencyForStep(plan);
        migrationProperties.put("maxConcurrency", maxConcurrency);
        migrationProperties.put("isAttachmentOnlyMigration", plan.isAttachmentOnlyMigration().isPresent() ? plan.isAttachmentOnlyMigration().get() : false);
        migrationProperties.put("isShadowMigration", plan.isShadowMigration());
        migrationProperties.put("isSpacePackingEnabled", isSpacePackingEnabled);
        return migrationProperties;
    }

    private Map<String, Object> getConcurrencyForStep(Plan plan) {
        HashMap<String, Object> maxConcurrency = new HashMap<String, Object>();
        ArrayList<StepType> steps = new ArrayList<StepType>(Arrays.asList(StepType.ATTACHMENT_UPLOAD, StepType.CONFLUENCE_EXPORT, StepType.SPACE_USERS_MIGRATION, StepType.DATA_UPLOAD, StepType.CONFLUENCE_IMPORT));
        int importConcurrencyV4Override = this.getImportConcurrencyV4Override();
        for (StepType step : steps) {
            if (step.equals(StepType.CONFLUENCE_IMPORT)) {
                maxConcurrency.put(step.name(), importConcurrencyV4Override);
                continue;
            }
            maxConcurrency.put(step.name(), this.clusterLimits.getClusterConcurrencyLimit(step, plan));
        }
        return maxConcurrency;
    }

    private int getImportConcurrencyV4Override() {
        List<Double> importConcurrencyV4Override = this.migrationDarkFeaturesManager.getClusterConcurrencyOverrideValues();
        if (importConcurrencyV4Override != null && importConcurrencyV4Override.size() > 8 && importConcurrencyV4Override.get(8) != null) {
            log.info("Import Concurrency V4 override found: {}", (Object)importConcurrencyV4Override.get(8).intValue());
            return Math.min(Math.max(importConcurrencyV4Override.get(8).intValue(), 25), 64);
        }
        log.info("Import Concurrency V4 override not found. Using default value: {}", (Object)25);
        return 25;
    }

    private MigrationStatusCalculator.OverallAppMigrationStatus getAppAggregateStatus(@Nullable @jakarta.annotation.Nullable Progress appProgress) {
        if (appProgress != null && appProgress.getStatus() == ExecutionStatus.FAILED) {
            return MigrationStatusCalculator.OverallAppMigrationStatus.FAILED;
        }
        return null;
    }

    private boolean shouldRetrieveAppsProgress(Plan plan) {
        return plan.getProgress().getStatus().canTriggerAppMigration() && plan.getMigrationId() != null;
    }

    private List<AppsProgressDto.App> getMigratableAppsProgress(String cloudId, String migrationId) {
        List<AppsProgressDto.App> appProgress = this.defaultRegistrar.getAppMigrationServiceClient().getAppProgress(cloudId, migrationId);
        ArrayList<AppsProgressDto.App> result = new ArrayList<AppsProgressDto.App>();
        appProgress.forEach(app -> result.add(new AppsProgressDto.App(this.fixAppNameIfNeeded((AppsProgressDto.App)app), app.getServerAppKey(), app.getContainerId(), app.getCloudAppKey(), app.getCompletionPercent(), app.getStatus(), app.getStatusMessage(), app.getLastUpdatedAt(), app.getAppVendorName(), app.getContactVendorUrl(), app.isCancellable(), app.getNotCancellableTooltip(), app.isReadyToUse(), app.getMultiTransfers())));
        return result;
    }

    private String fixAppNameIfNeeded(AppsProgressDto.App app) {
        Plugin plugin = this.pluginManager.getPlugin(app.getServerAppKey());
        if (plugin != null && app.getServerAppKey().equals(app.getServerAppName())) {
            return plugin.getName();
        }
        return app.getServerAppName();
    }

    private List<AppsProgressDto.App> getInstallOnlyAppsProgress(MigrateAppsTask appsTask) {
        Set<String> appKeys = this.getInstallOnlyApps(appsTask);
        return appKeys.stream().map(key -> this.createStubAppsProgressDto((String)key, 100, AbstractContainer.ContainerStatus.SUCCESS.name(), "You have successfully migrated this app.")).collect(Collectors.toList());
    }

    public MigrationDetails createPreflightInMcs(Plan plan, long count) {
        MigrationCreateRequestV2 createMigrationRequest = new MigrationCreateRequestV2(plan.getName() + " - " + count, this.buildServerLocation(), new CloudLocation(plan.getCloudSite().getCloudId(), plan.getCloudSite().getCloudUrl()), plan.getMigrationTag() == MigrationTag.TEST, this.migrationDarkFeaturesManager.isForceResetFlagEnabled(), this.createMigrationProperties(plan, Optional.empty()), ExecutionType.PREFLIGHT);
        MigrationDetails migrationDetails = this.enterpriseGatekeeperClient.createMigrationV2(plan.getCloudSite().getCloudId(), createMigrationRequest);
        log.info("Created preflight migration with ID {}", (Object)migrationDetails.migrationId);
        return migrationDetails;
    }

    public Optional<String> createPreflightContainer(String cloudId, String preflightId) {
        this.registerContainers(cloudId, preflightId, Collections.singletonList(new SiteContainer((Set<SiteContainer.SiteSelection>)Sets.immutableEnumSet((Enum)SiteContainer.SiteSelection.PREFLIGHTS, (Enum[])new SiteContainer.SiteSelection[0]))));
        SiteContainer container = this.getPreflightContainer(cloudId, preflightId);
        if (container != null) {
            return Optional.of(container.getContainerId());
        }
        log.error("Cannot retrieve preflight container for preflightId {}", (Object)preflightId);
        return Optional.empty();
    }

    public Map<String, String> createPreflightTransfers(String cloudId, String preflightId, String containerId, List<CheckRequest> checkRequests) {
        List<String> operationKeys = checkRequests.stream().map(it -> it.checkType).collect(Collectors.toList());
        HashMap<String, String> transfers = new HashMap<String, String>();
        Optional<TransferResponseList> response = this.createTransfers(cloudId, preflightId, containerId, operationKeys);
        response.ifPresent(transferResponseList -> transfers.putAll(transferResponseList.getTransfers().stream().collect(Collectors.toMap(TransferResponseList.TransferResponse::getOperationKey, TransferResponseList.TransferResponse::getTransferId))));
        return transfers;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public SiteContainer getPreflightContainer(String cloudId, String preflightId) {
        return this.getContainers(cloudId, preflightId, AbstractContainer.ContainerType.Site, false).stream().filter(container -> container.getType() == AbstractContainer.ContainerType.Site).findFirst().map(SiteContainer.class::cast).orElse(null);
    }

    public void queuePreflightStatusUpdate(String cloudId, String preflightId, String containerId, MigrationStatus migrationStatus, AbstractContainer.ContainerStatus containerStatus) {
        this.enterpriseGatekeeperClient.sendMigrationStatusToMCS(preflightId, cloudId, migrationStatus, "");
        this.updateContainersStatus(cloudId, preflightId, containerId, containerStatus, "");
        log.info("Update preflight status to {} for preflightId {} and containerId {}", new Object[]{migrationStatus, preflightId, containerId});
    }

    @NotNull
    private ServerLocation buildServerLocation() {
        return new ServerLocation(this.systemInformationService.getConfluenceInfo().getBaseUrl(), this.licenseHandler.getServerId(), Collections.singletonMap("CONFLUENCE", this.senSupplier.get()));
    }

    public MigrationDetails createMigrationInMcs(String cloudId, Plan plan) {
        Optional<MapiPlanMapping> mapiPlanMapping;
        MigrationDetails migrationDetails;
        Object createMigrationRequest;
        Optional<MapiTaskMapping> mapiTaskMapping = this.mapiTaskMappingService.getTaskMapping(plan.getId(), Optional.of(ImmutableList.of((Object)((Object)MapiTaskStatus.CHECKS_IN_PROGRESS), (Object)((Object)MapiTaskStatus.CHECKS_COMPLETED))), Optional.of(ImmutableList.of((Object)CommandName.MIGRATE.getValue())));
        RecipeConstants.Recipe recipe = RecipeConstants.getRecipe(this.migrationDarkFeaturesManager);
        List<String> executionTags = Collections.singletonList(recipe.getTag());
        if (this.migrationDarkFeaturesManager.isTccV2EndpointEnabled()) {
            createMigrationRequest = new MigrationCreateRequestV2(plan.getName(), this.buildServerLocation(), new CloudLocation(cloudId, plan.getCloudSite().getCloudUrl()), plan.getMigrationTag() == MigrationTag.TEST, this.migrationDarkFeaturesManager.isForceResetFlagEnabled(), this.createMigrationProperties(plan, mapiTaskMapping), ExecutionType.LIVE_RUN);
            log.debug("Using the TCC v2 endpoint");
            migrationDetails = this.enterpriseGatekeeperClient.createMigrationV2(cloudId, (MigrationCreateRequestV2)createMigrationRequest);
        } else {
            createMigrationRequest = new MigrationCreateRequest(plan.getName(), this.buildServerLocation(), new CloudLocation(cloudId, plan.getCloudSite().getCloudUrl()), plan.getMigrationTag() == MigrationTag.TEST, this.migrationDarkFeaturesManager.isForceResetFlagEnabled(), Optional.ofNullable(plan.getMigrationProtocol()).map(MigrationProtocol::getPlatformVersion).orElse(null), this.createMigrationProperties(plan, mapiTaskMapping), executionTags);
            log.debug("Using the TCC v1 endpoint");
            migrationDetails = this.enterpriseGatekeeperClient.createMigration(cloudId, (MigrationCreateRequest)createMigrationRequest);
        }
        if (mapiTaskMapping.isPresent() && (mapiPlanMapping = this.mapiPlanMappingService.getMapiPlanMapping(mapiTaskMapping.get().getJobId())).isPresent()) {
            mapiPlanMapping.get().setMigrationId(migrationDetails.migrationId);
            this.mapiPlanMappingService.saveMapiPlanMapping(mapiPlanMapping.get());
        }
        log.info("Created migration with ID {}, for cloud {}", (Object)migrationDetails.migrationId, (Object)cloudId);
        List<String> enabledMigrationFeatures = this.featureFlagService.getAllEnabledMigrationFeatures();
        this.featureFlagService.saveFeatureFlagAnalyticEvent(FeatureFlagActionSubject.PLAN, plan.getId(), enabledMigrationFeatures.toString());
        log.info("Enabled Migration plugin feature flags for migrationId {} are {}", (Object)migrationDetails.migrationId, enabledMigrationFeatures);
        return migrationDetails;
    }

    public String getCachedOrCreateMigrationScopeId(CloudSite cloudSite) {
        return (String)this.migrationScopeCache.get((Object)cloudSite.getCloudId(), () -> this.createMigrationScopeInMcs(cloudSite));
    }

    protected String createMigrationScopeInMcs(CloudSite cloudSite) {
        MigrationScopeCreateRequest migrationScopeCreateRequest = new MigrationScopeCreateRequest(new ServerLocation(this.systemInformationService.getConfluenceInfo().getBaseUrl(), this.licenseHandler.getServerId(), Collections.singletonMap("CONFLUENCE", this.senSupplier.get())), new CloudLocation(cloudSite.getCloudId(), cloudSite.getCloudUrl()));
        String migrationScopeId = this.enterpriseGatekeeperClient.createMigrationScope(cloudSite.getCloudId(), migrationScopeCreateRequest).getMigrationScopeId();
        log.info("Received migration scope id: {} for cloudId: {}", (Object)migrationScopeId, (Object)cloudSite.getCloudId());
        return migrationScopeId;
    }

    public void createContainersInMcs(String cloudId, String migrationId, Plan plan) {
        this.registerContainers(cloudId, migrationId, new ArrayList<AbstractContainer>(this.createProductContainers(plan.getTasks())));
    }

    public void createContainersInMcs(String cloudId, String migrationId, Plan plan, List<Pack> packs) {
        HashSet<SiteContainer.SiteSelection> siteSelections = new HashSet<SiteContainer.SiteSelection>();
        for (Task task : plan.getTasks()) {
            if (task instanceof MigrateUsersTask) {
                siteSelections.add(SiteContainer.SiteSelection.USERS);
                continue;
            }
            if (!(task instanceof MigrateGlobalEntitiesTask)) continue;
            siteSelections.add(SiteContainer.SiteSelection.GLOBAL_ENTITIES);
        }
        ArrayList<AbstractContainer> containers = new ArrayList<AbstractContainer>(this.buildPackedSpaceContainers(packs, plan.getTasks()));
        if (!siteSelections.isEmpty()) {
            containers.add(new SiteContainer(siteSelections));
        }
        this.registerContainers(cloudId, migrationId, containers);
    }

    public boolean updateSpaceContainerStatuses(Plan plan) {
        try {
            log.info("Updating the space container statuses for plan {}", (Object)plan.getId());
            Set<ConfluenceSpaceContainer> containerDetails = this.getConfluenceSpaceContainers(plan);
            this.callUpdateContainerStatusAPI(plan, containerDetails);
        }
        catch (Exception e) {
            log.warn("Status Update for space container in given plan {} failed. Exception:  ", (Object)plan.getId(), (Object)e);
            return false;
        }
        return this.pollForContainerStatus(plan);
    }

    public MigrationDomainsAllowlistResponse getDomainAllowList(String cloudId) {
        return this.enterpriseGatekeeperClient.getDomainAllowlist(cloudId);
    }

    private void registerContainers(String cloudId, String migrationId, List<AbstractContainer> allContainers) {
        Lists.partition(allContainers, (int)250).forEach(containers -> this.enterpriseGatekeeperClient.createContainers(cloudId, migrationId, new ContainerCreateRequest((List<AbstractContainer>)containers)));
        log.info("Created containers for migrationId {}", (Object)migrationId);
    }

    public Set<ConfluenceSpaceContainer> getConfluenceSpaceContainers(Plan plan) {
        return this.getContainers(plan.getCloudSite().getCloudId(), plan.getMigrationId(), AbstractContainer.ContainerType.ConfluenceSpace, false).stream().map(ConfluenceSpaceContainer.class::cast).collect(Collectors.toSet());
    }

    public Set<PackedConfluenceSpaceContainer> getPackedConfluenceSpaceContainers(Plan plan) {
        return this.getContainers(plan.getCloudSite().getCloudId(), plan.getMigrationId(), AbstractContainer.ContainerType.PackedConfluenceSpace, false).stream().map(PackedConfluenceSpaceContainer.class::cast).collect(Collectors.toSet());
    }

    public Set<SiteContainer> getSiteContainers(Plan plan) {
        return this.getContainers(plan.getCloudSite().getCloudId(), plan.getMigrationId(), AbstractContainer.ContainerType.Site, false).stream().map(SiteContainer.class::cast).collect(Collectors.toSet());
    }

    private boolean pollForContainerStatus(Plan plan) {
        RetryPolicy retryPolicy = (RetryPolicy)new RetryPolicy().withMaxRetries(5).withDelay(2L, 4L, ChronoUnit.SECONDS).withMaxDuration(Duration.ofMinutes(1L)).handleResultIf(hasContainersWithReadyStatus -> hasContainersWithReadyStatus);
        return (Boolean)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.hasContainerWithReadyStatusForSuccessfulSpaces(plan)) == false;
    }

    private boolean hasContainerWithReadyStatusForSuccessfulSpaces(Plan plan) {
        ArrayList<AbstractContainer> containers = new ArrayList<AbstractContainer>();
        Set unsuccessfulSpaceKeys = plan.getTasks().stream().filter(ConfluenceSpaceTask.class::isInstance).filter(spaceTask -> spaceTask.getProgress().getStatus().isUnsuccessful()).map(ConfluenceSpaceTask.class::cast).map(AbstractSpaceTask::getSpaceKey).collect(Collectors.toSet());
        String nextId = "";
        do {
            ContainersFetchResponse response = this.enterpriseGatekeeperClient.getContainersByStatusForMigration(plan.getCloudSite().getCloudId(), plan.getMigrationId(), ContainerType.ConfluenceSpace, AbstractContainer.ContainerStatus.READY, 250, nextId);
            List<AbstractContainer> containersInPage = response.getContainers();
            nextId = response.getNextId();
            if (containersInPage == null) continue;
            containers.addAll(containersInPage);
        } while (nextId != null);
        List successfulSpaceContainerWithReadyStatus = containers.stream().filter(ConfluenceSpaceContainer.class::isInstance).map(ConfluenceSpaceContainer.class::cast).filter(confluenceSpaceContainer -> !unsuccessfulSpaceKeys.contains(confluenceSpaceContainer.getKey())).collect(Collectors.toList());
        log.info("Number of successful spaces for plan {} with status READY in MCS: {} ", (Object)plan.getId(), (Object)successfulSpaceContainerWithReadyStatus.size());
        return !successfulSpaceContainerWithReadyStatus.isEmpty();
    }

    public MigrationAppAggregatorService.Hosting getHosting() {
        return this.licenseHandler.getAllProductLicenses().stream().anyMatch(BaseLicenseDetails::isDataCenter) ? MigrationAppAggregatorService.Hosting.datacenter : MigrationAppAggregatorService.Hosting.server;
    }

    public void callUpdateContainerStatusAPI(Plan plan, Set<ConfluenceSpaceContainer> containerDetails) {
        Map<String, Progress> spaceTasks = this.getSpaceProgressMap(plan);
        containerDetails.forEach(containerDetail -> this.updateContainersStatus(plan.getCloudSite().getCloudId(), plan.getMigrationId(), containerDetail.getContainerId(), ((Progress)spaceTasks.get(containerDetail.getKey())).getStatus().getContainerStatus(), ((Progress)spaceTasks.get(containerDetail.getKey())).getMessage()));
    }

    @NotNull
    private Map<String, Progress> getSpaceProgressMap(Plan plan) {
        return plan.getTasks().stream().filter(ConfluenceSpaceTask.class::isInstance).map(ConfluenceSpaceTask.class::cast).collect(Collectors.toMap(AbstractSpaceTask::getSpaceKey, Task::getProgress));
    }

    public void updateContainersStatus(String cloudId, String migrationId, String containerId, AbstractContainer.ContainerStatus status, String statusMessage) {
        this.enterpriseGatekeeperClient.updateContainerStatus(cloudId, migrationId, containerId, status, statusMessage);
        log.info("Updated migration status with container ID {}, for migration {} on cloud {}", new Object[]{containerId, migrationId, cloudId});
    }

    private List<AbstractContainer> createProductContainers(List<Task> tasks) {
        ArrayList<AbstractContainer> containers = new ArrayList<AbstractContainer>();
        HashSet<SiteContainer.SiteSelection> siteSelections = new HashSet<SiteContainer.SiteSelection>();
        for (Task task : tasks) {
            Space space;
            AbstractSpaceTask spaceTask;
            if (task instanceof ConfluenceSpaceTask) {
                spaceTask = (ConfluenceSpaceTask)task;
                space = this.spaceManager.getSpace(spaceTask.getSpaceKey());
                if (!Objects.nonNull(space)) continue;
                containers.add(new ConfluenceSpaceContainer(Long.toString(space.getId()), spaceTask.getSpaceKey(), space.getName(), (Set<ConfluenceSpaceContainer.SpaceSelection>)ImmutableSet.of((Object)((Object)ConfluenceSpaceContainer.SpaceSelection.DATA), (Object)((Object)ConfluenceSpaceContainer.SpaceSelection.ATTACHMENTS))));
                continue;
            }
            if (task instanceof SpaceAttachmentsOnlyTask) {
                spaceTask = (SpaceAttachmentsOnlyTask)task;
                space = this.spaceManager.getSpace(spaceTask.getSpaceKey());
                if (!Objects.nonNull(space)) continue;
                containers.add(new ConfluenceSpaceContainer(Long.toString(space.getId()), spaceTask.getSpaceKey(), space.getName(), (Set<ConfluenceSpaceContainer.SpaceSelection>)ImmutableSet.of((Object)((Object)ConfluenceSpaceContainer.SpaceSelection.ATTACHMENTS))));
                continue;
            }
            if (task instanceof MigrateUsersTask) {
                siteSelections.add(SiteContainer.SiteSelection.USERS);
                continue;
            }
            if (!(task instanceof MigrateGlobalEntitiesTask)) continue;
            siteSelections.add(SiteContainer.SiteSelection.GLOBAL_ENTITIES);
        }
        if (!siteSelections.isEmpty()) {
            containers.add(new SiteContainer(siteSelections));
        }
        return containers;
    }

    @Deprecated
    public void createAppContainers(String cloudId, String migrationId, List<Task> tasks, boolean createAppContainersForAllListeners) {
        Set<Object> appKeys = null;
        if (!createAppContainersForAllListeners) {
            Optional<MigrateAppsTask> migrateTask = tasks.stream().filter(MigrateAppsTask.class::isInstance).map(MigrateAppsTask.class::cast).findAny();
            if (migrateTask.isPresent()) {
                MigrateAppsTask appsTask = migrateTask.get();
                appKeys = this.getAutomatedServerAppKeysForMigration(appsTask, false);
            } else {
                appKeys = Collections.emptySet();
                log.info("No MigrateAppsTask found in the plan. No app containers will be created for migration {}", (Object)migrationId);
            }
        }
        this.createAppContainers(cloudId, migrationId, appKeys);
    }

    public void createAppContainers(String cloudId, String migrationId, @Nullable @jakarta.annotation.Nullable Set<String> serverAppKeysFilter) {
        log.info("Selected apps to participate in migration {}: {}", (Object)migrationId, serverAppKeysFilter);
        Set<String> appKeys = serverAppKeysFilter == null ? this.defaultRegistrar.getRegisteredServerKeys() : serverAppKeysFilter;
        this.appListenerIssueService.getAppProblemMessages(appKeys).forEach(arg_0 -> ((Logger)log).warn(arg_0));
        List<AbstractContainer> containers = appKeys.stream().flatMap(serverAppKey -> this.defaultRegistrar.getRegisteredCloudKeys((String)serverAppKey).stream().map(cloudAppKey -> {
            Plugin plugin = this.pluginManager.getPlugin((String)serverAppKey);
            String version = plugin != null ? plugin.getPluginInformation().getVersion() : "";
            return new AppContainer((String)serverAppKey, (String)cloudAppKey, Collections.singletonMap("pluginVersion", version));
        })).collect(Collectors.toList());
        log.info("App containers to be created in MCS for migration {}: {}", (Object)migrationId, containers.stream().map(Object::toString).collect(Collectors.toList()));
        this.registerContainers(cloudId, migrationId, containers);
    }

    private Set<String> getAutomatedServerAppKeysForMigration(MigrateAppsTask migrateAppsTask, boolean includeInstallOnly) {
        Sets.SetView<String> difference = this.appsToBeConsidered(migrateAppsTask);
        return difference.stream().filter(neededInCloudApp -> this.pluginManager.isPluginInstalled((String)neededInCloudApp) != false && (includeInstallOnly || this.appAggregatorService.getCachedServerAppData((String)neededInCloudApp).getMigrationPath().equals((Object)MigrationPath.AUTOMATED))).collect(Collectors.toSet());
    }

    private Set<String> getInstallOnlyApps(MigrateAppsTask migrateAppsTask) {
        return this.appsToBeConsidered(migrateAppsTask).stream().filter(appKey -> this.pluginManager.isPluginInstalled((String)appKey) != false && this.appAggregatorService.getCachedServerAppData((String)appKey).getMigrationPath().equals((Object)MigrationPath.INSTALL_ONLY)).collect(Collectors.toSet());
    }

    @NotNull
    private Sets.SetView<String> appsToBeConsidered(MigrateAppsTask migrateAppsTask) {
        Set appsNeededInCloud = migrateAppsTask.getNeededInCloudApps().stream().map(NeededInCloudApp::getAppKey).collect(Collectors.toSet());
        Set excludedServerAppKeys = migrateAppsTask.getExcludedApps().stream().map(ExcludeApp::getAppKey).collect(Collectors.toSet());
        return Sets.difference(appsNeededInCloud, excludedServerAppKeys);
    }

    @NotNull
    private Map<String, Object> createMigrationProperties(Plan plan, Optional<MapiTaskMapping> mapiTaskMapping) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("PluginVersion", this.pluginVersionManager.getPluginVersion());
        properties.put("Hosting", this.getHosting().toString());
        if (plan.getMigrationProtocol() == MigrationProtocol.V4) {
            properties.put("migrationAnalyticsEnabled", true);
        }
        ConfluenceLicenseDetails confluenceLicenseDetails = this.senSupplier.getLicenseDetails();
        properties.put(LICENSES_PROPERTIES_ENTRY, confluenceLicenseDetails.toMigrationProperties());
        if (mapiTaskMapping.isPresent()) {
            HashMap<String, String> mapiMetadata = new HashMap<String, String>();
            mapiMetadata.put("jobId", mapiTaskMapping.get().getJobId());
            mapiMetadata.put("taskId", mapiTaskMapping.get().getTaskId());
            properties.put("mapi", mapiMetadata);
        }
        properties.put("UsersGroupsMigrationOption", ImmutableMap.of((Object)"mode", (Object)plan.getUserMigrationTypeBasedOnUserTaskInPlan().name()));
        properties.put("EnabledDarkFeatureFlags", this.featureFlagService.getEnabledMigrationDarkFeatures());
        properties.put("EnabledFeatureFlags", this.featureFlagService.getEnabledMigrationPluginFeatures());
        properties.put("EnabledDynamicConfigs", this.featureFlagService.getEnabledMigrationDynamicConfigsWithValues());
        Map<ConcurrencySettingsEnum, Integer> concurrencySettings = this.concurrencySettingsService.getSettings(Optional.of(plan));
        Map<String, Integer> concurrencyMap = concurrencySettings.entrySet().stream().collect(Collectors.toMap(entry -> ((ConcurrencySettingsEnum)((Object)((Object)entry.getKey()))).name(), Map.Entry::getValue));
        properties.put("concurrency", concurrencyMap);
        plan.getGlobalEntityTaskOfPlan().ifPresent(task -> properties.put("GlobalEntitiesMigrationOption", ImmutableMap.of((Object)"mode", (Object)task.name())));
        plan.getAppsMigrationTaskOfPlan().ifPresent(task -> properties.put("AppsMigrationOption", ImmutableMap.of((Object)"neededInCloudApps", task.getNeededInCloudApps().stream().map(NeededInCloudApp::getAppKey).collect(Collectors.toList()), (Object)"excludedApps", task.getExcludedApps().stream().map(ExcludeApp::getAppKey).collect(Collectors.toList()))));
        plan.isAttachmentOnlyMigration().ifPresent(isAttachmentOnlyMigration -> properties.put("SpaceDataMigrationMode", (isAttachmentOnlyMigration != false ? SpaceMode.ATTACHMENTS : SpaceMode.ALL).name()));
        ImmutableMap databaseInfoMap = Optional.ofNullable(this.systemInformationService.getDatabaseInfo()).map(it -> ImmutableMap.of((Object)"name", (Object)Optional.ofNullable(it.getName()).orElse(""), (Object)"version", (Object)Optional.ofNullable(it.getVersion()).orElse(""))).orElse(ImmutableMap.of());
        properties.put("DatabaseInfo", databaseInfoMap);
        return properties;
    }

    private AppsProgressDto.App createStubAppsProgressDto(String appKey, int percentComplete, String status, String statusMessage) {
        MigrationAppAggregatorResponse appAggregatorResponse = this.appAggregatorService.getCachedServerAppData(appKey);
        return AppsProgressDto.App.builder().serverAppKey(appKey).cloudAppKey(appAggregatorResponse != null ? appAggregatorResponse.getCloudKey() : "(Unknown)").serverAppName(AppAssessmentFacade.getAppName(appKey, this.pluginManager, appAggregatorResponse)).appVendorName(this.getVendorName(appKey, appAggregatorResponse)).contactVendorUrl(this.getVendorUrl(appKey, appAggregatorResponse)).completionPercent(percentComplete).status(status).statusMessage(statusMessage).lastUpdatedAt(null).isCancellable(false).build();
    }

    private String getVendorName(String appKey, @Nullable @jakarta.annotation.Nullable MigrationAppAggregatorResponse appAggregatorResponse) {
        String maaVendorName;
        String string = maaVendorName = appAggregatorResponse != null ? appAggregatorResponse.getVendorName() : "";
        if (!StringUtils.isEmpty((String)maaVendorName)) {
            return maaVendorName;
        }
        Plugin plugin = this.pluginManager.getPlugin(appKey);
        return plugin != null ? plugin.getPluginInformation().getVendorName() : "";
    }

    protected List<AbstractContainer> getAllItems(Plan plan) {
        List<AbstractContainer> items = this.getSpaceItems(plan);
        items.add(this.getSiteItems(plan));
        return items;
    }

    @VisibleForTesting
    SiteContainer getSiteItems(Plan plan) {
        UserMigrationType userMigrationType = plan.getUserMigrationTypeBasedOnUserTaskInPlan();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (userMigrationType == UserMigrationType.NONE) {
            return null;
        }
        if (userMigrationType == UserMigrationType.SCOPED) {
            properties.put("isScoped", Boolean.TRUE.toString());
        }
        HashSet<SiteContainer.SiteSelection> siteSelections = new HashSet<SiteContainer.SiteSelection>();
        siteSelections.add(SiteContainer.SiteSelection.USERS);
        Optional<MigrateGlobalEntitiesTask> gtTask = plan.getGlobalEntitiesTaskOfPlan();
        String containerId = null;
        if (gtTask.isPresent()) {
            siteSelections.add(SiteContainer.SiteSelection.GLOBAL_ENTITIES);
            containerId = gtTask.get().getContainerId();
        }
        return new SiteContainer(siteSelections, properties, containerId);
    }

    @VisibleForTesting
    private Map<String, Object> getAppMigrationItems(Plan plan) {
        HashMap<String, Object> appMigrationItems = new HashMap<String, Object>();
        Optional<MigrateAppsTask> maybeMigrateAppsTask = DefaultPlanService.getMigrateAppsTask(plan);
        if (maybeMigrateAppsTask.isPresent()) {
            MigrateAppsTask migrateAppsTask = maybeMigrateAppsTask.get();
            appMigrationItems.put("migrate", true);
            appMigrationItems.put("includedCloudApps", migrateAppsTask.getNeededInCloudApps());
            appMigrationItems.put("excludedAppsRequested", migrateAppsTask.getExcludedApps());
        }
        return appMigrationItems;
    }

    @VisibleForTesting
    List<AbstractContainer> getSpaceItems(Plan plan) {
        ArrayList<AbstractContainer> spaceItems = new ArrayList<AbstractContainer>();
        for (Task task : plan.getTasks()) {
            AbstractSpaceTask confluenceSpaceTask;
            Space space;
            if (!(task instanceof AbstractSpaceTask) || !Objects.nonNull(space = this.spaceManager.getSpace((confluenceSpaceTask = (AbstractSpaceTask)task).getSpaceKey()))) continue;
            if (task instanceof ConfluenceSpaceTask) {
                spaceItems.add(new ConfluenceSpaceContainer(String.valueOf(space.getId()), confluenceSpaceTask.getSpaceKey(), (Set<ConfluenceSpaceContainer.SpaceSelection>)ImmutableSet.of((Object)((Object)ConfluenceSpaceContainer.SpaceSelection.DATA), (Object)((Object)ConfluenceSpaceContainer.SpaceSelection.ATTACHMENTS)), task.getContainerId()));
                continue;
            }
            if (!(task instanceof SpaceAttachmentsOnlyTask)) continue;
            spaceItems.add(new ConfluenceSpaceContainer(String.valueOf(space.getId()), confluenceSpaceTask.getSpaceKey(), (Set<ConfluenceSpaceContainer.SpaceSelection>)ImmutableSet.of((Object)((Object)ConfluenceSpaceContainer.SpaceSelection.ATTACHMENTS))));
        }
        return spaceItems.isEmpty() ? null : spaceItems;
    }

    public Pair<PlatformMigrationStatus, List<AbstractContainer>> getContainersWithTransfers(String cloudId, String migrationId) {
        ContainersFetchResponse response;
        ArrayList<AbstractContainer> result = new ArrayList<AbstractContainer>();
        PlatformMigrationStatus status = null;
        String nextId = null;
        do {
            response = this.enterpriseGatekeeperClient.getContainersForMigration(cloudId, migrationId, null, 250, nextId, true, false);
            status = response.getStatus();
            result.addAll(response.getContainers());
        } while ((nextId = response.getNextId()) != null);
        return new Pair((Object)(status != null ? status : PlatformMigrationStatus.READY), result);
    }

    private String getVendorUrl(String appKey, @Nullable @jakarta.annotation.Nullable MigrationAppAggregatorResponse appAggregatorResponse) {
        String maaContactVendorUrl;
        String string = maaContactVendorUrl = appAggregatorResponse != null ? appAggregatorResponse.getContactSupportUrl() : "";
        if (!StringUtils.isEmpty((String)maaContactVendorUrl)) {
            return maaContactVendorUrl;
        }
        Plugin plugin = this.pluginManager.getPlugin(appKey);
        return plugin != null ? plugin.getPluginInformation().getVendorUrl() : "";
    }

    public void updateMigrationStatusToMcs(Plan plan) {
        ExecutionStatus status = plan.getProgress().getStatus();
        MigrationStatus migrationStatus = MigrationStatus.convertStatusToMigrationStatus(status, Optional.empty());
        String cloudId = plan.getCloudSite().getCloudId();
        try {
            this.enterpriseGatekeeperClient.sendMigrationStatusToMCS(plan.getMigrationId(), cloudId, migrationStatus, plan.getProgress().getMessage());
        }
        catch (Exception e) {
            log.error("Error sending migration status to MCS for migrationID: {}. Error: {}", new Object[]{plan.getMigrationId(), e.getMessage(), e});
        }
    }

    public Optional<TransferResponseList> createTransfers(String cloudId, String migrationId, String containerId, List<String> operationKeys) {
        try {
            return Optional.of(this.enterpriseGatekeeperClient.createTransfers(cloudId, migrationId, containerId, operationKeys));
        }
        catch (Exception e) {
            log.error("Error creating transfers for containerId: {} in migrationId: {}. Error: {}", new Object[]{containerId, migrationId, e.getMessage(), e});
            return Optional.empty();
        }
    }

    public void updateTransferProgress(String cloudId, String migrationId, String transferId, TransferProgressRequest transferProgressRequest) {
        try {
            this.enterpriseGatekeeperClient.updateTransferProgress(cloudId, migrationId, transferId, transferProgressRequest);
        }
        catch (Exception e) {
            log.debug("Error updating transfer progress for transferId: {} in migrationId: {}. Error: {}", new Object[]{transferId, migrationId, e.getMessage(), e});
            this.sendMCSTransferStatusProgressErrorOperationalEvent(PROGRESS, transferId, migrationId, cloudId, Optional.ofNullable(e.getMessage()));
        }
    }

    public void updateTransferStatus(String cloudId, String migrationId, String transferId, TransferStatus status, String statusMessage) {
        try {
            this.enterpriseGatekeeperClient.updateTransferStatus(cloudId, migrationId, transferId, status, statusMessage);
        }
        catch (Exception e) {
            log.error("Error updating transfer status for transferId: {} in migrationId: {}. Error: {}", new Object[]{transferId, migrationId, e.getMessage(), e});
            this.sendMCSTransferStatusProgressErrorOperationalEvent(STATUS, transferId, migrationId, cloudId, Optional.ofNullable(e.getMessage()));
        }
    }

    public void updateTransferStatus(String cloudId, String migrationId, String transferId, TransferStatusesUpdateRequest request) {
        try {
            log.info("Updating transfer status for transferId: {} in migrationId: {} with request: {}", new Object[]{transferId, migrationId, request});
            this.enterpriseGatekeeperClient.updateTransferStatus(cloudId, migrationId, transferId, request);
        }
        catch (Exception e) {
            log.error("Error updating transfer status for transferId: {} in migrationId: {}. Error: {}", new Object[]{transferId, migrationId, e.getMessage(), e});
            this.sendMCSTransferStatusProgressErrorOperationalEvent(STATUS, transferId, migrationId, cloudId, Optional.ofNullable(e.getMessage()));
        }
    }

    private void sendMCSTransferStatusProgressErrorOperationalEvent(String eventType, String actionSubjectId, String migrationId, String cloudId, Optional<String> errorReason) {
        this.analyticsEventService.sendAnalyticsEventsAsync(() -> ImmutableList.of((Object)this.mcsAnalyticsEventBuilder.buildMCSTransferStatusProgressUpdateOperationalEvent(eventType, actionSubjectId, migrationId, cloudId, "EG", errorReason)));
    }
}

