/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.model.stats.SpaceStats;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.exception.SpacePackingException;
import com.atlassian.migration.agent.service.packing.Pack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacePackingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpacePackingService.class);
    private final StatisticsService statisticsService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public SpacePackingService(StatisticsService statisticsService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.statisticsService = statisticsService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public List<Pack> applySpacePackingLogic(Plan plan) {
        log.info("Applying space packing logic for plan: {}", (Object)plan.getId());
        List<ConfluenceSpaceTask> confluenceSpaceTasks = this.getConfluenceSpaceTasksFromPlan(plan);
        log.info("Found {} ConfluenceSpaceTask in plan", (Object)confluenceSpaceTasks.size());
        int minSpacesForPacking = this.migrationDarkFeaturesManager.getMinSpacesForSpacePacking();
        if (confluenceSpaceTasks.size() < minSpacesForPacking) {
            log.info("Plan contains less than {} space tasks, skipping packing", (Object)minSpacesForPacking);
            return new ArrayList<Pack>();
        }
        return this.packSpacesByPageCount(confluenceSpaceTasks);
    }

    private List<ConfluenceSpaceTask> getConfluenceSpaceTasksFromPlan(Plan plan) {
        return plan.getSpaceTaskOfPlan().stream().filter(ConfluenceSpaceTask.class::isInstance).map(ConfluenceSpaceTask.class::cast).collect(Collectors.toList());
    }

    private List<Pack> packSpacesByPageCount(List<ConfluenceSpaceTask> spaceTasks) {
        int maxPagesPerPack = this.migrationDarkFeaturesManager.getMaxPagesPerPack();
        int maxSpacesPerPack = this.migrationDarkFeaturesManager.getMaxSpacesPerPack();
        log.info("Starting space packing for {} tasks with maxPagesPerPack {}", (Object)spaceTasks.size(), (Object)maxPagesPerPack);
        ArrayList<Pack.PackedSpace> packableSpaces = new ArrayList<Pack.PackedSpace>();
        for (ConfluenceSpaceTask confluenceSpaceTask : spaceTasks) {
            String spaceKey = confluenceSpaceTask.getSpaceKey();
            Long spacePageCount = this.getPageCountForSpace(spaceKey);
            packableSpaces.add(new Pack.PackedSpace(spaceKey, spacePageCount));
        }
        packableSpaces.sort(Comparator.comparingLong(Pack.PackedSpace::getNumberOfPages).reversed());
        log.info("Sorted {} packable spaces by page count", (Object)packableSpaces.size());
        ArrayList<Pack> packs = new ArrayList<Pack>();
        for (Pack.PackedSpace spaceWithPageCount : packableSpaces) {
            boolean placed = false;
            for (Pack pack : packs) {
                if (pack.getSpaces().size() >= maxSpacesPerPack || pack.getTotalPageCount() + spaceWithPageCount.getNumberOfPages() > (long)maxPagesPerPack) continue;
                pack.addSpace(spaceWithPageCount.getKey(), spaceWithPageCount.getNumberOfPages());
                placed = true;
                break;
            }
            if (placed) continue;
            Pack newPack = new Pack();
            newPack.addSpace(spaceWithPageCount.getKey(), spaceWithPageCount.getNumberOfPages());
            packs.add(newPack);
        }
        int n = packableSpaces.size();
        log.info("Space packing completed. Created {} packs from {} spaces", (Object)packs.size(), (Object)n);
        return packs;
    }

    private Long getPageCountForSpace(String spaceKey) {
        SpaceStats spaceStats = this.statisticsService.loadSpaceStatistics(spaceKey);
        if (spaceStats == null) {
            log.error("No statistics found for space {}", (Object)spaceKey);
            throw new SpacePackingException("No statistics found for space " + spaceKey);
        }
        Long pageCount = spaceStats.getSummary().getNumberOfPages();
        if (pageCount == null) {
            log.error("Page count is null for space {}", (Object)spaceKey);
            throw new SpacePackingException("Page count is null for space " + spaceKey);
        }
        return pageCount;
    }
}

