/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.scheduler;

import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

public final class JobConfigBuilder {
    private JobConfig jobConfig;
    private final ClassLoader classLoader;
    private static final Logger log = ContextLoggerFactory.getLogger(JobConfigBuilder.class);

    private JobConfigBuilder() {
        this.classLoader = null;
    }

    JobConfigBuilder(JobRunnerKey jobRunnerKey, ClassLoader classLoader) {
        this.jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey);
        this.classLoader = classLoader;
        this.withRunMode(this.jobConfig.getRunMode());
    }

    public static JobConfigBuilder forJobRunnerKey(JobRunnerKey jobRunnerKey) {
        JobConfigBuilder jobConfigBuilder = new JobConfigBuilder();
        jobConfigBuilder.jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey);
        jobConfigBuilder.withRunMode(jobConfigBuilder.jobConfig.getRunMode());
        return jobConfigBuilder;
    }

    public JobConfigBuilder withSchedule(Schedule schedule) {
        this.jobConfig = this.jobConfig.withSchedule(schedule);
        return this;
    }

    public JobConfigBuilder withParameters(Map<String, Serializable> parameters) {
        this.jobConfig = this.jobConfig.withParameters(parameters);
        return this;
    }

    public JobConfigBuilder withRunMode(RunMode runMode) {
        this.jobConfig = this.jobConfig.withRunMode(runMode);
        if (runMode == RunMode.RUN_ONCE_PER_CLUSTER) {
            this.withCancelOnTimeout();
        }
        return this;
    }

    public JobConfigBuilder withCancelOnTimeout() {
        this.getCancelOnTimeoutPolicy().ifPresent(policy -> this.addParameters((Map<String, Serializable>)ImmutableMap.of((Object)"com.atlassian.confluence.schedule.AbstractManagedScheduledJob.timeout_policy", (Object)policy)));
        return this;
    }

    public JobConfigBuilder withRunOnTimeout() {
        this.getRunOnTimeoutPolicy().ifPresent(policy -> this.addParameters((Map<String, Serializable>)ImmutableMap.of((Object)"com.atlassian.confluence.schedule.AbstractManagedScheduledJob.timeout_policy", (Object)policy)));
        return this;
    }

    private void addParameters(Map<String, Serializable> map) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(this.jobConfig.getParameters());
        params.putAll(map);
        this.jobConfig = this.jobConfig.withParameters(params);
    }

    public JobConfig build() {
        return this.jobConfig;
    }

    private Optional<Serializable> getCancelOnTimeoutPolicy() {
        return this.getPolicy("CANCEL_ON_TIMEOUT");
    }

    private Optional<Serializable> getRunOnTimeoutPolicy() {
        return this.getPolicy("RUN_ON_TIMEOUT");
    }

    private Optional<Serializable> getPolicy(String policyName) {
        try {
            ClassLoader cl = this.getClassLoader();
            Class<?> timeoutPolicyClass = cl.loadClass("com.atlassian.confluence.impl.schedule.caesium.TimeoutPolicy");
            return Optional.of(Enum.valueOf(timeoutPolicyClass, policyName));
        }
        catch (Exception e) {
            log.warn("TimeoutPolicy class not found, cannot set {} policy", (Object)policyName, (Object)e);
            return Optional.empty();
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return (ClassLoader)ContainerManager.getComponent((String)"uberClassLoader", ClassLoader.class);
    }

    public String toString() {
        return this.jobConfig.toString();
    }
}

