/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.CloudSiteDto;
import com.atlassian.migration.agent.entity.CloudEdition;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.mma.model.token.SaveTokenRequest;
import com.atlassian.migration.agent.mma.model.token.SaveTokenResponse;
import com.atlassian.migration.agent.okhttp.HttpServiceException;
import com.atlassian.migration.agent.rest.GenerateCloudSiteSetupUrlDto;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.service.NetworkStatisticsService;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.cloud.CloudSiteSetupService;
import com.atlassian.migration.agent.service.cloud.ContainerTokenService;
import com.atlassian.migration.agent.service.cloud.LegalService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

@ParametersAreNonnullByDefault
@Path(value="cloud")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CloudResource {
    public static final String ACTION = "save";
    public static final String SUBJECT = "containerToken";
    private final CloudSiteService cloudSiteService;
    private final LegalService legalService;
    private final CloudSiteSetupService cloudSiteSetupService;
    private final NetworkStatisticsService networkStatisticsService;
    private final ContainerTokenService containerTokenService;
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private static final Logger log = ContextLoggerFactory.getLogger(CloudResource.class);

    @Inject
    public CloudResource(CloudSiteService cloudSiteService, LegalService legalService, CloudSiteSetupService cloudSiteSetupService, NetworkStatisticsService networkStatisticsService, ContainerTokenService containerTokenService, AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder) {
        this.cloudSiteService = cloudSiteService;
        this.legalService = legalService;
        this.cloudSiteSetupService = cloudSiteSetupService;
        this.networkStatisticsService = networkStatisticsService;
        this.containerTokenService = containerTokenService;
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
    }

    @GET
    @Path(value="/")
    public Response getSites() {
        List<CloudSiteDto> result = this.getSitesDto();
        return Response.ok(result).build();
    }

    @POST
    @Path(value="/rememberLegalOptIn")
    public void rememberLegalOptIn() {
        this.rememberLegalOptInDto();
    }

    @DELETE
    @Path(value="/rememberLegalOptIn")
    public void forgetLegalOptIn() {
        this.forgetLegalOptInDto();
    }

    @GET
    @Path(value="/rememberLegalOptIn")
    public Response getRememberLegalOptIn() {
        Object result = this.getRememberLegalOptInDto();
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/generateCloudSiteSetupUrl")
    public Response generateCloudSiteSetupUrl(GenerateCloudSiteSetupUrlDto cloudSiteSetupDto) {
        String result = this.generateCloudSiteSetupUrlDto(cloudSiteSetupDto);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="/generateEctlRedirectUrl")
    public Response generateEctlRedirectUrl(GenerateCloudSiteSetupUrlDto cloudSiteSetupDto) {
        String result = this.generateEctlRedirectUrlDto(cloudSiteSetupDto);
        return Response.ok((Object)result).build();
    }

    @POST
    @Path(value="save/token")
    public Response saveToken(SaveTokenRequest saveTokenRequest) {
        Pair<Integer, Object> result = this.saveTokenDto(saveTokenRequest);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    public List<CloudSiteDto> getSitesDto() {
        return this.cloudSiteService.getAllSites().stream().map(this::cloudSite2dto).collect(Collectors.toList());
    }

    public void rememberLegalOptInDto() {
        this.legalService.rememberLegalOptIn();
        this.networkStatisticsService.measureConnectionStats();
    }

    public void forgetLegalOptInDto() {
        this.legalService.forgetLegalOptIn();
    }

    public Object getRememberLegalOptInDto() {
        return this.legalService.getRememberLegalOptIn();
    }

    public String generateCloudSiteSetupUrlDto(GenerateCloudSiteSetupUrlDto cloudSiteSetupDto) {
        return this.cloudSiteSetupService.generateCloudSiteSetupUrl(cloudSiteSetupDto);
    }

    public String generateEctlRedirectUrlDto(GenerateCloudSiteSetupUrlDto cloudSiteSetupDto) {
        return this.cloudSiteSetupService.generateEctlRedirectUrl(cloudSiteSetupDto);
    }

    public Pair<Integer, Object> saveTokenDto(SaveTokenRequest saveTokenRequest) {
        try {
            this.containerTokenService.createAndSaveToken(saveTokenRequest.token, saveTokenRequest.cloudUrl);
            this.sendSaveTokenEvent(saveTokenRequest.cloudUrl, "Container Token saved successfully.", Response.Status.OK.getStatusCode(), Optional.empty());
            return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)new SaveTokenResponse(saveTokenRequest.cloudUrl, "Token saved successfully."));
        }
        catch (Exception ex) {
            HttpServiceException httpEx;
            log.error("Exception in saving container token", (Throwable)ex);
            if (ex.getCause() instanceof HttpServiceException && (httpEx = (HttpServiceException)ex.getCause()).getStatusCode() == HttpStatus.UNAUTHORIZED.value()) {
                this.sendSaveTokenEvent(saveTokenRequest.cloudUrl, ex.getMessage(), Response.Status.BAD_REQUEST.getStatusCode(), Optional.of(ex));
                return Pair.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)new MessageDto("Not able to save the token because it is Unauthorized."));
            }
            this.sendSaveTokenEvent(saveTokenRequest.cloudUrl, ex.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), Optional.of(ex));
            return Pair.of((Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Object)new MessageDto("Error in saving container token."));
        }
    }

    private void sendSaveTokenEvent(String cloudUrl, String message, int statusCode, Optional<Throwable> ex) {
        HashMap<String, Object> userAttributes = new HashMap<String, Object>();
        userAttributes.put("cloudUrl", cloudUrl);
        userAttributes.put("statusCode", statusCode);
        userAttributes.put("message", message);
        ex.ifPresent(throwable -> userAttributes.put("stackTrace", throwable.getStackTrace()));
        this.analyticsEventService.sendAnalyticsEvent(() -> this.analyticsEventBuilder.buildMapiOperationalEvent(ACTION, SUBJECT, userAttributes));
    }

    private CloudSiteDto cloudSite2dto(CloudSite cloudSite) {
        Edition edition = Optional.ofNullable(cloudSite.getEdition()).map(CloudEdition::getKey).orElse(null);
        return new CloudSiteDto(cloudSite.getCloudUrl(), cloudSite.getCloudId(), edition, cloudSite.getCloudType());
    }
}

