/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.media.impl;

import com.atlassian.migration.agent.common.MediaRateLimiter;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.media.CreateFileOptions;
import com.atlassian.migration.agent.media.Entity;
import com.atlassian.migration.agent.media.Etag;
import com.atlassian.migration.agent.media.MediaApiClient;
import com.atlassian.migration.agent.media.Upload;
import com.atlassian.migration.agent.media.impl.CryptoUtils;
import com.atlassian.migration.agent.media.impl.MediaRoutes;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import org.slf4j.Logger;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultMediaApiClient
implements MediaApiClient {
    private static final String MEDIA_RESPONSE_DATA_SECTION = "data";
    public static final String FILENAME_QUERY_PARAM = "name";
    public static final String SKIP_CONVERSION_QUERY_PARAM = "skipConversions";
    public static final String OMIT_BACKUP_QUERY_PARAM = "omitBackup";
    public static final String HASH_ALGORITHM_KEY = "hashAlgorithm";
    public static final String HASH_ALGORITHM = "sha256";
    private static final int MAX_GET_ITEMS_BATCH_SIZE = 100;
    private static final Logger log = ContextLoggerFactory.getLogger(DefaultMediaApiClient.class);
    private final MigrationAgentConfiguration configuration;
    private final HttpService httpService;
    private final MediaRateLimiter mediaRateLimiter;

    DefaultMediaApiClient(MigrationAgentConfiguration configuration, HttpService httpService, MediaRateLimiter mediaRateLimiter) {
        this.configuration = configuration;
        this.httpService = httpService;
        this.mediaRateLimiter = mediaRateLimiter;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Etag uploadChunk(final ByteBuffer data, String uploadId, String partNumber) {
        final Etag etag = new Etag(data.remaining(), CryptoUtils.sha256(data));
        final int originalPosition = data.position();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromPath((String)MediaRoutes.CHUNK.getUrl(this.getUrl(), etag.toString())).queryParam("uploadId", new Object[]{uploadId}).queryParam("partNumber", new Object[]{partNumber});
        uriBuilder = this.withSentinelRequestParams(uriBuilder, builder -> builder.queryParam(OMIT_BACKUP_QUERY_PARAM, new Object[]{true}));
        Request request = DefaultMediaApiClient.request(uriBuilder.build().toString()).put(new RequestBody(){

            public long contentLength() {
                return etag.getLength();
            }

            @javax.annotation.Nullable
            @Nullable
            public MediaType contentType() {
                return MediaTypes.APPLICATION_STREAM_TYPE;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                data.position(originalPosition);
                sink.write(data);
            }
        }).build();
        this.makeRateLimitedCall(request);
        return etag;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Optional<Upload> createUpload() {
        String url = UriComponentsBuilder.fromPath((String)MediaRoutes.CREATE_UPLOAD.getUrl(this.getUrl())).queryParam("createUpTo", new Object[]{1}).queryParam(HASH_ALGORITHM_KEY, new Object[]{HASH_ALGORITHM}).build().toString();
        Request request = DefaultMediaApiClient.request(url).post(RequestBody.create((String)"{}", (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        Upload[] uploads = this.callJson(request, Upload[].class);
        if (uploads == null || uploads.length == 0) {
            return Optional.empty();
        }
        return Optional.of(uploads[0]);
    }

    @Override
    public void updateUpload(String uploadId, int offset, List<Etag> etags) {
        String[] chunks = (String[])etags.stream().map(Etag::toString).toArray(String[]::new);
        ImmutableMap body = ImmutableMap.of((Object)"chunks", (Object)chunks, (Object)"offset", (Object)offset);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromPath((String)MediaRoutes.PUT_UPLOAD_CHUNKS.getUrl(this.getUrl(), uploadId));
        uriBuilder = this.withSentinelRequestParams(uriBuilder, builder -> builder.queryParam(OMIT_BACKUP_QUERY_PARAM, new Object[]{true}));
        Request request = DefaultMediaApiClient.request(uriBuilder.build().toString()).put(RequestBody.create((String)Jsons.valueAsString(body), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.makeRateLimitedCall(request, (Set<Integer>)ImmutableSet.of((Object)409));
    }

    @Override
    public Entity uploadFileWithoutFileNameParam(InputStream inputStream, String fileName) {
        return this.uploadFile(inputStream, fileName, false);
    }

    @Override
    public Entity uploadFile(InputStream inputStream, String fileName) {
        return this.uploadFile(inputStream, fileName, true);
    }

    private Entity uploadFile(InputStream inputStream, String fileName, boolean hasFileNameAsParam) {
        Entity result;
        long cachedContentLength;
        InputStream resettableStream;
        InputStream inputStream2 = resettableStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        if (resettableStream.markSupported()) {
            resettableStream.mark(Integer.MAX_VALUE);
        }
        try {
            cachedContentLength = resettableStream.available();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RequestBody requestBody = new RequestBody(){

            public MediaType contentType() {
                return MediaTypes.APPLICATION_STREAM_TYPE;
            }

            public long contentLength() {
                return cachedContentLength > 0L ? cachedContentLength : -1L;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                resettableStream.reset();
                sink.writeAll(Okio.source((InputStream)resettableStream));
            }
        };
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromPath((String)MediaRoutes.POST_FILE_BINARY.getUrl(this.getUrl()));
        if (hasFileNameAsParam && !fileName.isEmpty()) {
            try {
                uriBuilder.queryParam(FILENAME_QUERY_PARAM, new Object[]{URLEncoder.encode(fileName, "UTF-8")});
            }
            catch (UnsupportedEncodingException e) {
                log.error("Failed to encode file name: {}", (Object)fileName, (Object)e);
                throw new RuntimeException(e);
            }
        }
        uriBuilder = this.withSentinelRequestParams(uriBuilder, builder -> builder.queryParam(SKIP_CONVERSION_QUERY_PARAM, new Object[]{true}).queryParam(OMIT_BACKUP_QUERY_PARAM, new Object[]{true}));
        Request requestBuilder = DefaultMediaApiClient.request(uriBuilder.build().toString()).post(requestBody).build();
        try {
            result = this.callJson(requestBuilder, Entity.class);
        }
        catch (Throwable ex) {
            log.error("Failed to upload file: {}", (Object)fileName, (Object)ex);
            throw ex;
        }
        return result;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Entity createFileFromUpload(String uploadId, @javax.annotation.Nullable @Nullable String name, @javax.annotation.Nullable @Nullable String mimeType, CreateFileOptions options) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("uploadId", uploadId);
        if (name != null) {
            body.put(FILENAME_QUERY_PARAM, name);
        }
        if (mimeType != null) {
            body.put("mimeType", name);
        }
        body.put("conditions", options);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromPath((String)MediaRoutes.CREATE_FILE_FROM_UPLOAD.getUrl(this.getUrl()));
        uriBuilder = this.withSentinelRequestParams(uriBuilder, builder -> builder.queryParam(SKIP_CONVERSION_QUERY_PARAM, new Object[]{true}).queryParam(OMIT_BACKUP_QUERY_PARAM, new Object[]{true}));
        Request request = DefaultMediaApiClient.request(uriBuilder.build().toString()).post(RequestBody.create((String)Jsons.valueAsString(body), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callJson(request, Entity.class);
    }

    private UriComponentsBuilder withSentinelRequestParams(UriComponentsBuilder uriBuilder, UnaryOperator<UriComponentsBuilder> addRequestParams) {
        if ("sentinel".equalsIgnoreCase(this.configuration.getMigrationExecutionRunner())) {
            return (UriComponentsBuilder)addRequestParams.apply(uriBuilder);
        }
        return uriBuilder;
    }

    private Response makeRateLimitedCall(Request request) {
        this.mediaRateLimiter.get().acquire();
        return this.httpService.call(request);
    }

    private void makeRateLimitedCall(Request request, Set<Integer> expectedErrorCode) {
        this.mediaRateLimiter.get().acquire();
        this.httpService.call(request, expectedErrorCode);
    }

    private String getUrl() {
        return this.configuration.getMediaServiceUrl();
    }

    private static Request.Builder request(String url) {
        return new Request.Builder().addHeader("Accept", "application/json").url(url);
    }

    private <T> T callJson(Request request, Class<T> bodyType) {
        this.mediaRateLimiter.get().acquire();
        return this.httpService.call(request, this.mediaResponseMapper(bodyType));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Map<String, Boolean> validateFiles(List<String> fileIds) {
        if (fileIds.isEmpty()) {
            return new HashMap<String, Boolean>();
        }
        if (fileIds.size() <= 100) {
            return this.validateFilesBatch(fileIds);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        List batches = Lists.partition(fileIds, (int)100);
        for (List batch : batches) {
            Map<String, Boolean> batchResult = this.validateFilesBatch(batch);
            result.putAll(batchResult);
        }
        return result;
    }

    private Map<String, Boolean> validateFilesBatch(List<String> fileIds) {
        HashMap requestBody = new HashMap();
        List descriptors = fileIds.stream().map(fileId -> {
            HashMap<String, String> descriptor = new HashMap<String, String>();
            descriptor.put("type", "file");
            descriptor.put("id", (String)fileId);
            return descriptor;
        }).collect(Collectors.toList());
        requestBody.put("descriptors", descriptors);
        Request request = DefaultMediaApiClient.request(MediaRoutes.GET_ITEMS.getUrl(this.getUrl())).post(RequestBody.create((String)Jsons.valueAsString(requestBody), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        HashSet<String> availableItems = new HashSet<String>();
        ValidateFilesResponse response = this.callJson(request, ValidateFilesResponse.class);
        if (response != null && response.getItems() != null) {
            for (ValidatedItem item : response.getItems()) {
                availableItems.add(item.getId());
            }
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (String fileId2 : fileIds) {
            result.put(fileId2, availableItems.contains(fileId2));
        }
        return result;
    }

    @VisibleForTesting
    <T> Function<ResponseBody, T> mediaResponseMapper(Class<T> bodyType) {
        return responseBody -> {
            JsonNode root = Jsons.readTree(responseBody.charStream());
            return Jsons.treeToValue(root.get(MEDIA_RESPONSE_DATA_SECTION), bodyType);
        };
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @org.codehaus.jackson.annotate.JsonIgnoreProperties(ignoreUnknown=true)
    static class ValidateFilesResponse {
        @JsonProperty(value="items")
        @org.codehaus.jackson.annotate.JsonProperty(value="items")
        private ValidatedItem[] items;

        ValidateFilesResponse() {
        }

        @JsonProperty(value="items")
        @Generated
        public void setItems(ValidatedItem[] items) {
            this.items = items;
        }

        @Generated
        public ValidatedItem[] getItems() {
            return this.items;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @org.codehaus.jackson.annotate.JsonIgnoreProperties(ignoreUnknown=true)
    static class ValidatedItem {
        @JsonProperty(value="type")
        @org.codehaus.jackson.annotate.JsonProperty(value="type")
        private String type;
        @JsonProperty(value="id")
        @org.codehaus.jackson.annotate.JsonProperty(value="id")
        private String id;

        ValidatedItem() {
        }

        @JsonProperty(value="type")
        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="id")
        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getId() {
            return this.id;
        }
    }
}

