/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.logging;

import com.atlassian.config.ApplicationConfiguration;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedMigrationsLogAppender {
    private static final Logger log = LoggerFactory.getLogger(UnifiedMigrationsLogAppender.class);
    private static final AtomicBoolean INSTALLED = new AtomicBoolean(false);
    private static final String ADD_APPENDER_METHOD_NAME = "addAppender";
    private static final String NEW_BUILDER_METHOD_NAME = "newBuilder";
    private static final String BUILD_METHOD_NAME = "build";

    public UnifiedMigrationsLogAppender(ApplicationConfiguration applicationConfiguration) {
        if (INSTALLED.get()) {
            return;
        }
        try {
            boolean configured;
            Path filePath = Paths.get(applicationConfiguration.getApplicationHome(), "logs", "atlassian-confluence-migrations.log");
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            boolean bl = configured = this.tryConfigureLog4j2(filePath) || this.tryConfigureLog4j1(filePath);
            if (!configured) {
                log.warn("No supported logging backend detected; skipping migrations log appender initialization.");
            } else {
                INSTALLED.set(true);
            }
        }
        catch (Throwable t) {
            log.warn("Failed to initialize migrations log appender.", t);
        }
    }

    private static boolean classExists(String fqcn) {
        try {
            Class.forName(fqcn);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean tryConfigureLog4j2(Path filePath) {
        if (!UnifiedMigrationsLogAppender.classExists("org.apache.logging.log4j.core.LoggerContext")) {
            return false;
        }
        try {
            Class<?> logManagerCls = Class.forName("org.apache.logging.log4j.LogManager");
            Object ctx = logManagerCls.getMethod("getContext", Boolean.TYPE).invoke(null, false);
            Class<?> ctxCls = Class.forName("org.apache.logging.log4j.core.LoggerContext");
            Class<?> cfgCls = Class.forName("org.apache.logging.log4j.core.config.Configuration");
            Object cfg = ctxCls.getMethod("getConfiguration", new Class[0]).invoke(ctx, new Object[0]);
            Map appenders = (Map)cfgCls.getMethod("getAppenders", new Class[0]).invoke(cfg, new Object[0]);
            if (appenders != null && appenders.containsKey("migrationslog")) {
                return true;
            }
            Class<?> layoutCls = Class.forName("org.apache.logging.log4j.core.layout.PatternLayout");
            Object layoutBuilder = layoutCls.getMethod(NEW_BUILDER_METHOD_NAME, new Class[0]).invoke(null, new Object[0]);
            Class<?> layoutBuilderCls = layoutBuilder.getClass();
            layoutBuilderCls.getMethod("withPattern", String.class).invoke(layoutBuilder, this.translatePatternForLog4j2("%d %p [%t] [%c{4}] %M %m%n"));
            layoutBuilderCls.getMethod("withConfiguration", cfgCls).invoke(layoutBuilder, cfg);
            Object layout = layoutBuilderCls.getMethod(BUILD_METHOD_NAME, new Class[0]).invoke(layoutBuilder, new Object[0]);
            Class<?> sizePolicyCls = Class.forName("org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy");
            Object sizePolicy = sizePolicyCls.getMethod("createPolicy", String.class).invoke(null, "20480KB");
            Class<?> stratBuilderCls = Class.forName("org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy$Builder");
            Object stratBuilder = stratBuilderCls.getMethod(NEW_BUILDER_METHOD_NAME, new Class[0]).invoke(null, new Object[0]);
            stratBuilderCls.getMethod("withMax", String.class).invoke(stratBuilder, String.valueOf(10));
            stratBuilderCls.getMethod("withConfig", cfgCls).invoke(stratBuilder, cfg);
            Object strategy = stratBuilderCls.getMethod(BUILD_METHOD_NAME, new Class[0]).invoke(stratBuilder, new Object[0]);
            Class<?> rfBuilderCls = Class.forName("org.apache.logging.log4j.core.appender.RollingFileAppender$Builder");
            Object rfBuilder = rfBuilderCls.getMethod(NEW_BUILDER_METHOD_NAME, new Class[0]).invoke(null, new Object[0]);
            rfBuilderCls.getMethod("setName", String.class).invoke(rfBuilder, "migrationslog");
            rfBuilderCls.getMethod("withFileName", String.class).invoke(rfBuilder, filePath.toString());
            rfBuilderCls.getMethod("withFilePattern", String.class).invoke(rfBuilder, filePath.toString() + ".%i");
            rfBuilderCls.getMethod("setConfiguration", cfgCls).invoke(rfBuilder, cfg);
            rfBuilderCls.getMethod("setLayout", Class.forName("org.apache.logging.log4j.core.Layout")).invoke(rfBuilder, layout);
            rfBuilderCls.getMethod("withAppend", Boolean.TYPE).invoke(rfBuilder, true);
            rfBuilderCls.getMethod("withImmediateFlush", Boolean.TYPE).invoke(rfBuilder, true);
            rfBuilderCls.getMethod("withPolicy", Class.forName("org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy")).invoke(rfBuilder, sizePolicy);
            rfBuilderCls.getMethod("withStrategy", Class.forName("org.apache.logging.log4j.core.appender.rolling.RolloverStrategy")).invoke(rfBuilder, strategy);
            Object appender = rfBuilderCls.getMethod(BUILD_METHOD_NAME, new Class[0]).invoke(rfBuilder, new Object[0]);
            Class<?> appenderCls = Class.forName("org.apache.logging.log4j.core.Appender");
            appenderCls.getMethod("start", new Class[0]).invoke(appender, new Object[0]);
            cfgCls.getMethod(ADD_APPENDER_METHOD_NAME, appenderCls).invoke(cfg, appender);
            Class<?> loggerConfigCls = Class.forName("org.apache.logging.log4j.core.config.LoggerConfig");
            Object loggerConfig = cfgCls.getMethod("getLoggerConfig", String.class).invoke(cfg, "com.atlassian.migration.agent");
            Class<?> levelCls = Class.forName("org.apache.logging.log4j.Level");
            Field infoField = levelCls.getField("INFO");
            Object info = infoField.get(null);
            loggerConfigCls.getMethod(ADD_APPENDER_METHOD_NAME, appenderCls, levelCls, Class.forName("org.apache.logging.log4j.core.Filter")).invoke(loggerConfig, appender, info, null);
            ctxCls.getMethod("updateLoggers", new Class[0]).invoke(ctx, new Object[0]);
            return true;
        }
        catch (Throwable t) {
            log.debug("Log4j2 migrations appender configuration failed.", t);
            return false;
        }
    }

    private boolean tryConfigureLog4j1(Path filePath) {
        if (!UnifiedMigrationsLogAppender.classExists("org.apache.log4j.Logger")) {
            return false;
        }
        try {
            Object layout;
            Class<?> plc;
            Class<?> loggerCls = Class.forName("org.apache.log4j.Logger");
            Object logger = loggerCls.getMethod("getLogger", String.class).invoke(null, "com.atlassian.migration.agent");
            Object existing = loggerCls.getMethod("getAppender", String.class).invoke(logger, "migrationslog");
            if (existing != null) {
                return true;
            }
            Class<?> rfaCls = Class.forName("org.apache.log4j.RollingFileAppender");
            Object appender = rfaCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            rfaCls.getMethod("setName", String.class).invoke(appender, "migrationslog");
            rfaCls.getMethod("setFile", String.class).invoke(appender, filePath.toString());
            rfaCls.getMethod("setMaxFileSize", String.class).invoke(appender, "20480KB");
            rfaCls.getMethod("setMaxBackupIndex", Integer.TYPE).invoke(appender, 10);
            if (UnifiedMigrationsLogAppender.classExists("com.atlassian.confluence.util.PatternLayoutWithContext")) {
                plc = Class.forName("com.atlassian.confluence.util.PatternLayoutWithContext");
                layout = plc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method setConversionPattern = plc.getMethod("setConversionPattern", String.class);
                setConversionPattern.invoke(layout, "%d %p [%t] [%c{4}] %M %m%n");
            } else {
                plc = Class.forName("org.apache.log4j.PatternLayout");
                layout = plc.getDeclaredConstructor(String.class).newInstance("%d %p [%t] [%c{4}] %M %m%n");
            }
            Class<?> layoutType = Class.forName("org.apache.log4j.Layout");
            rfaCls.getMethod("setLayout", layoutType).invoke(appender, layout);
            rfaCls.getMethod("activateOptions", new Class[0]).invoke(appender, new Object[0]);
            Class<?> appenderType = Class.forName("org.apache.log4j.Appender");
            loggerCls.getMethod(ADD_APPENDER_METHOD_NAME, appenderType).invoke(logger, appender);
            Class<?> levelCls = Class.forName("org.apache.log4j.Level");
            Object info = levelCls.getField("INFO").get(null);
            loggerCls.getMethod("setLevel", levelCls).invoke(logger, info);
            loggerCls.getMethod("setAdditivity", Boolean.TYPE).invoke(logger, true);
            return true;
        }
        catch (Throwable t) {
            log.debug("Log4j1 migrations appender configuration failed.", t);
            return false;
        }
    }

    private String translatePatternForLog4j2(String pattern) {
        return pattern;
    }
}

