/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.worker;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceUploadExecutor;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.ProgressUnit;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.SpaceUploadProcessor;
import com.atlassian.migration.agent.v4.tasks.SpaceUploadTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTaskType;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class SpaceUploadWorker
extends V4Worker<SpaceUploadTransferTask> {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceUploadWorker.class);
    @Autowired
    private final SpaceUploadExecutor spaceUploadExecutor;
    @Autowired
    private final SpaceManager spaceManager;
    @Autowired
    private final V4Logger v4Logger;
    @Autowired
    private final ClusterInformationService clusterInformationService;
    private static final String EXPORT_FIELD = "exportFileId";

    public SpaceUploadWorker(List<ProgressUnit> supportedUnits, SpaceUploadExecutor spaceUploadExecutor, PlanStore planStore, StepStore stepStore, PluginTransactionTemplate defaultPluginTransactionTemplate, TaskStore taskStore, SpaceManager spaceManager, MigrationLogService migrationLogService, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(supportedUnits, planStore, taskStore, stepStore, defaultPluginTransactionTemplate, migrationLogService);
        this.spaceUploadExecutor = spaceUploadExecutor;
        this.spaceManager = spaceManager;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
        this.commandName = CommandName.CONFLUENCE_SPACE_UPLOAD;
    }

    @Override
    public StepResult process(PrcTask<SpaceUploadTransferTask> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler) {
        Step prcStep = this.translatePrcTaskAsStep(prcTask);
        prcStep.setType(StepType.DATA_UPLOAD.name());
        this.processPayloadAndSetConfig(prcTask, prcStep);
        this.getPtx().write(() -> this.getStepStore().update(prcStep));
        SpaceUploadProcessor processor = new SpaceUploadProcessor(prcTask, prcStep, prcPoller, pollerConfigHandler, this.spaceUploadExecutor, this.migrationLogService);
        return processor.initiate();
    }

    private void processPayloadAndSetConfig(PrcTask<SpaceUploadTransferTask> prcTask, Step prcStep) {
        V4LogContext logContext = V4LogContext.builder().stepId(prcStep.getId()).nodeId(this.clusterInformationService.getCurrentNodeId()).stepType(StepType.DATA_UPLOAD.name()).nodeExecutionId(prcStep.getNodeExecutionId()).executionState(prcStep.getExecutionState()).build();
        this.v4Logger.logInfo(log, logContext, "Processing space upload payload");
        try {
            String exportFileId = prcTask.getTransferTask().getExportFileId();
            if (exportFileId == null) {
                throw new IllegalArgumentException("Missing exportFileId on transfer task");
            }
            prcStep.setConfig(exportFileId);
            logContext.addAdditionalProperties(EXPORT_FIELD, exportFileId);
            this.v4Logger.logInfo(log, logContext, "Successfully processed space upload payload");
        }
        catch (Exception e) {
            this.v4Logger.logError(log, logContext, "Failed to parse space upload payload", e);
            throw new RuntimeException("Failed to parse payload", e);
        }
    }

    @Override
    public Task getMigTask(List<Task> tasks, PrcTask<SpaceUploadTransferTask> prcTask) {
        String spaceKey = Objects.requireNonNull(this.spaceManager.getSpace(Long.parseLong(prcTask.getTransferTask().getSpaceId()))).getKey();
        return tasks.stream().filter(ConfluenceSpaceTask.class::isInstance).map(ConfluenceSpaceTask.class::cast).filter(task1 -> spaceKey.equals(task1.getSpaceKey())).findFirst().orElse(null);
    }

    @Override
    public void setStepConfig(Step step) {
        ConfluenceSpaceTask task = (ConfluenceSpaceTask)step.getTask();
        step.setConfig(task.getSpaceKey());
    }

    @Override
    public TransferTaskType getTransferTaskType() {
        return TransferTaskType.CONFLUENCE_SPACE_UPLOAD;
    }
}

