/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.processors;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.GroupedThreadFactory;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.v4.exception.ProcessorException;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import com.atlassian.migration.prc.client.model.config.OnDemandPollerConfig;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessor<T extends TransferTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractProcessor.class);
    public static final Duration HEARTBEAT_POLLING_PERIOD = Duration.ofSeconds(60L);
    protected final PrcTask<T> prcTask;
    private final OnDemandPrcPoller prcPoller;
    private final PollerConfigHandler pollerConfigHandler;
    private final ScheduledExecutorService heartbeatScheduler;
    private final MigrationLogService migrationLogService;

    public AbstractProcessor(PrcTask<T> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, MigrationLogService migrationLogService) {
        this.prcTask = prcTask;
        this.prcPoller = prcPoller;
        this.pollerConfigHandler = pollerConfigHandler;
        this.migrationLogService = migrationLogService;
        this.heartbeatScheduler = Executors.newSingleThreadScheduledExecutor(new GroupedThreadFactory("AbstractProcessor"));
    }

    @VisibleForTesting
    AbstractProcessor(PrcTask<T> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, ScheduledExecutorService heartbeatScheduler, MigrationLogService migrationLogService) {
        this.prcTask = prcTask;
        this.prcPoller = prcPoller;
        this.pollerConfigHandler = pollerConfigHandler;
        this.heartbeatScheduler = heartbeatScheduler;
        this.migrationLogService = migrationLogService;
    }

    public StepResult initiate() {
        try {
            this.startHeartBeatScheduler();
            Pair<Step, StepResult> result = this.process();
            this.logIfStepFails((StepResult)result.getRight(), (Step)result.getLeft());
            StepResult stepResult = (StepResult)result.getRight();
            return stepResult;
        }
        catch (ProcessorException e) {
            log.error("Error processing prc task with id: {}", (Object)this.prcTask.getPrcCommandId(), (Object)e);
            StepResult stepResult = StepResult.failed("Processor exception");
            return stepResult;
        }
        finally {
            this.stopHeartBeatScheduler();
        }
    }

    protected abstract Pair<Step, StepResult> process();

    protected void startHeartBeatScheduler() {
        this.heartbeatScheduler.scheduleWithFixedDelay(this::sendHeartbeat, HEARTBEAT_POLLING_PERIOD.toMillis(), HEARTBEAT_POLLING_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected void logIfStepFails(StepResult result, Step step) {
        if (!result.isStopped() && !result.isSuccess()) {
            log.info("Failed to process V4 step {}. PrcStep id: {}", (Object)step.getType(), (Object)step.getId());
            this.migrationLogService.saveToLogFile(step, result.getMessage(), result.getException());
        }
    }

    public void stopHeartBeatScheduler() {
        this.heartbeatScheduler.shutdown();
    }

    protected void sendHeartbeat() {
        log.info("Sending heartbeat for prc command with id: {}", (Object)this.prcTask.getPrcCommandId());
        OnDemandPollerConfig pollerConfigHeartbeat = this.pollerConfigHandler.getOnDemandPollerConfigWithPutAdapter(this.prcTask.getChannelName(), this.prcTask.getCloudSite().getCloudId(), this.prcTask.getCloudSite().getContainerToken(), Collections.singletonList(this.prcTask.getCommandName().getValue()));
        this.prcPoller.sendCommandHeartbeat(pollerConfigHeartbeat, this.prcTask.getPrcCommandId().longValue());
    }

    protected void setProgressStartTime(Step step, StepType stepType) {
        step.setProgress(step.getProgress().copy().started(stepType.getDisplayName()));
    }

    protected void setProgressOfStepSubTypeStartTime(Step step, StepSubType stepType) {
        step.setProgress(step.getProgress().copy().started(stepType.getDisplayName()));
    }

    @Generated
    public PrcTask<T> getPrcTask() {
        return this.prcTask;
    }

    @Generated
    public OnDemandPrcPoller getPrcPoller() {
        return this.prcPoller;
    }

    @Generated
    public PollerConfigHandler getPollerConfigHandler() {
        return this.pollerConfigHandler;
    }

    @Generated
    public ScheduledExecutorService getHeartbeatScheduler() {
        return this.heartbeatScheduler;
    }

    @Generated
    public MigrationLogService getMigrationLogService() {
        return this.migrationLogService;
    }
}

