/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers.status.converter;

import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.catalogue.model.TransferStatusResponse;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.v4.pollers.status.TransferResultStatus;
import com.atlassian.migration.agent.v4.pollers.status.converter.ContainerProgressConverter;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferProgressConverter<T extends AbstractContainer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransferProgressConverter.class);
    private final Function<T, Integer> percentEndFunction;
    private final String defaultStartMessage;
    private final String defaultSuccessMessage;

    public TransferProgressConverter(Function<T, Integer> percentEndFunction, String defaultStartMessage, String defaultSuccessMessage) {
        this.percentEndFunction = percentEndFunction;
        this.defaultStartMessage = defaultStartMessage;
        this.defaultSuccessMessage = defaultSuccessMessage;
    }

    public Progress convert(int startPercent, Progress existingProgress, TransferStatusResponse transferStatusResponse, T container, AbstractContainer.ContainerStatus adaptedContainerStatus, String migrationId, MigrationLogService migrationLogService) {
        TransferResultStatus adaptedTransferStatus;
        int endPercent = this.percentEndFunction.apply(container);
        try {
            adaptedTransferStatus = ((AbstractContainer)container).getType() == AbstractContainer.ContainerType.Site ? this.getSiteContainerStatus(transferStatusResponse) : transferStatusResponse.getStatus().adaptStatus(adaptedContainerStatus);
        }
        catch (RuntimeException e) {
            log.error("Failed to adapt transfer status, transferStatusResponse.getStatus(): {}, adaptedContainerProgress: {}", new Object[]{transferStatusResponse.getStatus(), adaptedContainerStatus, e});
            throw e;
        }
        int effectivePercent = (int)((double)startPercent + (double)((endPercent - startPercent) * transferStatusResponse.getProgressPercentage()) / 100.0);
        String message = ((AbstractContainer)container).getType() == AbstractContainer.ContainerType.Site ? this.deduceMessageForSiteContainer(adaptedTransferStatus, transferStatusResponse) : this.deduceMessage(adaptedTransferStatus, transferStatusResponse, adaptedContainerStatus);
        String detailedStatus = transferStatusResponse.getProgressProperties() != null && existingProgress.getStatus() != ExecutionStatus.DONE ? (String)transferStatusResponse.getProgressProperties().getOrDefault("detailedStatus", "Started") : "Started";
        Progress newProgress = detailedStatus != null ? existingProgress.copy().progress(effectivePercent, message, detailedStatus) : existingProgress.copy().progress(effectivePercent, message);
        ExecutionStatus currentTransferExecutionStatus = adaptedTransferStatus.getExecutionStatus();
        if (!existingProgress.getStatus().equals((Object)currentTransferExecutionStatus)) {
            switch (currentTransferExecutionStatus) {
                case CREATED: {
                    break;
                }
                case RUNNING: {
                    newProgress = this.checkAndApplyDefaultMessage(newProgress.copy().started(null), effectivePercent, this.defaultStartMessage);
                    break;
                }
                case STOPPING: {
                    newProgress = newProgress.copy().stopping();
                    break;
                }
                case DONE: {
                    if (this.isLastTask(endPercent)) {
                        newProgress = newProgress.copy().done();
                    }
                    effectivePercent = endPercent;
                    newProgress = this.checkAndApplyDefaultMessage(newProgress, effectivePercent, this.defaultSuccessMessage);
                    break;
                }
                case FAILED: {
                    newProgress = newProgress.copy().failed(message);
                    migrationLogService.saveToLogFile(transferStatusResponse, transferStatusResponse.getStatusMessage(), migrationId);
                    break;
                }
                case STOPPED: {
                    newProgress = newProgress.copy().stopped();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown execution status: " + (Object)((Object)adaptedTransferStatus.getExecutionStatus()));
                }
            }
        }
        return newProgress;
    }

    private String deduceMessageForSiteContainer(TransferResultStatus adaptedStatus, TransferStatusResponse response) {
        if (StringUtils.isNotEmpty((CharSequence)response.getStatusMessage())) {
            return response.getStatusMessage();
        }
        if (adaptedStatus.isUnsuccessful() || StringUtils.isEmpty((CharSequence)response.getProgressMessage())) {
            return ContainerProgressConverter.getMessageBasedOnUnsuccessfulTransferStatus(adaptedStatus);
        }
        return response.getProgressMessage();
    }

    private TransferResultStatus getSiteContainerStatus(TransferStatusResponse transferStatusResponse) {
        return transferStatusResponse.getStatus();
    }

    private String deduceMessage(TransferResultStatus adaptedStatus, TransferStatusResponse response, AbstractContainer.ContainerStatus adaptedContainerStatus) {
        if (StringUtils.isNotEmpty((CharSequence)response.getStatusMessage())) {
            return response.getStatusMessage();
        }
        if (adaptedStatus.isUnsuccessful() && adaptedStatus != response.getStatus() || StringUtils.isEmpty((CharSequence)response.getProgressMessage())) {
            return ContainerProgressConverter.getMessageBasedOnUnsuccessfulContainerStatus(adaptedContainerStatus);
        }
        return response.getProgressMessage();
    }

    private Progress checkAndApplyDefaultMessage(Progress progress, int effectivePercent, String defaultMessage) {
        if (StringUtils.isEmpty((CharSequence)progress.getMessage())) {
            progress = progress.copy().progress(effectivePercent, defaultMessage);
        }
        return progress;
    }

    private boolean isLastTask(int endPercent) {
        return endPercent == 100;
    }

    @Generated
    public Function<T, Integer> getPercentEndFunction() {
        return this.percentEndFunction;
    }

    @Generated
    public String getDefaultStartMessage() {
        return this.defaultStartMessage;
    }

    @Generated
    public String getDefaultSuccessMessage() {
        return this.defaultSuccessMessage;
    }
}

