/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.AttachmentMigration;
import com.atlassian.migration.agent.store.AttachmentMigrationStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.persistence.PersistenceException;
import lombok.Generated;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentMigrationStoreImpl
implements AttachmentMigrationStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentMigrationStoreImpl.class);
    private static final String CLOUD_ID_KEY = "cloudId";
    private static final String SPACE_KEY = "spaceKey";
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final String DELETE_MIGRATION_BY_MEDIA_IDS_QUERY = "delete from AttachmentMigration am where am.cloudId = :cloudId and am.mediaId in (:mediaIds)";
    public static final String SPACE_JOIN = " join a.space s ON s.key = :spaceKey";
    private final EntityManagerTemplate tmpl;

    public AttachmentMigrationStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public void saveMigration(AttachmentMigration attachmentMigration) {
        block2: {
            try {
                this.tmpl.saveOrUpdate(attachmentMigration);
                this.tmpl.flush();
            }
            catch (PersistenceException e) {
                if (e.getCause() instanceof ConstraintViolationException) break block2;
                throw e;
            }
        }
    }

    @Override
    public Optional<AttachmentMigration> findMigration(long attachmentId, String cloudId) {
        String query = "select a from AttachmentMigration a where a.cloudId = :cloudId and a.attachmentId = :attachmentId";
        return this.tmpl.query(AttachmentMigration.class, query).param(CLOUD_ID_KEY, (Object)cloudId).param("attachmentId", (Object)attachmentId).first();
    }

    @Override
    public int deleteMigrationsByCloudId(String cloudId) {
        log.info("Starting deletion of migrations associated with cloudId: {}", (Object)cloudId);
        String query = "delete from AttachmentMigration m where m.cloudId=:cloudId";
        int rowsAffected = this.tmpl.query(query).param(CLOUD_ID_KEY, (Object)cloudId).update();
        log.info("Successfully deleted {} migrations for cloudId: {}", (Object)rowsAffected, (Object)cloudId);
        return rowsAffected;
    }

    @Override
    public long countRetrievedAttachmentMigrationsBySpaceKeyAndCloudId(String spaceKey, String cloudId) {
        String query = "select count(am) from AttachmentMigration am join am.attachment a join a.space s ON s.key = :spaceKey where am.cloudSite.cloudId = :cloudId and am.mediaId is NOT NULL";
        return this.countMigAttachmentQuery(spaceKey, cloudId, query);
    }

    @Override
    public long countUnRetrievableAttachmentMigrationsBySpaceKeyAndCloudId(String spaceKey, String cloudId) {
        String query = "select count(am) from AttachmentMigration am join am.attachment a join a.space s ON s.key = :spaceKey where am.cloudSite.cloudId = :cloudId and am.mediaId is NULL";
        return this.countMigAttachmentQuery(spaceKey, cloudId, query);
    }

    @Override
    public long countAlreadyMigratedAttachmentsBySpaceKeyAndCloudId(String spaceKey, String cloudId) {
        String query = "select count(am) from AttachmentMigration am join am.attachment a ON a.version = am.version join a.space s ON s.key = :spaceKey where am.cloudSite.cloudId = :cloudId";
        return this.countMigAttachmentQuery(spaceKey, cloudId, query);
    }

    @Override
    public List<String> getPreviouslyMigratedMediaIds(String spaceKey, String cloudId) {
        String query = "select am.mediaId from AttachmentMigration am join am.attachment a join a.space s ON s.key = :spaceKey where am.cloudSite.cloudId = :cloudId and am.mediaId is NOT NULL";
        return this.tmpl.query(String.class, query).param(CLOUD_ID_KEY, (Object)cloudId).param(SPACE_KEY, (Object)spaceKey).list();
    }

    @Override
    public void clearMigrationTrackingByMediaIds(List<String> mediaIds, String cloudId) {
        if (mediaIds == null || mediaIds.isEmpty()) {
            log.debug("No media IDs provided for clearing migration tracking in cloudId: {}", (Object)cloudId);
            return;
        }
        long startTime = System.currentTimeMillis();
        log.info("Starting to clear migration tracking for {} media files in cloudId: {}", (Object)mediaIds.size(), (Object)cloudId);
        List batches = Lists.partition(mediaIds, (int)1000);
        int totalRowsAffected = 0;
        int batchCount = 0;
        try {
            for (List batch : batches) {
                log.debug("Processing batch {} of {} ({} media IDs)", new Object[]{++batchCount, batches.size(), batch.size()});
                int batchRowsAffected = this.tmpl.query(DELETE_MIGRATION_BY_MEDIA_IDS_QUERY).param(CLOUD_ID_KEY, (Object)cloudId).param("mediaIds", (Object)batch).update();
                totalRowsAffected += batchRowsAffected;
                log.debug("Batch {} completed: {} attachment records cleared", (Object)batchCount, (Object)batchRowsAffected);
            }
            long duration = System.currentTimeMillis() - startTime;
            log.info("Successfully cleared migration tracking for {} attachment records across {} batches in {}ms (cloudId: {})", new Object[]{totalRowsAffected, batchCount, duration, cloudId});
        }
        catch (Exception e) {
            long duration = System.currentTimeMillis() - startTime;
            log.error("Failed to clear migration tracking after {}ms. Processed {} of {} batches, cleared {} records (cloudId: {})", new Object[]{duration, batchCount, batches.size(), totalRowsAffected, cloudId, e});
            throw e;
        }
    }

    private long countMigAttachmentQuery(String spaceKey, String cloudId, String query) {
        Long size = this.tmpl.query(Long.class, query).param(CLOUD_ID_KEY, (Object)cloudId).param(SPACE_KEY, (Object)spaceKey).single();
        return size == null ? 0L : size;
    }
}

