/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.ConcurrencySettingsEnum;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.ConcurrencyFormulaEngine;
import com.atlassian.migration.agent.service.impl.ConcurrencyHelper;
import com.atlassian.migration.agent.service.impl.ConcurrencyLimits;
import com.atlassian.migration.agent.service.impl.ConcurrencyV2Limits;
import com.atlassian.migration.agent.service.impl.ConcurrencyV4Limits;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

public class ConcurrencySettingsCalculator {
    private static final Logger LOGGER = ContextLoggerFactory.getLogger(ConcurrencySettingsCalculator.class);
    private final ConcurrencyHelper helper;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public ConcurrencySettingsCalculator(ConcurrencyHelper helper, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.helper = helper;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public Map<ConcurrencySettingsEnum, Integer> redistributePercentages(Optional<Plan> plan) {
        int nodes = this.helper.getAmountOfNodes();
        int cpu = this.helper.getAvailableProcessors();
        boolean skipAttachmentUploadEnabled = this.isSkipAttachmentUploadEnabled();
        boolean attachmentOnlyMigration = this.isAttachmentOnlyMigration(plan);
        boolean v4MigrationProtocolEnabled = this.isV4MigrationProtocolEnabled();
        ConcurrencyLimits limits = this.getLimits(nodes, cpu, v4MigrationProtocolEnabled);
        EnumMap<ConcurrencySettingsEnum, Integer> result = new EnumMap<ConcurrencySettingsEnum, Integer>(ConcurrencySettingsEnum.class);
        result.put(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_NODE_MAX, ConcurrencyFormulaEngine.calculateAttachmentConcurrencyNodeMax(cpu, nodes, limits.getAttachmentNodeMaxLimit(), attachmentOnlyMigration, skipAttachmentUploadEnabled));
        result.put(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_CLUSTER_MAX, ConcurrencyFormulaEngine.calculateAttachmentConcurrencyClusterMax(cpu, nodes, limits.getAttachmentClusterMaxLimit(), attachmentOnlyMigration, skipAttachmentUploadEnabled));
        result.put(ConcurrencySettingsEnum.ATTACHMENT_UPLOAD_CONCURRENCY, ConcurrencyFormulaEngine.calculateAttachmentUploadConcurrency(skipAttachmentUploadEnabled));
        result.put(ConcurrencySettingsEnum.IMPORT_CONCURRENCY_NODE_MAX, ConcurrencyFormulaEngine.calculateImportConcurrencyNodeMax(cpu, limits.getImportNodeMaxLimit()));
        result.put(ConcurrencySettingsEnum.IMPORT_CONCURRENCY_CLUSTER_MAX, ConcurrencyFormulaEngine.calculateImportConcurrencyClusterMax(cpu, nodes, limits.getImportClusterMaxLimit()));
        result.put(ConcurrencySettingsEnum.EXPORT_CONCURRENCY_NODE_MAX, ConcurrencyFormulaEngine.calculateExportConcurrencyNodeMax(cpu, limits.getExportNodeMaxLimit()));
        result.put(ConcurrencySettingsEnum.EXPORT_CONCURRENCY_CLUSTER_MAX, ConcurrencyFormulaEngine.calculateExportConcurrencyClusterMax(cpu, nodes, limits.getExportClusterMaxLimit()));
        result.put(ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_NODE_MAX, ConcurrencyFormulaEngine.calculateUploadConcurrencyNodeMax(cpu, limits.getUploadNodeMaxLimit()));
        result.put(ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_CLUSTER_MAX, ConcurrencyFormulaEngine.calculateUploadConcurrencyClusterMax(v4MigrationProtocolEnabled, cpu, nodes, limits.getUploadClusterMaxLimit()));
        result.put(ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_NODE_MAX, ConcurrencyFormulaEngine.calculateSpaceUsersConcurrencyNodeMax(cpu, limits.getSpaceUsersNodeMaxLimit()));
        result.put(ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_MAX, ConcurrencyFormulaEngine.calculateSpaceUsersConcurrencyMax(cpu, nodes, limits.getSpaceUsersMaxLimit()));
        this.logResult("ConcurrencySettingsCalculator|redistributePercentages", result, nodes, cpu, skipAttachmentUploadEnabled, v4MigrationProtocolEnabled, attachmentOnlyMigration);
        return result;
    }

    public int getAttachmentConcurrencyNodeMax(Optional<Plan> plan) {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getAttachmentConcurrencyNodeMax", plan, ctx -> ConcurrencyFormulaEngine.calculateAttachmentConcurrencyNodeMax(ctx.cpu, ctx.nodes, ctx.limits.getAttachmentNodeMaxLimit(), ctx.attachmentOnlyMigration, ctx.skipUpload));
    }

    public int getAttachmentConcurrencyClusterMax(Optional<Plan> plan) {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getAttachmentConcurrencyClusterMax", plan, ctx -> ConcurrencyFormulaEngine.calculateAttachmentConcurrencyClusterMax(ctx.cpu, ctx.nodes, ctx.limits.getAttachmentClusterMaxLimit(), ctx.attachmentOnlyMigration, ctx.skipUpload));
    }

    public int getAttachmentUploadConcurrency() {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getAttachmentUploadConcurrency", Optional.empty(), ctx -> ConcurrencyFormulaEngine.calculateAttachmentUploadConcurrency(ctx.skipUpload));
    }

    public int getImportConcurrencyNodeMax() {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getImportConcurrencyNodeMax", Optional.empty(), ctx -> ConcurrencyFormulaEngine.calculateImportConcurrencyNodeMax(ctx.cpu, ctx.limits.getImportNodeMaxLimit()));
    }

    public int getImportConcurrencyClusterMax() {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getImportConcurrencyClusterMax", Optional.empty(), ctx -> ConcurrencyFormulaEngine.calculateImportConcurrencyClusterMax(ctx.cpu, ctx.nodes, ctx.limits.getImportClusterMaxLimit()));
    }

    public int getExportConcurrencyNodeMax() {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getExportConcurrencyNodeMax", Optional.empty(), ctx -> ConcurrencyFormulaEngine.calculateExportConcurrencyNodeMax(ctx.cpu, ctx.limits.getExportNodeMaxLimit()));
    }

    public int getExportConcurrencyClusterMax() {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getExportConcurrencyClusterMax", Optional.empty(), ctx -> ConcurrencyFormulaEngine.calculateExportConcurrencyClusterMax(ctx.cpu, ctx.nodes, ctx.limits.getExportClusterMaxLimit()));
    }

    public int getUploadConcurrencyNodeMax() {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getUploadConcurrencyNodeMax", Optional.empty(), ctx -> ConcurrencyFormulaEngine.calculateUploadConcurrencyNodeMax(ctx.cpu, ctx.limits.getUploadNodeMaxLimit()));
    }

    public int getUploadConcurrencyClusterMax() {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getUploadConcurrencyClusterMax", Optional.empty(), ctx -> ConcurrencyFormulaEngine.calculateUploadConcurrencyClusterMax(ctx.v4Migration, ctx.cpu, ctx.nodes, ctx.limits.getUploadClusterMaxLimit()));
    }

    public int getSpaceUsersConcurrencyNodeMax() {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getSpaceUsersConcurrencyNodeMax", Optional.empty(), ctx -> ConcurrencyFormulaEngine.calculateSpaceUsersConcurrencyNodeMax(ctx.cpu, ctx.limits.getSpaceUsersNodeMaxLimit()));
    }

    public int getSpaceUsersConcurrencyMax() {
        return this.calculateWithContext("ConcurrencySettingsCalculator|getSpaceUsersConcurrencyMax", Optional.empty(), ctx -> ConcurrencyFormulaEngine.calculateSpaceUsersConcurrencyMax(ctx.cpu, ctx.nodes, ctx.limits.getSpaceUsersMaxLimit()));
    }

    protected boolean isV4MigrationProtocolEnabled() {
        try {
            return this.migrationDarkFeaturesManager.isV4MigrationProtocolEnabled();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    protected boolean isSkipAttachmentUploadEnabled() {
        try {
            return this.migrationDarkFeaturesManager.skipAttachmentUploadEnabled();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean isAttachmentOnlyMigration(Optional<Plan> plan) {
        return plan.isPresent() && this.getValue(plan.get().isAttachmentOnlyMigration());
    }

    private boolean getValue(Optional<Boolean> value) {
        return value.isPresent() && value.get() != false;
    }

    private ConcurrencyLimits getLimits(int amountOfNodes, int amountOfCPU, boolean v4MigrationProtocolEnabled) {
        return v4MigrationProtocolEnabled ? new ConcurrencyV4Limits(amountOfNodes, amountOfCPU) : new ConcurrencyV2Limits();
    }

    private int calculateWithContext(String logLabel, Optional<Plan> plan, ConcurrencyCalculationLambda lambda) {
        int nodes = this.helper.getAmountOfNodes();
        int cpu = this.helper.getAvailableProcessors();
        boolean attachmentOnlyMigration = this.isAttachmentOnlyMigration(plan);
        boolean skipUpload = this.isSkipAttachmentUploadEnabled();
        boolean v4Migration = this.isV4MigrationProtocolEnabled();
        ConcurrencyLimits limits = this.getLimits(nodes, cpu, v4Migration);
        ConcurrencyCalculationContext ctx = new ConcurrencyCalculationContext(cpu, nodes, attachmentOnlyMigration, skipUpload, v4Migration, limits);
        int result = lambda.calculate(ctx);
        this.logResult(logLabel, result, nodes, cpu, skipUpload, v4Migration, attachmentOnlyMigration);
        return result;
    }

    private void logResult(String label, Object result, int nodes, int cpu, boolean skipAttachmentUploadEnabled, boolean v4MigrationProtocolEnabled, boolean attachmentOnlyMigration) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("[{}] Nodes: {}, CPU: {}, skipAttachmentUploadEnabled? {}, attachmentOnlyMigration? {}, v4MigrationProtocolEnabled? {}, result: {}", new Object[]{label, nodes, cpu, skipAttachmentUploadEnabled, attachmentOnlyMigration, v4MigrationProtocolEnabled, result});
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    @FunctionalInterface
    public static interface ConcurrencyCalculationLambda {
        public int calculate(ConcurrencyCalculationContext var1);
    }

    public static class ConcurrencyCalculationContext {
        public final int cpu;
        public final int nodes;
        public final boolean attachmentOnlyMigration;
        public final boolean skipUpload;
        public final boolean v4Migration;
        public final ConcurrencyLimits limits;

        public ConcurrencyCalculationContext(int cpu, int nodes, boolean attachmentOnlyMigration, boolean skipUpload, boolean v4Migration, ConcurrencyLimits limits) {
            this.cpu = cpu;
            this.nodes = nodes;
            this.attachmentOnlyMigration = attachmentOnlyMigration;
            this.skipUpload = skipUpload;
            this.v4Migration = v4Migration;
            this.limits = limits;
        }
    }
}

