/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.dto.InfrastructureDto;
import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.dto.NodeInfrastructureInfoDto;
import com.atlassian.migration.agent.entity.ClusterNodeNetwork;
import com.atlassian.migration.agent.entity.NodeInfrastructureInfo;
import com.atlassian.migration.agent.service.guardrails.InfrastructureAssessmentStore;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentResult;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.impl.DialectResolver;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Query;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;

public class InfrastructureAssessmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InfrastructureAssessmentService.class);
    private final InfrastructureAssessmentStore infrastructureAssessmentStore;
    private final PluginVersionManager pluginVersionManager;
    private final PluginTransactionTemplate ptx;
    private final SystemInformationService systemInformationService;
    private final DialectResolver dialectResolver;
    private final EntityManagerTemplate tmpl;
    private final BootstrapManager bootstrapManager;
    private final String xms;
    private final String xmx;
    private static final Long UNKNOWN = -1L;

    public InfrastructureAssessmentService(InfrastructureAssessmentStore infrastructureAssessmentStore, PluginVersionManager pluginVersionManager, PluginTransactionTemplate ptx, SystemInformationService systemInformationService, DialectResolver dialectResolver, EntityManagerTemplate tmpl, BootstrapManager bootstrapManager) {
        this.infrastructureAssessmentStore = infrastructureAssessmentStore;
        this.pluginVersionManager = pluginVersionManager;
        this.ptx = ptx;
        this.systemInformationService = systemInformationService;
        this.dialectResolver = dialectResolver;
        this.bootstrapManager = bootstrapManager;
        this.tmpl = tmpl;
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        this.xmx = this.extractInputArgument(runtimeMxBean, "-Xmx");
        this.xms = this.extractInputArgument(runtimeMxBean, "-Xms");
    }

    private String extractInputArgument(RuntimeMXBean runtimeMxBean, String prefix) {
        return runtimeMxBean.getInputArguments().stream().filter(arg -> arg.startsWith(prefix)).map(arg -> arg.substring(prefix.length())).findFirst().orElse("Not Available");
    }

    protected InfrastructureDto.DatabaseInfoDto fetchDbInfo() {
        switch (this.dialectResolver.getDbType()) {
            case MSSQL: {
                return this.getMsSqlInfo();
            }
            case MYSQL: {
                return this.getMySqlInfo();
            }
            case ORACLE: {
                return this.getOracleInfo();
            }
            case POSTGRES: {
                return this.getPostgresInfo();
            }
        }
        return this.fetchDbInfoUsingQueries(null, null, null);
    }

    private InfrastructureDto.DatabaseInfoDto getMsSqlInfo() {
        return this.fetchDbInfoUsingQueries("select cpu_count from sys.dm_os_sys_info", "select total_physical_memory_kb * 1024 from sys.dm_os_sys_memory", "select sum(size) * 8 * 1024 from sys.master_files where database_id = DB_ID()");
    }

    private InfrastructureDto.DatabaseInfoDto getMySqlInfo() {
        return this.fetchDbInfoUsingQueries(null, null, "select sum(data_length+index_length) from information_schema.tables where table_schema = database()");
    }

    private InfrastructureDto.DatabaseInfoDto getOracleInfo() {
        return this.fetchDbInfoUsingQueries(null, null, "select sum(bytes) from user_segments");
    }

    private InfrastructureDto.DatabaseInfoDto getPostgresInfo() {
        return this.fetchDbInfoUsingQueries(null, null, "select pg_database_size(current_database())");
    }

    private InfrastructureDto.DatabaseInfoDto fetchDbInfoUsingQueries(String cpuQuery, String ramQuery, String storageQuery) {
        Long cpuCount = this.fetchQueryResult(cpuQuery);
        Long ram = this.fetchQueryResult(ramQuery);
        Long storageUsed = this.fetchQueryResult(storageQuery);
        return new InfrastructureDto.DatabaseInfoDto(this.systemInformationService.getDatabaseInfo().getName(), this.systemInformationService.getDatabaseInfo().getVersion(), cpuCount, ram.equals(UNKNOWN) ? UNKNOWN : ram / 0x100000L, storageUsed.equals(UNKNOWN) ? UNKNOWN : storageUsed / 0x100000L);
    }

    private Long fetchQueryResult(String query) {
        if (query == null) {
            return UNKNOWN;
        }
        try {
            Object result = this.tmpl.execute(em -> {
                Query nativeQuery = em.createNativeQuery(query);
                return nativeQuery.getSingleResult();
            });
            if (result instanceof Number) {
                return ((Number)result).longValue();
            }
        }
        catch (Exception e) {
            log.info("CCMA was unable to fetch database information, exception: ", (Throwable)e);
        }
        return UNKNOWN;
    }

    public InstanceAssessmentResult fetchData(InstanceMetadataDto instanceMetadataDto) {
        List<NodeInfrastructureInfoDto> nodeInfrastructureInfo = this.infrastructureAssessmentStore.findAllNodeInfo().stream().map(NodeInfrastructureInfoDto::new).collect(Collectors.toList());
        InfrastructureDto infrastructureDto = new InfrastructureDto(this.fetchDbInfo(), nodeInfrastructureInfo.size(), nodeInfrastructureInfo, this.xmx, this.xms);
        return new InstanceAssessmentResult(instanceMetadataDto, infrastructureDto, this.pluginVersionManager.getPluginVersion());
    }

    public void recordNodeData(String nodeId) {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardware = systemInfo.getHardware();
        NodeInfrastructureInfo infrastructureEntity = NodeInfrastructureInfo.builder().id(nodeId).operatingSystem(systemInfo.getOperatingSystem().toString()).ramMb(hardware.getMemory().getTotal() / 0x100000L).cpuCount(hardware.getProcessor().getPhysicalProcessorCount()).storageUsedMb(FileUtils.sizeOfDirectory((File)this.bootstrapManager.getLocalHome()) / 0x100000L).storageAvailableMb(this.bootstrapManager.getLocalHome().getFreeSpace() / 0x100000L).networkInfo(this.fetchNetworkInfo(hardware)).build();
        infrastructureEntity.getNetworkInfo().forEach(network -> network.setNodeInfrastructureInfo(infrastructureEntity));
        try {
            this.ptx.write(() -> this.infrastructureAssessmentStore.saveNodeInfoItem(infrastructureEntity));
        }
        catch (Exception e) {
            log.error("Failed to save or update node infrastructure data due to :", (Throwable)e);
        }
    }

    private List<ClusterNodeNetwork> fetchNetworkInfo(HardwareAbstractionLayer hardware) {
        ArrayList<ClusterNodeNetwork> networkInfo = new ArrayList<ClusterNodeNetwork>();
        for (NetworkIF networkIF : hardware.getNetworkIFs()) {
            ClusterNodeNetwork network = ClusterNodeNetwork.builder().name(networkIF.getDisplayName()).mtuBps(networkIF.getMTU()).inErrorsPercent(this.calculatePacketsErrorRate(networkIF.getInErrors(), networkIF.getPacketsRecv())).outErrorsPercent(this.calculatePacketsErrorRate(networkIF.getOutErrors(), networkIF.getPacketsSent())).build();
            networkInfo.add(network);
        }
        return networkInfo;
    }

    protected Double calculatePacketsErrorRate(Long errors, Long packets) {
        long total = packets + errors;
        return total > 0L ? (double)errors.longValue() / (double)total * 100.0 : 0.0;
    }
}

