/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.template;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventParams;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.template.GlobalDataTemplateConflictCheckContextProvider;
import com.atlassian.migration.agent.service.check.template.GlobalDataTemplateConflictChecker;
import com.atlassian.migration.agent.service.check.template.GlobalDataTemplateConflictContext;
import com.atlassian.migration.agent.service.check.template.GlobalDataTemplateConflictMapper;

@ParametersAreNonnullByDefault
public class GlobalDataTemplateConflictCheckRegistration
implements CheckRegistration<GlobalDataTemplateConflictContext> {
    private final GlobalDataTemplateConflictCheckContextProvider checkContextProvider;
    private final GlobalDataTemplateConflictChecker checker;
    private final GlobalDataTemplateConflictMapper checkMapper;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;

    public GlobalDataTemplateConflictCheckRegistration(GlobalDataTemplateConflictCheckContextProvider checkContextProvider, GlobalDataTemplateConflictChecker checker, GlobalDataTemplateConflictMapper checkMapper, PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder) {
        this.checkContextProvider = checkContextProvider;
        this.checker = checker;
        this.checkMapper = checkMapper;
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.GLOBAL_DATA_TEMPLATE;
    }

    @Override
    public Checker<GlobalDataTemplateConflictContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckContextProvider<GlobalDataTemplateConflictContext> getCheckContextProvider() {
        return this.checkContextProvider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.checkMapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(AnalyticsEventParams eventParams) {
        CheckResult checkResult = eventParams.getCheckResult();
        return this.preflightChecksAnalyticsEventBuilder.buildPreflightGlobalDataTemplatesConflict(eventParams.toPreflightAnalyticsEventParams(), GlobalDataTemplateConflictMapper.retrieveConflictingTemplates(checkResult.details));
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "globalDataTemplateCheck";
    }
}

