/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.featureflag.FeatureFlagClient;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.HashSet;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@Path(value="featureflag")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FeatureFlagResource {
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final FeatureFlagClient featureFlagClient;

    @Inject
    public FeatureFlagResource(MigrationDarkFeaturesManager migrationDarkFeaturesManager, FeatureFlagClient featureFlagClient) {
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.featureFlagClient = featureFlagClient;
    }

    @GET
    @Path(value="/all")
    public Response getAllEnabledFeatureFlags() {
        Object result = this.getAllEnabledFeatureFlagsDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/all/{planId}")
    public Response getAllEnabledFeatureFlagsForPlan(@PathParam(value="planId") String planId) {
        Object result = this.getAllEnabledFeatureFlagsForPlanDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/launchdarkly/all")
    public Response getAllLaunchDarklyFeatureFlags() {
        Object result = this.getAllLaunchDarklyFeatureFlagsDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/statsig/configs")
    public Response getDynamicConfig() {
        Object result = this.getDynamicConfigDto();
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/statsig/configs/{configName}")
    public Response getDynamicConfigByHash(@PathParam(value="configName") String configName) {
        Pair<Integer, Object> response = this.getDynamicConfigByHashDto(configName);
        return Response.status((int)((Integer)response.getLeft())).entity(response.getRight()).build();
    }

    public Object getAllEnabledFeatureFlagsDto() {
        return this.migrationDarkFeaturesManager.getAllEnabledFeatures();
    }

    public Object getAllEnabledFeatureFlagsForPlanDto() {
        return this.migrationDarkFeaturesManager.getAllEnabledFeatures();
    }

    public Object getAllLaunchDarklyFeatureFlagsDto() {
        return new HashSet<String>(this.featureFlagClient.getAllEnabledFeatureFlags());
    }

    public Object getDynamicConfigDto() {
        return this.featureFlagClient.getAllConfigsFromStatsig();
    }

    public Pair<Integer, Object> getDynamicConfigByHashDto(String configName) {
        Object configValue = this.featureFlagClient.getConfigValueByName(configName);
        if (configValue == null) {
            return Pair.of((Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)"Value not found for provided config");
        }
        return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)configValue);
    }
}

