/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.dto.UserDomainRuleDto;
import com.atlassian.migration.agent.dto.UserDomainRulesetDto;
import com.atlassian.migration.agent.dto.util.UserDomainsDto;
import com.atlassian.migration.agent.rest.ContainerTokenValidator;
import com.atlassian.migration.agent.service.email.CsvDomainUploadStatus;
import com.atlassian.migration.agent.service.impl.BlockedDomainService;
import com.atlassian.migration.agent.service.impl.TrustedDomainCsvReaderService;
import com.atlassian.migration.agent.service.impl.TrustedDomainCsvWriterService;
import com.atlassian.migration.agent.service.impl.TrustedDomainsCsvZipException;
import com.atlassian.migration.agent.service.impl.UserDomainService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.time.Instant;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@Path(value="email")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EmailResource {
    private final UserDomainService userDomainService;
    private final TrustedDomainCsvReaderService trustedDomainCsvReaderService;
    private final TrustedDomainCsvWriterService trustedDomainCsvWriterService;
    private final BlockedDomainService blockedDomainService;
    private final ContainerTokenValidator containerTokenValidator;

    @Inject
    public EmailResource(UserDomainService userDomainService, TrustedDomainCsvReaderService trustedDomainCsvReaderService, TrustedDomainCsvWriterService trustedDomainCsvWriterService, BlockedDomainService blockedDomainService, ContainerTokenValidator containerTokenValidator) {
        this.userDomainService = userDomainService;
        this.trustedDomainCsvReaderService = trustedDomainCsvReaderService;
        this.trustedDomainCsvWriterService = trustedDomainCsvWriterService;
        this.blockedDomainService = blockedDomainService;
        this.containerTokenValidator = containerTokenValidator;
    }

    @GET
    @Path(value="/domains")
    public Response getUserDomains() {
        return Response.ok((Object)this.getUserDomainsDto()).build();
    }

    @GET
    @Produces(value={"application/zip"})
    @Path(value="/download/domains/{cloudId}")
    public Response getUserDomainsCSV(@PathParam(value="cloudId") String cloudId) {
        try {
            Pair<Integer, Object> result = this.getUserDomainsCSVDto(cloudId);
            if (((Integer)result.getLeft()).intValue() != Response.Status.OK.getStatusCode()) {
                return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
            }
            Pair streamData = (Pair)result.getRight();
            return Response.ok(((ByteArrayOutputStream)streamData.getLeft())::writeTo).type("application/zip").header("Content-disposition", streamData.getRight()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Failed to generate CSV zip file" + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/domain-rules")
    public Response getDomainRuleset() {
        return Response.ok((Object)this.getDomainRulesetDto()).build();
    }

    @PUT
    @Path(value="/domain-rules")
    public Response updateDomainRule(UserDomainRuleDto rule) {
        this.updateDomainRuleDto(rule);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/domain-rules/{domain}")
    public Response deleteDomainRule(@PathParam(value="domain") String domain) {
        this.deleteDomainRuleDto(domain);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/rules")
    public Response deleteAllUserModifiedDomainRules() {
        this.deleteAllUserModifiedDomainRulesDto();
        return Response.ok().build();
    }

    @POST
    @Path(value="/upload/domains")
    @Consumes(value={"application/octet-stream"})
    public Response uploadDomainsFile(InputStream fileInputStream) {
        Pair<Integer, String> result = this.uploadDomainsFileDto(fileInputStream);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/blocked-domains/{cloudId}")
    public Response getBlockedDomains(@PathParam(value="cloudId") String cloudId) {
        Optional<Response> invalid = this.containerTokenValidator.validateContainerToken(cloudId).toResponseWhenNotValid();
        if (invalid.isPresent()) {
            return invalid.get();
        }
        return Response.ok((Object)this.getBlockedDomainsDto(cloudId)).build();
    }

    public UserDomainsDto getUserDomainsDto() {
        return new UserDomainsDto(this.userDomainService.getUserDomainCounts());
    }

    public UserDomainRulesetDto getDomainRulesetDto() {
        return this.userDomainService.getDomainRules();
    }

    public void updateDomainRuleDto(UserDomainRuleDto rule) {
        this.userDomainService.upsertDomainRule(rule);
    }

    public void deleteDomainRuleDto(String domain) {
        this.userDomainService.deleteDomainRule(domain);
    }

    public void deleteAllUserModifiedDomainRulesDto() {
        this.userDomainService.deleteAllUserModifiedDomainRules();
    }

    public Pair<Integer, String> uploadDomainsFileDto(InputStream fileInputStream) {
        CsvDomainUploadStatus status = this.trustedDomainCsvReaderService.processDomainsCsv(fileInputStream);
        switch (status.getResult()) {
            case SUCCESS: {
                return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)"File upload successful. All records are valid.");
            }
            case RECORD_FAILED: 
            case RECORD_VALIDATION_FAILED: {
                return Pair.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)status.getErrorMessage());
            }
        }
        return Pair.of((Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Object)status.getErrorMessage());
    }

    public Object getBlockedDomainsDto(String cloudId) {
        return this.blockedDomainService.getBlockedDomains(cloudId);
    }

    public Pair<Integer, Object> getUserDomainsCSVDto(String cloudId) {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9-]+");
        if (!pattern.matcher(cloudId).matches()) {
            return Pair.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)"Invalid cloud ID format");
        }
        long filenameTimestamp = Instant.now().toEpochMilli();
        ByteArrayOutputStream inMemoryOutputStream = new ByteArrayOutputStream();
        try {
            this.trustedDomainCsvWriterService.writeDomainsCsvZip(inMemoryOutputStream, cloudId, filenameTimestamp);
        }
        catch (TrustedDomainsCsvZipException e) {
            switch (e.type) {
                case INVALID_CLOUD_ID: {
                    return Pair.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)TrustedDomainsCsvZipException.Type.INVALID_CLOUD_ID.message);
                }
                case COULD_NOT_CREATE_CSV: {
                    return Pair.of((Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Object)TrustedDomainsCsvZipException.Type.COULD_NOT_CREATE_CSV.message);
                }
                case COULD_NOT_WRITE_CSV: {
                    return Pair.of((Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Object)TrustedDomainsCsvZipException.Type.COULD_NOT_WRITE_CSV.message);
                }
                case COULD_NOT_WRITE_ZIP: {
                    return Pair.of((Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Object)TrustedDomainsCsvZipException.Type.COULD_NOT_WRITE_ZIP.message);
                }
            }
            return Pair.of((Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Object)("Unexpected error: " + (Object)((Object)e.type)));
        }
        String contentDisposition = "attachment; filename=email-domains-" + filenameTimestamp + ".zip";
        return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)Pair.of((Object)inMemoryOutputStream, (Object)contentDisposition));
    }
}

