/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SqlParameters {
    private final String tableName;
    private final boolean importOnForgeStorage;
    private final List<String> transformers;

    public SqlParameters(String tableName, boolean importOnForgeStorage) {
        this(tableName, importOnForgeStorage, Collections.emptyList());
    }

    public SqlParameters(String tableName, boolean importOnForgeStorage, List<String> transformers) {
        this.tableName = tableName;
        this.importOnForgeStorage = importOnForgeStorage;
        this.transformers = transformers;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean importOnForgeStorage() {
        return this.importOnForgeStorage;
    }

    public List<String> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlParameters that = (SqlParameters)o;
        return this.importOnForgeStorage == that.importOnForgeStorage && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.transformers, that.transformers);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.tableName);
        result = 31 * result + Boolean.hashCode(this.importOnForgeStorage);
        result = 31 * result + Objects.hashCode(this.transformers);
        return result;
    }
}

