/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app;

import com.atlassian.migration.app.Experimental;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class KeyValueParameters {
    private final String entityName;
    @Experimental
    private final boolean importOnForgeStorage;
    @Experimental
    private final List<String> transformers;

    public KeyValueParameters(String entityName, boolean importOnForgeStorage) {
        this(entityName, importOnForgeStorage, Collections.emptyList());
    }

    public KeyValueParameters(String entityName, boolean importOnForgeStorage, List<String> transformers) {
        this.entityName = entityName;
        this.importOnForgeStorage = importOnForgeStorage;
        this.transformers = transformers;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean importOnForgeStorage() {
        return this.importOnForgeStorage;
    }

    public List<String> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueParameters that = (KeyValueParameters)o;
        return this.importOnForgeStorage == that.importOnForgeStorage && Objects.equals(this.entityName, that.entityName) && Objects.equals(this.transformers, that.transformers);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.entityName);
        result = 31 * result + Boolean.hashCode(this.importOnForgeStorage);
        result = 31 * result + Objects.hashCode(this.transformers);
        return result;
    }
}

