/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app;

import com.atlassian.migration.agent.service.analytics.DefaultAppAnalyticsEventService;
import com.atlassian.migration.app.AbstractCloudMigrationRegistrar;
import com.atlassian.migration.app.AppMigrationDarkFeatures;
import com.atlassian.migration.app.DefaultAppMigrationServiceClient;
import com.atlassian.migration.app.ForgeConnectListenerFilterUtility;
import com.atlassian.migration.app.cloudAssistantRegistrars.AppDataPreloadGateway;
import com.atlassian.migration.app.dto.AppContainerDetails;
import com.atlassian.migration.app.gateway.AppCloudMigrationGatewayManager;
import com.atlassian.migration.app.lio.model.RecipeExecutionRequest;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegistrar
extends AbstractCloudMigrationRegistrar
implements JobRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRegistrar.class);
    private static final JobRunnerKey RUNNER_KEY = JobRunnerKey.of((String)"app-mig-job-runner");
    private static final String TRANSFER_ID = "transferId";
    private final DefaultAppMigrationServiceClient appMigrationServiceClient;
    private final SchedulerService schedulerService;
    private final DefaultAppAnalyticsEventService defaultAppAnalyticsEventService;

    public DefaultRegistrar(DefaultAppMigrationServiceClient appMigrationServiceClient, SchedulerService schedulerService, BundleContext bundleContext, DefaultAppAnalyticsEventService defaultAppAnalyticsEventService, AppMigrationDarkFeatures appMigrationDarkFeatures, AppCloudMigrationGatewayManager appCloudMigrationGatewayManager, AppDataPreloadGateway appDataPreloadGateway, ForgeConnectListenerFilterUtility forgeConnectListenerFilterUtility) {
        super(bundleContext, appMigrationDarkFeatures, appMigrationServiceClient, defaultAppAnalyticsEventService, appCloudMigrationGatewayManager, appDataPreloadGateway, forgeConnectListenerFilterUtility);
        this.appMigrationServiceClient = appMigrationServiceClient;
        this.schedulerService = schedulerService;
        this.defaultAppAnalyticsEventService = defaultAppAnalyticsEventService;
    }

    @Override
    public void startMigration(@NotNull String cloudId, @NotNull String migrationId, @NotNull Set<AppContainerDetails> appContainerDetails) {
        log.debug("Starting app-migration for cloudId={}, migrationId={}, appContainerDetails.size={}", new Object[]{cloudId, migrationId, appContainerDetails.size()});
        if (appContainerDetails.isEmpty()) {
            log.info("No app containers for app-migration for migrationId {}", (Object)migrationId);
            return;
        }
        super.startMigration(cloudId, migrationId, appContainerDetails);
    }

    protected void queueExecution(String transferId) {
        this.queueExecution(transferId, null);
    }

    @Override
    protected void queueExecution(String transferId, Date date) {
        log.info("Queueing job for app-migration for transferId {}", (Object)StringUtils.abbreviate((String)transferId, (int)21));
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put(TRANSFER_ID, transferId);
            this.schedulerService.scheduleJob(JobId.of((String)UUID.randomUUID().toString()), JobConfig.forJobRunnerKey((JobRunnerKey)RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce((Date)date)).withParameters(parameters));
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException("Failed to queue app transfer execution: " + e.getMessage());
        }
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            String transferId = ((Serializable)request.getJobConfig().getParameters().get(TRANSFER_ID)).toString();
            log.info("Running job for app-migration for jobId {} and transferId {} ", (Object)request.getJobId(), (Object)StringUtils.abbreviate((String)transferId, (int)21));
            this.executeTransfer(transferId);
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((String)("Failed to run job: " + e.getMessage()));
        }
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    public void postConstruct() {
        this.schedulerService.registerJobRunner(RUNNER_KEY, (JobRunner)this);
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    public void preDestroy() {
        this.schedulerService.unregisterJobRunner(RUNNER_KEY);
    }

    @Override
    protected void executeRecipe(@NotNull String s, @NotNull String s1, @NotNull RecipeExecutionRequest recipeExecutionRequest) {
    }

    @Generated
    public DefaultAppMigrationServiceClient getAppMigrationServiceClient() {
        return this.appMigrationServiceClient;
    }

    @Generated
    public DefaultAppAnalyticsEventService getDefaultAppAnalyticsEventService() {
        return this.defaultAppAnalyticsEventService;
    }
}

