/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.worker;

import com.atlassian.migration.agent.entity.Progress;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.atlassian.migration.agent.v4.ProgressUnit;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTaskType;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public abstract class V4Worker<T extends TransferTask> {
    protected String id;
    protected List<ProgressUnit> supportedUnits;
    protected CommandName commandName;
    private final PlanStore planStore;
    private final TaskStore taskStore;
    private final StepStore stepStore;
    private final PluginTransactionTemplate ptx;
    protected MigrationLogService migrationLogService;
    protected static final MigrationProtocol migrationProtocol = MigrationProtocol.V4;

    protected V4Worker(List<ProgressUnit> supportedUnits, PlanStore planStore, TaskStore taskStore, StepStore stepStore, PluginTransactionTemplate ptx, MigrationLogService migrationLogService) {
        this.planStore = planStore;
        this.taskStore = taskStore;
        this.stepStore = stepStore;
        this.ptx = ptx;
        this.id = UUID.randomUUID().toString();
        this.supportedUnits = supportedUnits;
        this.migrationLogService = migrationLogService;
    }

    public abstract StepResult process(PrcTask<T> var1, OnDemandPrcPoller var2, PollerConfigHandler var3);

    public Step translatePrcTaskAsStep(PrcTask<T> prcTask) {
        Step step = new Step();
        String planId = this.planStore.getPlanForMigrationId(prcTask.getMigrationId()).getId();
        List<Task> tasks = this.taskStore.getTasksForPlan(planId);
        step.setId(((TransferTask)prcTask.getTransferTask()).getTaskId());
        step.setType(((TransferTask)prcTask.getTransferTask()).getType().name());
        step.setIndex(0);
        Task task = this.getMigTask(tasks, prcTask);
        step.setTask(task);
        this.setStepConfig(step);
        Progress progress = Progress.created();
        step.setProgress(progress);
        this.ptx.write(() -> this.stepStore.update(step));
        return step;
    }

    public abstract Task getMigTask(List<Task> var1, PrcTask<T> var2);

    public abstract void setStepConfig(Step var1);

    public abstract TransferTaskType getTransferTaskType();

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public List<ProgressUnit> getSupportedUnits() {
        return this.supportedUnits;
    }

    @Generated
    public CommandName getCommandName() {
        return this.commandName;
    }

    @Generated
    public PlanStore getPlanStore() {
        return this.planStore;
    }

    @Generated
    public TaskStore getTaskStore() {
        return this.taskStore;
    }

    @Generated
    public StepStore getStepStore() {
        return this.stepStore;
    }

    @Generated
    public PluginTransactionTemplate getPtx() {
        return this.ptx;
    }

    @Generated
    public MigrationLogService getMigrationLogService() {
        return this.migrationLogService;
    }
}

