/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.worker;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.ConfExportStepConfig;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportExecutor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceUsersMigrationExecutor;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.ProgressUnit;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.SpaceExportProcessor;
import com.atlassian.migration.agent.v4.tasks.SpaceExportTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTaskType;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class SpaceExportWorker
extends V4Worker<SpaceExportTransferTask> {
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportWorker.class);
    @Autowired
    private final SpaceExportExecutor spaceExportExecutor;
    @Autowired
    private final SpaceUsersMigrationExecutor spaceUsersMigrationExecutor;
    @Autowired
    private final SpaceManager spaceManager;
    @Autowired
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    @Autowired
    private final V4Logger v4Logger;
    @Autowired
    private final ClusterInformationService clusterInformationService;
    private static final String SPACE_KEY = "spaceKey";

    public SpaceExportWorker(List<ProgressUnit> supportedUnits, SpaceExportExecutor spaceExportExecutor, SpaceManager spaceManager, PlanStore planStore, StepStore stepStore, PluginTransactionTemplate defaultPluginTransactionTemplate, TaskStore taskStore, SpaceUsersMigrationExecutor spaceUsersMigrationExecutor, MigrationDarkFeaturesManager migrationDarkFeaturesManager, MigrationLogService migrationLogService, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(supportedUnits, planStore, taskStore, stepStore, defaultPluginTransactionTemplate, migrationLogService);
        this.spaceExportExecutor = spaceExportExecutor;
        this.spaceManager = spaceManager;
        this.spaceUsersMigrationExecutor = spaceUsersMigrationExecutor;
        this.commandName = CommandName.CONFLUENCE_SPACE_EXPORT;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
    }

    @Override
    public StepResult process(PrcTask<SpaceExportTransferTask> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler) {
        Step prcStep = this.translatePrcTaskAsStep(prcTask);
        this.updatePrcStep(prcStep);
        V4LogContext logContext = V4LogContext.builder().stepId(prcStep.getId()).stepType(StepType.CONFLUENCE_EXPORT.name()).prcTaskId(prcTask.getTransferTask().getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).nodeExecutionId(prcStep.getNodeExecutionId()).executionState(prcStep.getExecutionState()).build();
        this.v4Logger.logInfo(log, logContext, "Step updated successfully and space export process initiated for task");
        SpaceExportProcessor processor = new SpaceExportProcessor(prcTask, prcStep, prcPoller, pollerConfigHandler, this.spaceExportExecutor, this.spaceUsersMigrationExecutor, this.migrationDarkFeaturesManager, this.getPtx(), this.getStepStore(), this.migrationLogService, this.v4Logger, this.clusterInformationService);
        return processor.initiate();
    }

    private void updatePrcStep(Step prcStep) {
        prcStep.setType(StepType.CONFLUENCE_EXPORT.name());
        this.getPtx().write(() -> this.getStepStore().update(prcStep));
    }

    @Override
    public Task getMigTask(List<Task> tasks, PrcTask<SpaceExportTransferTask> prcTask) {
        String spaceKey = Objects.requireNonNull(this.spaceManager.getSpace(Long.parseLong(prcTask.getTransferTask().getSpaceId()))).getKey();
        V4LogContext logContext = V4LogContext.builder().prcTaskId(prcTask.getTransferTask().getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(SPACE_KEY, spaceKey);
        this.v4Logger.logInfo(log, logContext, "Finding migration task for space export");
        return tasks.stream().filter(ConfluenceSpaceTask.class::isInstance).map(ConfluenceSpaceTask.class::cast).filter(task1 -> spaceKey.equals(task1.getSpaceKey())).findFirst().orElse(null);
    }

    @Override
    public void setStepConfig(Step step) {
        ConfluenceSpaceTask task = (ConfluenceSpaceTask)step.getTask();
        String cloudId = task.getPlan().getCloudSite().getCloudId();
        step.setConfig(Jsons.valueAsString(new ConfExportStepConfig(task.getSpaceKey(), cloudId)));
    }

    @Override
    public TransferTaskType getTransferTaskType() {
        return TransferTaskType.CONFLUENCE_SPACE_EXPORT;
    }
}

