/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.recipe;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import lombok.Generated;

public class RecipeConstants {
    public static final String MIGRATION_EXECUTION = "migration";
    public static final String S2C_MIGRATION = "S2C_MIGRATION";
    public static final String STARTED_BY_ADMIN = "admin";
    public static final String V4_RECIPE_NAME = "confluence-s2c-migration";
    public static final Integer V4_RECIPE_VERSION = 8;
    public static final String V4_LITHIUM_RECIPE_NAME = "confluence-s2c-lithium-migration";
    public static final Integer V4_LITHIUM_RECIPE_VERSION_DEFAULT = 6;
    public static final String SOURCE_ID_TO_FILE_ID = "sourceIdToFileId";
    public static final String SPACE_IDS = "spaceIds";
    public static final String DATA_EXPORT = "dataExport";

    public static Recipe getRecipe(MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        if (migrationDarkFeaturesManager.isV4LithiumMigrationEnabled()) {
            return new Recipe(V4_LITHIUM_RECIPE_NAME, migrationDarkFeaturesManager.getV4LithiumRecipeVersion(), "v4-li-core");
        }
        return new Recipe(V4_RECIPE_NAME, V4_RECIPE_VERSION, "v4-cc-migration");
    }

    private RecipeConstants() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Recipe {
        private final String name;
        private final int version;
        private final String tag;

        Recipe(String name, int version, String tag) {
            this.name = name;
            this.version = version;
            this.tag = tag;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public int getVersion() {
            return this.version;
        }

        @Generated
        public String getTag() {
            return this.tag;
        }
    }
}

