/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers;

import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class V4PollerHelpers {
    private static final String STATUS_READY = "READY";
    private static final String STATUS_IN_PROGRESS = "IN_PROGRESS";
    private static final String STATUS_FAILED = "FAILED";
    private static final String STATUS_SUCCESS = "SUCCESS";
    private static final String DETAIL_KEY_SPACE_ID = "spaceId";
    private static final String DETAIL_KEY_STATUS = "status";

    private V4PollerHelpers() {
    }

    public static class SpaceUploadOutput {
        private final List<Object> spaceIds = new ArrayList<Object>();
        private final List<Object> dataExport = new ArrayList<Object>();

        public void accumulate(StepResult result) {
            Object files;
            if (result == null || result.getResultProperties() == null) {
                return;
            }
            Map<String, Object> props = result.getResultProperties();
            Object sids = props.get("spaceIds");
            if (sids instanceof List) {
                this.spaceIds.addAll((List)sids);
            }
            if ((files = props.get("dataExport")) instanceof List) {
                this.dataExport.addAll((List)files);
            }
        }

        public Map<String, Object> toOutputProps() {
            HashMap<String, Object> outputProps = new HashMap<String, Object>();
            outputProps.put("spaceIds", this.spaceIds);
            outputProps.put("dataExport", this.dataExport);
            return outputProps;
        }
    }

    public static class SpaceExportOutput {
        private final Map<String, Object> sourceIdToFileId = new LinkedHashMap<String, Object>();

        public void accumulate(String sourceId, StepResult result) {
            if (result == null) {
                return;
            }
            this.sourceIdToFileId.put(sourceId, result.getResult());
        }

        public Map<String, Object> toOutputProps() {
            HashMap<String, Object> outputProps = new HashMap<String, Object>();
            outputProps.put("sourceIdToFileId", this.sourceIdToFileId);
            return outputProps;
        }
    }

    public static class SpaceStatusTracker {
        private final LinkedHashMap<String, String> statusBySpace = new LinkedHashMap();

        public static SpaceStatusTracker from(List<String> spaceIds) {
            SpaceStatusTracker tracker = new SpaceStatusTracker();
            for (String sid : spaceIds) {
                tracker.statusBySpace.put(sid, V4PollerHelpers.STATUS_READY);
            }
            return tracker;
        }

        public void markInProgress(String spaceId) {
            this.statusBySpace.put(spaceId, V4PollerHelpers.STATUS_IN_PROGRESS);
        }

        public void markFailed(String spaceId) {
            this.statusBySpace.put(spaceId, V4PollerHelpers.STATUS_FAILED);
        }

        public void markDone(String spaceId) {
            this.statusBySpace.put(spaceId, V4PollerHelpers.STATUS_SUCCESS);
        }

        public int percent() {
            int total = this.statusBySpace.size();
            if (total == 0) {
                return 0;
            }
            long done = this.statusBySpace.values().stream().filter(V4PollerHelpers.STATUS_SUCCESS::equals).count();
            return (int)Math.round((double)done * 100.0 / (double)total);
        }

        public List<Map<String, String>> toDetailsList() {
            ArrayList<Map<String, String>> details = new ArrayList<Map<String, String>>();
            for (Map.Entry<String, String> entry : this.statusBySpace.entrySet()) {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put(V4PollerHelpers.DETAIL_KEY_SPACE_ID, entry.getKey());
                item.put(V4PollerHelpers.DETAIL_KEY_STATUS, entry.getValue());
                details.add(item);
            }
            return details;
        }
    }
}

