/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.TransferStatus;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.LoggingContextBuilder;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.catalogue.TransferProgressRequest;
import com.atlassian.migration.agent.service.catalogue.TransferStatusUpdateRequest;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.check.V4PollerContext;
import com.atlassian.migration.agent.service.check.V4PollerLogger;
import com.atlassian.migration.agent.service.metrics.PollingMetrics;
import com.atlassian.migration.agent.service.prc.GenericPollerConfig;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.prc.PrcOkHttpAdapter;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.v4.InProgressMigrationIds;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.model.AttachmentMigrationPayload;
import com.atlassian.migration.agent.v4.model.ConfluenceSpaceExportPayload;
import com.atlassian.migration.agent.v4.model.ConfluenceSpaceUploadPayload;
import com.atlassian.migration.agent.v4.model.GlobalEntitiesMigrationPayload;
import com.atlassian.migration.agent.v4.model.MigrationPayload;
import com.atlassian.migration.agent.v4.model.UsersGroupsMigrationPayload;
import com.atlassian.migration.agent.v4.pollers.AbstractPoller;
import com.atlassian.migration.agent.v4.pollers.PollerConfig;
import com.atlassian.migration.agent.v4.pollers.V4PollerHelpers;
import com.atlassian.migration.agent.v4.tasks.AttachmentUploadTransferTask;
import com.atlassian.migration.agent.v4.tasks.GlobalEntitiesTransferTask;
import com.atlassian.migration.agent.v4.tasks.SpaceExportTransferTask;
import com.atlassian.migration.agent.v4.tasks.SpaceUploadTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import com.atlassian.migration.agent.v4.tasks.UsersGroupsUploadTask;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.model.config.OnDemandPollerConfig;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.Command;
import com.atlassian.migration.prc.model.CommandName;
import com.atlassian.migration.statusrouter.model.CommandProgressRequest;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import com.atlassian.migration.statusrouter.model.CommandStatusRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;

public class V4Poller<T extends TransferTask>
extends AbstractPoller {
    private static final Logger log = ContextLoggerFactory.getLogger(V4Poller.class);
    private static final String CLOUD_ID = "cloudId";
    private static final String COMMAND_NAME = "commandName";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String MIGRATION_ID = "migrationId";
    private static final String COMMAND_ID = "commandId";
    private static final String WORKER_ID = "workerId";
    private static final String SOURCE_COMMAND_ID = "sourceCommandId";
    private static final String MSG_PROGRESS_ATTACHMENT_UPLOAD = "Checking attachments";
    private static final String MSG_PROGRESS_SPACE_EXPORT = "Exporting database";
    private static final String MSG_PROGRESS_SPACE_UPLOAD = "Uploading data";
    private static final String MSG_SUCCESS_ATTACHMENT_UPLOAD = "Migrated attachments";
    private static final String MSG_SUCCESS_SPACE_EXPORT = "Exported spaces";
    private static final String MSG_SUCCESS_SPACE_UPLOAD = "Uploaded spaces";
    private static final String MSG_FAILURE_SUB_TASK = "Sub-task failed";
    private final V4Worker<T> worker;
    private final PollerConfig config;
    private final OnDemandPrcPoller prcPoller;
    private InProgressMigrationIds migrationIds;
    private final PollerConfigHandler pollerConfigHandler;
    private final SystemInformationService systemInformationService;
    private final PrcOkHttpAdapter prcOkHttpAdapter;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final PollingMetrics pollingMetrics;
    private final V4PollerLogger v4PollerLogger;
    private final ClusterInformationService clusterInformationService;
    private final V4Logger v4Logger;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final MigrationDarkFeaturesManager darkFeaturesManager;

    public V4Poller(String pollerId, V4Worker<T> worker, PollerConfig config, OnDemandPrcPoller prcPoller, InProgressMigrationIds inProgressMigrationIds, PollerConfigHandler pollerConfigHandler, SystemInformationService systemInformationService, PrcOkHttpAdapter prcOkHttpAdapter, MigrationAgentConfiguration migrationAgentConfiguration, PollingMetrics pollingMetrics, V4PollerLogger v4PollerLogger, ClusterInformationService clusterInformationService, V4Logger v4Logger, MigrationDarkFeaturesManager darkFeaturesManager) {
        super(pollerId, config.getPollingDelay());
        this.worker = worker;
        this.config = config;
        this.prcPoller = prcPoller;
        this.migrationIds = inProgressMigrationIds;
        this.pollerConfigHandler = pollerConfigHandler;
        this.systemInformationService = systemInformationService;
        this.prcOkHttpAdapter = prcOkHttpAdapter;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.pollingMetrics = pollingMetrics;
        this.v4PollerLogger = v4PollerLogger;
        this.clusterInformationService = clusterInformationService;
        this.v4Logger = v4Logger;
        this.darkFeaturesManager = darkFeaturesManager;
    }

    @Override
    public boolean doPoll() {
        return this.migrationIds.sequence().anyMatch(m -> this.pollForTaskAndDispatch(m.getCloudSite()));
    }

    private boolean pollForTaskAndDispatch(CloudSite cloudSite) {
        V4PollerContext context = V4PollerContext.builder().pollerId(this.pollerId).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        context.addAdditionalProperties(CLOUD_ID, cloudSite.getCloudId());
        try {
            this.v4PollerLogger.logDebug(log, context, "Polling command for poller.");
            OnDemandPollerConfig pollerConfig = this.buildPrcPollerConfig(cloudSite);
            Command command = this.prcPoller.pollAndDeliver(pollerConfig);
            this.pollingMetrics.incrementV4Poll();
            if (command == null) {
                this.v4PollerLogger.logDebug(log, context, "No command received. Will keep trying.");
                return true;
            }
            this.v4PollerLogger.logInfo(log, context, "Command received: " + command.getId());
            return this.dispatchTask(cloudSite, command);
        }
        catch (Exception e) {
            this.v4PollerLogger.logWarn(log, context, "Failed with exception, will try again: " + e.toString(), e);
            return true;
        }
    }

    public PrcTask toPrcTask(Command command, CloudSite cloudSite) {
        V4LogContext logContext = V4LogContext.builder().nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(CLOUD_ID, cloudSite.getCloudId(), COMMAND_ID, command.getId(), COMMAND_NAME, command.getName());
        try {
            this.v4Logger.logInfo(log, logContext, "Deserializing command payload");
            MigrationPayload payload = (MigrationPayload)OBJECT_MAPPER.readValue(command.getPayload(), this.getMigrationPayloadType(command.getName()));
            return this.getMigrationTask(command, payload, cloudSite);
        }
        catch (JsonProcessingException e) {
            this.v4Logger.logError(log, logContext, "Json Processing Exception during deserializing command payload", e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            this.v4Logger.logError(log, logContext, "IllegalArgumentException during deserializing command payload", e);
            throw new RuntimeException(e);
        }
    }

    private Class<? extends MigrationPayload> getMigrationPayloadType(String commandName) {
        if (Objects.equals(commandName, CommandName.ALL_USER_UPLOAD.getValue())) {
            return UsersGroupsMigrationPayload.class;
        }
        if (Objects.equals(commandName, CommandName.CONFLUENCE_ATTACHMENT_UPLOAD.getValue())) {
            return AttachmentMigrationPayload.class;
        }
        if (Objects.equals(commandName, CommandName.CONFLUENCE_SPACE_EXPORT.getValue())) {
            return ConfluenceSpaceExportPayload.class;
        }
        if (Objects.equals(commandName, CommandName.CONFLUENCE_SPACE_UPLOAD.getValue())) {
            return ConfluenceSpaceUploadPayload.class;
        }
        if (Objects.equals(commandName, CommandName.GLOBAL_ENTITIES_UPLOAD.getValue())) {
            return GlobalEntitiesMigrationPayload.class;
        }
        throw new IllegalArgumentException("Invalid command " + commandName + " supplied for payload conversion");
    }

    private PrcTask<UsersGroupsUploadTask> getUsersGroupsMigrationTask(Command command, UsersGroupsMigrationPayload payload, CloudSite cloudsite) {
        PrcTask<UsersGroupsUploadTask> prcTask = new PrcTask<UsersGroupsUploadTask>();
        prcTask.setTransferTask(new UsersGroupsUploadTask(payload.getSourceCommandId()));
        prcTask.setCommandName(CommandName.ALL_USER_UPLOAD);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        return prcTask;
    }

    private PrcTask<AttachmentUploadTransferTask> getAttachmentUploadTransferTask(Command command, AttachmentMigrationPayload payload, CloudSite cloudsite) {
        PrcTask<AttachmentUploadTransferTask> prcTask = new PrcTask<AttachmentUploadTransferTask>();
        prcTask.setTransferTask(new AttachmentUploadTransferTask(payload.getSourceCommandId(), payload.getSourceId()));
        prcTask.setCommandName(CommandName.CONFLUENCE_ATTACHMENT_UPLOAD);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        V4LogContext logContext = V4LogContext.builder().prcTaskId(((AttachmentUploadTransferTask)prcTask.getTransferTask()).getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(COMMAND_NAME, CommandName.CONFLUENCE_ATTACHMENT_UPLOAD, CLOUD_ID, cloudsite.getCloudId(), SOURCE_COMMAND_ID, payload.getSourceCommandId(), MIGRATION_ID, payload.getMigration().getId());
        this.v4Logger.logInfo(log, logContext, "Attachment upload transfer task created and configured");
        return prcTask;
    }

    private PrcTask<SpaceExportTransferTask> getSpaceExportTransferTask(Command command, ConfluenceSpaceExportPayload payload, CloudSite cloudsite) {
        PrcTask<SpaceExportTransferTask> prcTask = new PrcTask<SpaceExportTransferTask>();
        prcTask.setTransferTask(new SpaceExportTransferTask(payload.getSourceCommandId(), payload.getSourceId()));
        prcTask.setCommandName(CommandName.CONFLUENCE_SPACE_EXPORT);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        return prcTask;
    }

    private PrcTask<SpaceUploadTransferTask> getSpaceUploadTransferTask(Command command, ConfluenceSpaceUploadPayload payload, CloudSite cloudsite) {
        PrcTask<SpaceUploadTransferTask> prcTask = new PrcTask<SpaceUploadTransferTask>();
        prcTask.setTransferTask(new SpaceUploadTransferTask(payload.getSourceCommandId(), payload.getSourceId(), payload.getExportFileId()));
        prcTask.setCommandName(CommandName.CONFLUENCE_SPACE_UPLOAD);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        return prcTask;
    }

    private PrcTask<GlobalEntitiesTransferTask> getGlobalEntitiesTransferTask(Command command, GlobalEntitiesMigrationPayload payload, CloudSite cloudsite) {
        PrcTask<GlobalEntitiesTransferTask> prcTask = new PrcTask<GlobalEntitiesTransferTask>();
        prcTask.setTransferTask(new GlobalEntitiesTransferTask(payload.getSourceCommandId()));
        prcTask.setCommandName(CommandName.GLOBAL_ENTITIES_UPLOAD);
        this.setPrcTaskFields(prcTask, command, payload, cloudsite);
        return prcTask;
    }

    private void setPrcTaskFields(PrcTask prcTask, Command command, MigrationPayload payload, CloudSite cloudsite) {
        prcTask.setPrcCommandId(command.getId());
        prcTask.setMigrationId(payload.getMigration().getId());
        prcTask.setCommandSource(payload.getCommandSource());
        prcTask.setChannelName(this.getChannelName());
        prcTask.setCommand(command);
        prcTask.setCloudSite(cloudsite);
        prcTask.setOriginalPlanId(payload.getMigration().getOriginalPlanId());
        GenericPollerConfig genericPollerConfig = new GenericPollerConfig(prcTask.getChannelName(), prcTask.getCloudSite().getCloudId(), prcTask.getCloudSite().getContainerToken(), this.prcOkHttpAdapter, this.migrationAgentConfiguration.getPrcHostUrl(), Collections.singletonList(prcTask.getCommandName().getValue()));
        prcTask.setGenericPollerConfig(genericPollerConfig);
    }

    private PrcTask getMigrationTask(Command command, MigrationPayload payload, CloudSite cloudsite) {
        if (command.getName().equals(CommandName.ALL_USER_UPLOAD.getValue())) {
            return this.getUsersGroupsMigrationTask(command, (UsersGroupsMigrationPayload)payload, cloudsite);
        }
        if (command.getName().equals(CommandName.CONFLUENCE_ATTACHMENT_UPLOAD.getValue())) {
            return this.getAttachmentUploadTransferTask(command, (AttachmentMigrationPayload)payload, cloudsite);
        }
        if (command.getName().equals(CommandName.GLOBAL_ENTITIES_UPLOAD.getValue())) {
            return this.getGlobalEntitiesTransferTask(command, (GlobalEntitiesMigrationPayload)payload, cloudsite);
        }
        if (command.getName().equals(CommandName.CONFLUENCE_SPACE_EXPORT.getValue())) {
            return this.getSpaceExportTransferTask(command, (ConfluenceSpaceExportPayload)payload, cloudsite);
        }
        if (command.getName().equals(CommandName.CONFLUENCE_SPACE_UPLOAD.getValue())) {
            return this.getSpaceUploadTransferTask(command, (ConfluenceSpaceUploadPayload)payload, cloudsite);
        }
        throw new IllegalArgumentException("Invalid command name supplied for payload conversion");
    }

    private boolean dispatchTask(CloudSite cloudsite, Command command) {
        PackDispatchResult packDispatchResult;
        V4LogContext logContext = V4LogContext.builder().nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(CLOUD_ID, cloudsite.getCloudId(), COMMAND_NAME, command.getName());
        this.v4Logger.logInfo(log, logContext, "Dispatching PRC task started");
        if (this.darkFeaturesManager.enableSpacePacking() && (packDispatchResult = this.dispatchPackedSpaces(cloudsite, command)) != PackDispatchResult.NOT_HANDLED) {
            return packDispatchResult == PackDispatchResult.HANDLED_SUCCESS;
        }
        PrcTask task = this.toPrcTask(command, cloudsite);
        LoggingContextBuilder logCtxBuilder = LoggingContextBuilder.logCtx().withAttribute("prcTaskId", ((TransferTask)task.getTransferTask()).getTaskId());
        try {
            logCtxBuilder.execute(() -> {
                this.worker.process(task, this.prcPoller, this.pollerConfigHandler);
                logContext.setPrcTaskId(((TransferTask)task.getTransferTask()).getTaskId());
                logContext.addAdditionalProperties(MIGRATION_ID, task.getMigrationId());
                this.v4Logger.logInfo(log, logContext, "Dispatching PRC task succeeded");
                return true;
            });
        }
        catch (Exception e) {
            logContext.addAdditionalProperties(WORKER_ID, this.worker.getId());
            this.v4Logger.logError(log, logContext, this.worker.getId() + " task worker failed to process, Marking task as failed in PRC", e);
            this.reportFailureToPRC(cloudsite.getCloudId(), task, e.getMessage());
            return false;
        }
        return true;
    }

    private PackDispatchResult dispatchPackedAttachmentUpload(AttachmentMigrationPayload payload, CloudSite cloudsite, Command command) {
        List<String> sourceIds = payload.getSourceIds();
        if (sourceIds == null || sourceIds.isEmpty()) {
            return PackDispatchResult.NOT_HANDLED;
        }
        V4PollerHelpers.SpaceStatusTracker statusTracker = V4PollerHelpers.SpaceStatusTracker.from(sourceIds);
        int executedTasks = 0;
        for (String id : sourceIds) {
            StepResult result;
            payload.setSourceId(id);
            PrcTask<AttachmentUploadTransferTask> task = this.getAttachmentUploadTransferTask(command, payload, cloudsite);
            task.setSuppressProgressTracking(true);
            statusTracker.markInProgress(id);
            if (executedTasks == 0) {
                this.sendProgressToPRC(task, 0, MSG_PROGRESS_ATTACHMENT_UPLOAD, statusTracker.toDetailsList());
            }
            if ((result = this.worker.process(task, this.prcPoller, this.pollerConfigHandler)) == null || !result.isSuccess() || result.isStopped()) {
                statusTracker.markFailed(id);
                this.sendProgressToPRC(task, statusTracker.percent(), MSG_PROGRESS_ATTACHMENT_UPLOAD, statusTracker.toDetailsList());
                this.reportFailureToPRC(task.getCloudSite().getCloudId(), task, this.getFailureMessage(result));
                return PackDispatchResult.HANDLED_FAILURE;
            }
            statusTracker.markDone(id);
            this.sendProgressToPRC(task, statusTracker.percent(), MSG_PROGRESS_ATTACHMENT_UPLOAD, statusTracker.toDetailsList());
            if (++executedTasks != sourceIds.size()) continue;
            this.reportSuccessToPRC(task, MSG_SUCCESS_ATTACHMENT_UPLOAD, Collections.emptyMap());
        }
        return PackDispatchResult.HANDLED_SUCCESS;
    }

    private PackDispatchResult dispatchPackedSpaceExport(ConfluenceSpaceExportPayload payload, CloudSite cloudsite, Command command) {
        List<String> sourceIds = payload.getSourceIds();
        if (sourceIds == null || sourceIds.isEmpty()) {
            return PackDispatchResult.NOT_HANDLED;
        }
        V4PollerHelpers.SpaceStatusTracker statusTracker = V4PollerHelpers.SpaceStatusTracker.from(sourceIds);
        V4PollerHelpers.SpaceExportOutput exportOutput = new V4PollerHelpers.SpaceExportOutput();
        int executedTasks = 0;
        for (String id : sourceIds) {
            StepResult result;
            payload.setSourceId(id);
            PrcTask<SpaceExportTransferTask> task = this.getSpaceExportTransferTask(command, payload, cloudsite);
            task.setSuppressProgressTracking(true);
            statusTracker.markInProgress(id);
            if (executedTasks == 0) {
                this.sendProgressToPRC(task, 0, MSG_PROGRESS_SPACE_EXPORT, statusTracker.toDetailsList());
            }
            if ((result = this.worker.process(task, this.prcPoller, this.pollerConfigHandler)) == null || !result.isSuccess() || result.isStopped()) {
                statusTracker.markFailed(id);
                this.sendProgressToPRC(task, statusTracker.percent(), MSG_PROGRESS_SPACE_EXPORT, statusTracker.toDetailsList());
                this.reportFailureToPRC(task.getCloudSite().getCloudId(), task, this.getFailureMessage(result));
                return PackDispatchResult.HANDLED_FAILURE;
            }
            exportOutput.accumulate(id, result);
            statusTracker.markDone(id);
            this.sendProgressToPRC(task, statusTracker.percent(), MSG_PROGRESS_SPACE_EXPORT, statusTracker.toDetailsList());
            if (++executedTasks != sourceIds.size()) continue;
            Map<String, Object> outputProps = exportOutput.toOutputProps();
            this.reportSuccessToPRC(task, MSG_SUCCESS_SPACE_EXPORT, outputProps);
        }
        return PackDispatchResult.HANDLED_SUCCESS;
    }

    private PackDispatchResult dispatchPackedSpaceUpload(ConfluenceSpaceUploadPayload payload, CloudSite cloudsite, Command command) {
        Map<String, String> sourceIdToFileId = payload.getSourceIdToFileId();
        if (sourceIdToFileId == null || sourceIdToFileId.isEmpty()) {
            return PackDispatchResult.NOT_HANDLED;
        }
        V4PollerHelpers.SpaceUploadOutput uploadOutput = new V4PollerHelpers.SpaceUploadOutput();
        int executedTasks = 0;
        ArrayList<String> orderedSourceIds = new ArrayList<String>(sourceIdToFileId.keySet());
        V4PollerHelpers.SpaceStatusTracker statusTracker = V4PollerHelpers.SpaceStatusTracker.from(orderedSourceIds);
        for (Map.Entry<String, String> entry : sourceIdToFileId.entrySet()) {
            StepResult result;
            payload.setSourceId(entry.getKey());
            payload.setExportFileId(entry.getValue());
            PrcTask<SpaceUploadTransferTask> task = this.getSpaceUploadTransferTask(command, payload, cloudsite);
            task.setSuppressProgressTracking(true);
            statusTracker.markInProgress(entry.getKey());
            if (executedTasks == 0) {
                this.sendProgressToPRC(task, 0, MSG_PROGRESS_SPACE_UPLOAD, statusTracker.toDetailsList());
            }
            if ((result = this.worker.process(task, this.prcPoller, this.pollerConfigHandler)) == null || !result.isSuccess() || result.isStopped()) {
                statusTracker.markFailed(entry.getKey());
                this.sendProgressToPRC(task, statusTracker.percent(), MSG_PROGRESS_SPACE_UPLOAD, statusTracker.toDetailsList());
                this.reportFailureToPRC(task.getCloudSite().getCloudId(), task, this.getFailureMessage(result));
                return PackDispatchResult.HANDLED_FAILURE;
            }
            uploadOutput.accumulate(result);
            statusTracker.markDone(entry.getKey());
            this.sendProgressToPRC(task, statusTracker.percent(), MSG_PROGRESS_SPACE_UPLOAD, statusTracker.toDetailsList());
            if (++executedTasks != sourceIdToFileId.size()) continue;
            Map<String, Object> outputProps = uploadOutput.toOutputProps();
            this.reportSuccessToPRC(task, MSG_SUCCESS_SPACE_UPLOAD, outputProps);
        }
        return PackDispatchResult.HANDLED_SUCCESS;
    }

    private String getFailureMessage(StepResult result) {
        if (result == null || result.getMessage() == null || result.getMessage().isEmpty()) {
            return MSG_FAILURE_SUB_TASK;
        }
        return result.getMessage();
    }

    private PackDispatchResult dispatchPackedSpaces(CloudSite cloudsite, Command command) {
        try {
            if (Objects.equals(command.getName(), CommandName.CONFLUENCE_ATTACHMENT_UPLOAD.getValue())) {
                AttachmentMigrationPayload payload = (AttachmentMigrationPayload)OBJECT_MAPPER.readValue(command.getPayload(), AttachmentMigrationPayload.class);
                return this.dispatchPackedAttachmentUpload(payload, cloudsite, command);
            }
            if (Objects.equals(command.getName(), CommandName.CONFLUENCE_SPACE_EXPORT.getValue())) {
                ConfluenceSpaceExportPayload payload = (ConfluenceSpaceExportPayload)OBJECT_MAPPER.readValue(command.getPayload(), ConfluenceSpaceExportPayload.class);
                return this.dispatchPackedSpaceExport(payload, cloudsite, command);
            }
            if (Objects.equals(command.getName(), CommandName.CONFLUENCE_SPACE_UPLOAD.getValue())) {
                ConfluenceSpaceUploadPayload payload = (ConfluenceSpaceUploadPayload)OBJECT_MAPPER.readValue(command.getPayload(), ConfluenceSpaceUploadPayload.class);
                return this.dispatchPackedSpaceUpload(payload, cloudsite, command);
            }
            return PackDispatchResult.NOT_HANDLED;
        }
        catch (JsonProcessingException e) {
            V4LogContext logContext = V4LogContext.builder().nodeId(this.clusterInformationService.getCurrentNodeId()).build();
            logContext.addAdditionalProperties(CLOUD_ID, cloudsite.getCloudId(), COMMAND_NAME, command.getName());
            this.v4Logger.logError(log, logContext, "JSON deserialization error dispatching tasks", e);
            return PackDispatchResult.NOT_HANDLED;
        }
    }

    private String getChannelName() {
        return "confluence-server-to-cloud-" + this.systemInformationService.getConfluenceInfo().getServerId();
    }

    public OnDemandPollerConfig buildPrcPollerConfig(CloudSite cloudSite) {
        return this.pollerConfigHandler.getOnDemandPollerConfigWithCallbacks(this.getChannelName(), cloudSite.getCloudId(), cloudSite.getContainerToken(), Collections.singletonList(this.worker.getCommandName().getValue()));
    }

    private void reportFailureToPRC(String cloudId, PrcTask<T> task, String message) {
        V4LogContext logContext = V4LogContext.builder().prcTaskId(((TransferTask)task.getTransferTask()).getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(CLOUD_ID, cloudId, ERROR_MESSAGE, message, MIGRATION_ID, task.getMigrationId(), COMMAND_ID, task.getPrcCommandId(), WORKER_ID, this.worker.getId());
        try {
            this.v4Logger.logInfo(log, logContext, "Update failure result to PRC");
            OnDemandPollerConfig pollerConfig = this.buildPrcPollerConfig(task.getCloudSite());
            TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.FAILED, message);
            ObjectMapper map = new ObjectMapper();
            JsonNode payload = (JsonNode)map.convertValue((Object)transferStatusUpdateRequest, JsonNode.class);
            payload = map.createObjectNode().set("migration", payload);
            CommandStatusRequest commandStatusRequest = new CommandStatusRequest(task.getCommandSource(), CommandStatus.FAILED, ((TransferTask)task.getTransferTask()).getTaskId(), payload);
            this.prcPoller.sendCommandCompletionStatus(pollerConfig, task.getPrcCommandId().longValue(), commandStatusRequest);
        }
        catch (RuntimeException r) {
            this.v4Logger.logError(log, logContext, "Failed to update task status in PRC", r);
        }
    }

    private void reportSuccessToPRC(PrcTask<T> task, String statusMessage, Map<String, Object> outputProperties) {
        V4LogContext logContext = V4LogContext.builder().prcTaskId(((TransferTask)task.getTransferTask()).getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
        logContext.addAdditionalProperties(CLOUD_ID, task.getCloudSite().getCloudId(), MIGRATION_ID, task.getMigrationId(), COMMAND_ID, task.getPrcCommandId(), WORKER_ID, this.worker.getId());
        try {
            this.v4Logger.logInfo(log, logContext, "Update success result with outputProperties to PRC");
            OnDemandPollerConfig pollerConfig = this.buildPrcPollerConfig(task.getCloudSite());
            TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(TransferStatus.SUCCESS, statusMessage, outputProperties);
            ObjectMapper map = new ObjectMapper();
            JsonNode payload = (JsonNode)map.convertValue((Object)transferStatusUpdateRequest, JsonNode.class);
            payload = map.createObjectNode().set("migration", payload);
            CommandStatusRequest commandStatusRequest = new CommandStatusRequest(task.getCommandSource(), CommandStatus.SUCCESS, ((TransferTask)task.getTransferTask()).getTaskId(), payload);
            this.prcPoller.sendCommandCompletionStatus(pollerConfig, task.getPrcCommandId().longValue(), commandStatusRequest);
        }
        catch (RuntimeException r) {
            this.v4Logger.logError(log, logContext, "Failed to update task success with outputProperties in PRC", r);
        }
    }

    private void sendProgressToPRC(PrcTask<?> task, int percent, String message, List<Map<String, String>> details) {
        try {
            HashMap<String, Object> progressProps = new HashMap<String, Object>();
            progressProps.put("details", details);
            TransferProgressRequest progress = new TransferProgressRequest(percent, message, progressProps);
            JsonNode payload = OBJECT_MAPPER.valueToTree((Object)progress);
            payload = OBJECT_MAPPER.createObjectNode().set("migration", payload);
            CommandProgressRequest commandProgressRequest = new CommandProgressRequest(task.getCommandSource(), ((TransferTask)task.getTransferTask()).getTaskId(), payload);
            this.prcPoller.sendCommandProgress(task.getGenericPollerConfig().getOnDemandPollerPostConfig(), task.getPrcCommandId().longValue(), commandProgressRequest);
        }
        catch (RuntimeException r) {
            V4LogContext logContext = V4LogContext.builder().prcTaskId(((TransferTask)task.getTransferTask()).getTaskId()).nodeId(this.clusterInformationService.getCurrentNodeId()).build();
            logContext.addAdditionalProperties(CLOUD_ID, task.getCloudSite().getCloudId(), MIGRATION_ID, task.getMigrationId(), COMMAND_ID, task.getPrcCommandId(), WORKER_ID, this.worker.getId());
            this.v4Logger.logError(log, logContext, "Failed to send progress update to PRC", r);
        }
    }

    @Generated
    public V4Worker<T> getWorker() {
        return this.worker;
    }

    private static enum PackDispatchResult {
        NOT_HANDLED,
        HANDLED_SUCCESS,
        HANDLED_FAILURE;

    }
}

