/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.jpa.impl;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.store.jpa.SessionFactorySupplier;
import com.atlassian.migration.agent.store.jpa.impl.ThreadBoundSessionContext;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.store.tx.TransactionException;
import java.util.Locale;
import java.util.function.Supplier;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.exception.LockAcquisitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class DefaultPluginTransactionTemplate
implements PluginTransactionTemplate {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginTransactionTemplate.class);
    private final SessionFactorySupplier sessionFactorySupplier;

    public DefaultPluginTransactionTemplate(SessionFactorySupplier sessionFactorySupplier) {
        this.sessionFactorySupplier = sessionFactorySupplier;
        log.debug("Initialized DefaultPluginTransactionTemplate with session factory supplier");
    }

    @Override
    public <T> T on(boolean readonly, Supplier<T> action) {
        RetryPolicy txnPolicy = RetryPolicyBuilder.transactionRetryPolicy().withPredicate(this::isDeadlock).build().onRetry(e -> log.debug("Retry attempt {}", (Object)e.getAttemptCount()));
        return (T)Failsafe.with((Policy)txnPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
            Session session = ((SessionFactory)this.sessionFactorySupplier.get()).getCurrentSession();
            Transaction transaction = session.getTransaction();
            if (transaction.isActive()) {
                return action.get();
            }
            try {
                transaction.begin();
                Object result = action.get();
                transaction.commit();
                Object t = result;
                return t;
            }
            catch (RuntimeException e) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                throw e;
            }
            catch (Exception e) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                throw new TransactionException("Error occurred when executing transaction", e);
            }
            finally {
                ThreadBoundSessionContext.unbind(session.getSessionFactory());
                session.close();
            }
        });
    }

    private boolean isDeadlock(Throwable t) {
        while (t != null) {
            if (t instanceof LockAcquisitionException) {
                return true;
            }
            String msg = t.getMessage();
            if (msg != null && msg.toLowerCase(Locale.ROOT).contains("deadlock")) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }
}

