/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.jpa.impl;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.atlassian.migration.agent.store.jpa.QueryBuilder;
import com.atlassian.migration.agent.store.jpa.SessionFactorySupplier;
import com.atlassian.migration.agent.store.jpa.impl.DefaultQueryBuilder;
import com.atlassian.migration.agent.store.jpa.impl.StatelessResults;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.UnaryOperator;
import javax.persistence.EntityManager;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.query.Query;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class DefaultEntityManagerTemplate
implements EntityManagerTemplate {
    private final SessionFactorySupplier sessionFactorySupplier;
    private final IntSupplier batchSizeSupplier;
    private static final Logger log = ContextLoggerFactory.getLogger(DefaultEntityManagerTemplate.class);

    public DefaultEntityManagerTemplate(SessionFactorySupplier sessionFactorySupplier, IntSupplier batchSizeSupplier) {
        this.sessionFactorySupplier = sessionFactorySupplier;
        this.batchSizeSupplier = batchSizeSupplier;
    }

    @Override
    public <T> T execute(Function<EntityManager, T> action) {
        Session session = ((SessionFactory)this.sessionFactorySupplier.get()).getCurrentSession();
        return action.apply((EntityManager)session);
    }

    @Override
    public void execute(Consumer<EntityManager> action) {
        Session session = ((SessionFactory)this.sessionFactorySupplier.get()).getCurrentSession();
        action.accept((EntityManager)session);
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public QueryBuilder<Void> query(String jpql) {
        return new DefaultQueryBuilder<Void>(this, this.batchSizeSupplier, em -> em.createQuery(jpql));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public <T> QueryBuilder<T> query(Class<T> entityType, String jpql) {
        return new DefaultQueryBuilder(this, this.batchSizeSupplier, em -> em.createQuery(jpql, entityType));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public <T> QueryBuilder<T> nativeQuery(Class<T> resultType, String sql) {
        return new DefaultQueryBuilder(this, this.batchSizeSupplier, em -> em.createNativeQuery(sql, resultType));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public <T> QueryBuilder<T> namedQuery(Class<T> entityType, String queryName) {
        return new DefaultQueryBuilder(this, this.batchSizeSupplier, em -> em.createNamedQuery(queryName, entityType));
    }

    @Override
    public <T> StatelessResults<T> getStatelessResults(Class<T> entityClass, String query, UnaryOperator<Query<T>> queryBuilder) {
        StatelessSession session = ((SessionFactory)this.sessionFactorySupplier.get()).openStatelessSession();
        try {
            Query statelessQuery = (Query)queryBuilder.apply(session.createQuery(query, entityClass));
            return new StatelessResults(session, statelessQuery);
        }
        catch (Exception e) {
            try {
                session.close();
            }
            catch (HibernateException he) {
                log.error("Error while closing hibernate connection", (Throwable)he);
            }
            throw e;
        }
    }

    @Override
    public void evictAll(List<?> entities) {
        Session session = ((SessionFactory)this.sessionFactorySupplier.get()).getCurrentSession();
        entities.forEach(arg_0 -> ((Session)session).evict(arg_0));
    }
}

