/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.service.extract.ExtractionAnalyticsService;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.collect.Iterables;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SpacePermissionStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpacePermissionStore.class);
    private static final String USER_EXTRACTION_CONCURRENCY_METRIC_NAME = "migration.sli.user.extraction.concurrency";
    private static final String USERS_WITH_SPACE_PERMISSIONS_EXTRACTION_METRIC_NAME = "migration.sli.users.with.space.permissions.extraction";
    private static final String GROUPS_WITH_SPACE_PERMISSIONS_EXTRACTION_METRIC_NAME = "migration.sli.groups.with.space.permissions.extraction";
    private static final int DEFAULT_MIN_CONCURRENT_DB_OPERATIONS = 1;
    private static final int DEFAULT_MAX_CONCURRENT_DB_OPERATIONS = 4;
    private final AtomicReference<ExecutorService> sharedExecutor = new AtomicReference();
    private static final String WHERE_SPACE_KEYS_IN_PERMISSIONS_CONDITION = "where spacePermission.space.key in :keys ";
    private static final String WHERE_GT_PERMISSIONS_CONDITION = "where spacePermission.permType in ('SYSTEMADMINISTRATOR', 'ADMINISTRATECONFLUENCE')\n AND spacePermission.space.id is NULL ";
    private final EntityManagerTemplate entityManagerTemplate;
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final ExtractionAnalyticsService extractionAnalyticsService;

    @javax.annotation.PreDestroy
    @PreDestroy
    public void cleanup() {
        ExecutorService executor = this.sharedExecutor.getAndSet(null);
        if (executor != null) {
            executor.shutdown();
        }
    }

    public SpacePermissionStore(EntityManagerTemplate tmpl, MigrationAgentConfiguration migrationAgentConfiguration, MigrationDarkFeaturesManager migrationDarkFeaturesManager, ExtractionAnalyticsService extractionAnalyticsService) {
        this.entityManagerTemplate = tmpl;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.extractionAnalyticsService = extractionAnalyticsService;
    }

    private synchronized ExecutorService getOrCreateExecutor() {
        ExecutorService executor = this.sharedExecutor.get();
        if (executor == null) {
            executor = this.createThreadPool();
            this.sharedExecutor.set(executor);
        }
        return executor;
    }

    private ExecutorService createThreadPool() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int threadPoolSize = this.calculateThreadPoolSize(availableProcessors);
        log.info("Creating thread pool with size {} based on {} available processors", (Object)threadPoolSize, (Object)availableProcessors);
        this.extractionAnalyticsService.sendExtractionConcurrencyAnalytics(USER_EXTRACTION_CONCURRENCY_METRIC_NAME, threadPoolSize);
        return Executors.newFixedThreadPool(threadPoolSize);
    }

    private int calculateThreadPoolSize(int availableProcessors) {
        int minConcurrentOps = 1;
        int maxConcurrentOps = 4;
        try {
            List<Double> parallelScopedUGMinMax = this.migrationDarkFeaturesManager.isParallelScopedUsersAndGroupsMinMaxEnabled();
            if (parallelScopedUGMinMax != null && parallelScopedUGMinMax.size() == 2) {
                minConcurrentOps = parallelScopedUGMinMax.get(0).intValue();
                maxConcurrentOps = parallelScopedUGMinMax.get(1).intValue();
            }
        }
        catch (Exception e) {
            log.warn("Failed to get parallel scoped users and groups min/max values, using defaults", (Throwable)e);
        }
        int calculatedSize = (int)Math.ceil((double)availableProcessors * 0.5);
        return Math.min(Math.max(calculatedSize, minConcurrentOps), maxConcurrentOps);
    }

    public List<String> getSpacesWithAnonymousPermissions(Set<String> spaceKeys) {
        ArrayList<String> spacesWithAnonymousPermissions = new ArrayList<String>();
        for (List subset : Iterables.partition(spaceKeys, (int)this.migrationAgentConfiguration.getDBQueryParameterLimit())) {
            String query = "select distinct spacePermission.space.key from SpacePermission spacePermission where spacePermission.space.key in :keys AND spacePermission.permGroupName is NULL AND spacePermission.permUsername is NULL";
            List<String> result = this.entityManagerTemplate.query(String.class, query).param("keys", (Object)subset).list();
            spacesWithAnonymousPermissions.addAll(result);
        }
        return spacesWithAnonymousPermissions;
    }

    public Set<String> getUsersWithSpacePermissions(Set<String> spaceKeys) {
        Set<Object> usersWithPermissions;
        String query = "select distinct spacePermission.permUsername from SpacePermission spacePermission where spacePermission.space.key in :keys AND spacePermission.permGroupName is NULL AND spacePermission.permUsername is NOT NULL";
        if (this.migrationDarkFeaturesManager.isParallelScopedUsersAndGroupsExportEnabled()) {
            Instant start = Instant.now();
            usersWithPermissions = ConcurrentHashMap.newKeySet();
            ArrayList futures = new ArrayList();
            StreamSupport.stream(Iterables.partition(spaceKeys, (int)this.migrationAgentConfiguration.getDBQueryParameterLimit()).spliterator(), true).forEach(subset -> {
                Future<?> future = this.getOrCreateExecutor().submit(() -> {
                    List<String> users = this.entityManagerTemplate.query(String.class, query).param("keys", subset).list();
                    usersWithPermissions.addAll(users);
                });
                futures.add(future);
            });
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Thread interrupted while getting users with space permissions: ", (Throwable)e);
                    break;
                }
                catch (Exception e) {
                    log.error("Error occurred while getting users with space permissions: ", (Throwable)e);
                }
            }
            long elapsedTime = start.until(Instant.now(), ChronoUnit.MILLIS);
            this.extractionAnalyticsService.sendExtractionAnalytics(USERS_WITH_SPACE_PERMISSIONS_EXTRACTION_METRIC_NAME, elapsedTime, usersWithPermissions.size());
        } else {
            usersWithPermissions = this.getUsersWithSpacePermissionsWithoutParallelism(spaceKeys, query);
        }
        log.info("Total users with space permissions: {}", (Object)usersWithPermissions.size());
        return usersWithPermissions;
    }

    private Set<String> getUsersWithSpacePermissionsWithoutParallelism(Set<String> spaceKeys, String query) {
        HashSet<String> usersWithPermissions = new HashSet<String>();
        for (List subset : Iterables.partition(spaceKeys, (int)this.migrationAgentConfiguration.getDBQueryParameterLimit())) {
            List<String> users = this.entityManagerTemplate.query(String.class, query).param("keys", (Object)subset).list();
            usersWithPermissions.addAll(users);
        }
        return usersWithPermissions;
    }

    public Set<String> getMembersUnderGroupsWithSpacePermissions(Set<String> spaceKeys) {
        Set<Object> usersWithPermissions;
        String groupJoinCondition = this.getSpacePermissionAndGroupJoinCondition();
        String query = "select distinct userMapping.userKey from SpacePermission spacePermission inner join CrowdGroup crowdGroup on " + groupJoinCondition + " inner join CrowdMembership crowdMembership on crowdGroup.id = crowdMembership.parent inner join CrowdUser crowdUser on crowdMembership.child = crowdUser.id inner join UserMapping userMapping on crowdUser.lowerUsername = userMapping.lowerUsername " + WHERE_SPACE_KEYS_IN_PERMISSIONS_CONDITION + "AND crowdGroup.crowdDirectory.active is true AND crowdGroup.crowdDirectory.id = crowdUser.crowdDirectory.id AND spacePermission.permGroupName is NOT NULL";
        if (this.migrationDarkFeaturesManager.isParallelScopedUsersAndGroupsExportEnabled()) {
            Instant start = Instant.now();
            usersWithPermissions = ConcurrentHashMap.newKeySet();
            ArrayList futures = new ArrayList();
            StreamSupport.stream(Iterables.partition(spaceKeys, (int)this.migrationAgentConfiguration.getDBQueryParameterLimit()).spliterator(), true).forEach(subset -> {
                Future<?> future = this.getOrCreateExecutor().submit(() -> {
                    List<String> users = this.entityManagerTemplate.query(String.class, query).param("keys", subset).list();
                    usersWithPermissions.addAll(users);
                });
                futures.add(future);
            });
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Thread interrupted while getting members under groups with space permissions: ", (Throwable)e);
                    break;
                }
                catch (Exception e) {
                    log.error("Error occurred while getting members under groups with space permissions: ", (Throwable)e);
                }
            }
            long elapsedTime = start.until(Instant.now(), ChronoUnit.MILLIS);
            this.extractionAnalyticsService.sendExtractionAnalytics(GROUPS_WITH_SPACE_PERMISSIONS_EXTRACTION_METRIC_NAME, elapsedTime, usersWithPermissions.size());
        } else {
            usersWithPermissions = this.getUsersWithSpacePermissionsWithoutParallelism(spaceKeys, query);
        }
        log.info("Total members under groups with space permissions: {}", (Object)usersWithPermissions.size());
        return usersWithPermissions;
    }

    public Set<String> getMembersUnderGroupsWithGlobalEntitiesPermissions() {
        HashSet<String> usersWithPermissions = new HashSet<String>();
        String groupJoinCondition = this.getSpacePermissionAndGroupJoinCondition();
        String query = "select distinct userMapping.userKey from SpacePermission spacePermission inner join CrowdGroup crowdGroup on " + groupJoinCondition + " inner join CrowdMembership crowdMembership on crowdGroup.id = crowdMembership.parent inner join CrowdUser crowdUser on crowdMembership.child = crowdUser.id inner join UserMapping userMapping on crowdUser.lowerUsername = userMapping.lowerUsername " + WHERE_GT_PERMISSIONS_CONDITION + "AND crowdGroup.crowdDirectory.active is true AND crowdGroup.crowdDirectory.id = crowdUser.crowdDirectory.id AND spacePermission.permGroupName is NOT NULL";
        List<String> users = this.entityManagerTemplate.query(String.class, query).list();
        usersWithPermissions.addAll(users);
        log.info("Total members under groups with global entities permissions: {}", (Object)usersWithPermissions.size());
        return usersWithPermissions;
    }

    private String getSpacePermissionAndGroupJoinCondition() {
        String joinCondition = this.migrationDarkFeaturesManager.isPermGroupCaseFixEnabled() ? "lower(spacePermission.permGroupName) = lower(crowdGroup.lowerGroupName)" : "spacePermission.permGroupName = crowdGroup.lowerGroupName";
        return joinCondition;
    }
}

