/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries.membership;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;

public final class MembershipEntityCounts {
    private final long[] ids;
    private final long[] counts;
    private final int averageCount;
    private final long maxCount;

    public MembershipEntityCounts(long[] ids, long[] counts) {
        this.ids = ids;
        this.counts = counts;
        long sum = 0L;
        long max = 0L;
        for (long count : counts) {
            max = Math.max(max, count);
            sum += count;
        }
        this.maxCount = max;
        this.averageCount = counts.length == 0 ? 0 : (int)(sum / (long)counts.length);
    }

    public <T> List<T> getIdsHavingAtLeast(long minCount, BiFunction<Long, Long, T> mappingFunction) {
        return this.getSorted(mappingFunction, minCount, Long.valueOf(this.counts.length));
    }

    public <T> List<T> getTopIds(long limit, BiFunction<Long, Long, T> mappingFunction) {
        return this.getSorted(mappingFunction, 1L, limit);
    }

    public <T> List<T> getAllIds(BiFunction<Long, Long, T> mappingFunction) {
        return this.getSorted(mappingFunction, null, null);
    }

    private <T> List<T> getSorted(BiFunction<Long, Long, T> mappingFunction, Long minCount, Long limit) {
        Stream<Integer> stream = IntStream.range(0, this.ids.length).filter(i -> this.counts[i] >= (minCount != null ? minCount : 1L)).boxed().sorted(Comparator.comparingLong(i -> this.counts[i]).reversed());
        if (limit != null) {
            stream = stream.limit(limit);
        }
        return stream.map(index -> mappingFunction.apply(this.ids[index], this.counts[index])).collect(Collectors.toList());
    }

    @Generated
    public long[] getIds() {
        return this.ids;
    }

    @Generated
    public long[] getCounts() {
        return this.counts;
    }

    @Generated
    public int getAverageCount() {
        return this.averageCount;
    }

    @Generated
    public long getMaxCount() {
        return this.maxCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MembershipEntityCounts)) {
            return false;
        }
        MembershipEntityCounts other = (MembershipEntityCounts)o;
        if (this.getAverageCount() != other.getAverageCount()) {
            return false;
        }
        if (this.getMaxCount() != other.getMaxCount()) {
            return false;
        }
        if (!Arrays.equals(this.getIds(), other.getIds())) {
            return false;
        }
        return Arrays.equals(this.getCounts(), other.getCounts());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAverageCount();
        long $maxCount = this.getMaxCount();
        result = result * 59 + (int)($maxCount >>> 32 ^ $maxCount);
        result = result * 59 + Arrays.hashCode(this.getIds());
        result = result * 59 + Arrays.hashCode(this.getCounts());
        return result;
    }

    @Generated
    public String toString() {
        return "MembershipEntityCounts(ids=" + Arrays.toString(this.getIds()) + ", counts=" + Arrays.toString(this.getCounts()) + ", averageCount=" + this.getAverageCount() + ", maxCount=" + this.getMaxCount() + ")";
    }
}

