/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.Attachment;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.logging.GroupedThreadFactory;
import com.atlassian.migration.agent.media.MediaClientToken;
import com.atlassian.migration.agent.media.MediaClientTokenSupplier;
import com.atlassian.migration.agent.media.MediaUploadException;
import com.atlassian.migration.agent.service.AttachmentService;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.MigrationErrorCode;
import com.atlassian.migration.agent.service.SpaceAttachmentCount;
import com.atlassian.migration.agent.service.StatisticsService;
import com.atlassian.migration.agent.service.UploadState;
import com.atlassian.migration.agent.service.check.CheckOverrideService;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.execution.SpaceBoundStepExecutor;
import com.atlassian.migration.agent.service.impl.ConcurrencySettingsService;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.media.MediaValidationService;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.UsersMappingService;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationAnalyticsService;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationChecker;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrator;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentsToMigrateConsumer;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentsUploadTracker;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.tasks.AttachmentUploadTransferTask;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class AttachmentMigrationExecutor
implements SpaceBoundStepExecutor {
    private static final String PRODUCER_CONSUMER_THROWABLE = "PRODUCER_CONSUMER_THROWABLE";
    private static final String MEDIA_UPLOAD_THROWABLE = "MEDIA_UPLOAD_THROWABLE";
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentMigrationExecutor.class);
    public static final String SUCCESSFULLY_MIGRATED_BYTES_PROGRESS_PROPERTIES = "successfullyMigratedBytes";
    public static final String TOTAL_SPACE_ATTACHMENT_SIZE_PROGRESS_PROPERTIES = "totalSpaceAttachmentSize";
    private static final String SPACE_KEY = "spaceKey";
    private static final String MIGRATION_ID = "migrationId";
    private static final String CLOUD_ID = "cloudId";
    private final ConcurrentHashMap<String, Object> stepUpdateProgressLocks = new ConcurrentHashMap();
    private final AttachmentMigrator attachmentMigrator;
    private final AttachmentService attachmentService;
    private final CloudSiteService cloudSiteService;
    private final MigrationAgentConfiguration configuration;
    private final StatisticsService statisticsService;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final ProgressTracker progressTracker;
    private final MediaClientTokenSupplier mediaClientTokenSupplier;
    private final MigrationDarkFeaturesManager darkFeaturesManager;
    private final PluginTransactionTemplate ptx;
    private final StepStore stepStore;
    private final Supplier<Instant> instantSupplier;
    private final AttachmentMigrationChecker attachmentMigrationChecker;
    private final AttachmentMigrationAnalyticsService attachmentMigrationAnalyticsService;
    private final SpaceManager spaceManager;
    private final CheckOverrideService checkOverrideService;
    private final UsersMappingService usersMappingService;
    private final ShadowMigrationExecutor shadowMigrationExecutor;
    private final V4Logger v4Logger;
    private final ClusterInformationService clusterInformationService;
    private final ConcurrencySettingsService concurrencySettingsService;
    private final PlanStore planStore;
    private final MediaValidationService mediaValidationService;

    public AttachmentMigrationExecutor(ProgressTracker progressTracker, AttachmentService attachmentService, AttachmentMigrator attachmentMigrator, CloudSiteService cloudSiteService, MigrationAgentConfiguration migrationAgentConfiguration, StatisticsService statisticsService, MediaClientTokenSupplier mediaClientTokenSupplier, PluginTransactionTemplate ptx, StepStore stepStore, AttachmentMigrationChecker attachmentMigrationChecker, AttachmentMigrationAnalyticsService attachmentMigrationAnalyticsService, MigrationDarkFeaturesManager darkFeaturesManager, SpaceManager spaceManager, CheckOverrideService checkOverrideService, UsersMappingService usersMappingService, ShadowMigrationExecutor shadowMigrationExecutor, V4Logger v4Logger, ClusterInformationService clusterInformationService, ConcurrencySettingsService concurrencySettingsService, PlanStore planStore, MediaValidationService mediaValidationService) {
        this(progressTracker, attachmentService, attachmentMigrator, cloudSiteService, migrationAgentConfiguration, statisticsService, mediaClientTokenSupplier, ptx, () -> Executors.newCachedThreadPool(new GroupedThreadFactory("AttachmentMigrationExecutor")), stepStore, Instant::now, attachmentMigrationChecker, attachmentMigrationAnalyticsService, darkFeaturesManager, spaceManager, checkOverrideService, usersMappingService, shadowMigrationExecutor, v4Logger, clusterInformationService, concurrencySettingsService, planStore, mediaValidationService);
    }

    @VisibleForTesting
    AttachmentMigrationExecutor(ProgressTracker progressTracker, AttachmentService attachmentService, AttachmentMigrator attachmentMigrator, CloudSiteService cloudSiteService, MigrationAgentConfiguration migrationAgentConfiguration, StatisticsService statisticsService, MediaClientTokenSupplier mediaClientTokenSupplier, PluginTransactionTemplate ptx, Supplier<ExecutorService> executorServiceSupplier, StepStore stepStore, Supplier<Instant> instantSupplier, AttachmentMigrationChecker attachmentMigrationChecker, AttachmentMigrationAnalyticsService attachmentMigrationAnalyticsService, MigrationDarkFeaturesManager darkFeaturesManager, SpaceManager spaceManager, CheckOverrideService checkOverrideService, UsersMappingService usersMappingService, ShadowMigrationExecutor shadowMigrationExecutor, V4Logger v4Logger, ClusterInformationService clusterInformationService, ConcurrencySettingsService concurrencySettingsService, PlanStore planStore, MediaValidationService mediaValidationService) {
        this.progressTracker = progressTracker;
        this.attachmentService = attachmentService;
        this.attachmentMigrator = attachmentMigrator;
        this.cloudSiteService = cloudSiteService;
        this.configuration = migrationAgentConfiguration;
        this.statisticsService = statisticsService;
        this.mediaClientTokenSupplier = mediaClientTokenSupplier;
        this.ptx = ptx;
        this.executorServiceSupplier = executorServiceSupplier;
        this.stepStore = stepStore;
        this.instantSupplier = instantSupplier;
        this.attachmentMigrationChecker = attachmentMigrationChecker;
        this.attachmentMigrationAnalyticsService = attachmentMigrationAnalyticsService;
        this.darkFeaturesManager = darkFeaturesManager;
        this.spaceManager = spaceManager;
        this.checkOverrideService = checkOverrideService;
        this.usersMappingService = usersMappingService;
        this.shadowMigrationExecutor = shadowMigrationExecutor;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
        this.concurrencySettingsService = concurrencySettingsService;
        this.planStore = planStore;
        this.mediaValidationService = mediaValidationService;
        V4LogContext logContext = V4LogContext.builder().build();
        logContext.addAdditionalProperties("attachmentUploadBatchSize", migrationAgentConfiguration.getAttachmentUploadBatchSize());
        v4Logger.logInfo(log, logContext, "Initialized attachment migration executor");
    }

    void sendV4CompletionStatus(boolean success, String spaceKey, Optional<PrcTask<AttachmentUploadTransferTask>> prcTask, @Nullable UploadState uploadState, String statusMessage) {
        if (prcTask.isPresent()) {
            V4LogContext logContext = V4LogContext.builder().build();
            logContext.addAdditionalProperties(SPACE_KEY, spaceKey, "success", success);
            if (success) {
                this.v4Logger.logInfo(log, logContext, "Sending success completion status for attachments migration");
                this.progressTracker.sendV4AttachmentSuccessStatus(spaceKey, prcTask.get(), uploadState, statusMessage);
            } else {
                this.v4Logger.logInfo(log, logContext, "Sending failure completion status for attachments migration");
                this.progressTracker.sendV4SpaceFailureStatus(prcTask.get(), statusMessage);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    StepResult doAttachmentMigration(Step step, String spaceKey, Optional<PrcTask<AttachmentUploadTransferTask>> prcTask) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateProgress(String stepId, UploadState uploadState, Optional<PrcTask> prcTask) {
        Object lock;
        Object object = lock = this.stepUpdateProgressLocks.computeIfAbsent(stepId, k -> new Object());
        synchronized (object) {
            Map<String, Object> uploadProgressProperties = AttachmentMigrationExecutor.getUploadProgressProperties(uploadState);
            this.progressTracker.progress(stepId, uploadState.percentOfProgress, AttachmentMigrationExecutor.getProgressMessage(uploadState), StepType.ATTACHMENT_UPLOAD.getDetailedStatus(), uploadProgressProperties, prcTask);
        }
    }

    private static Map<String, Object> getUploadProgressProperties(UploadState uploadState) {
        return ImmutableMap.builder().put((Object)SUCCESSFULLY_MIGRATED_BYTES_PROGRESS_PROPERTIES, (Object)uploadState.uploadedBytes).put((Object)TOTAL_SPACE_ATTACHMENT_SIZE_PROGRESS_PROPERTIES, (Object)uploadState.totalBytesToUpload).build();
    }

    private static Map<String, Object> getEmptyUploadProgressProperties() {
        return ImmutableMap.builder().put((Object)SUCCESSFULLY_MIGRATED_BYTES_PROGRESS_PROPERTIES, (Object)0).put((Object)TOTAL_SPACE_ATTACHMENT_SIZE_PROGRESS_PROPERTIES, (Object)0).build();
    }

    private void logAndBuildAnalyticsPostMigration(String spaceKey, CloudSite cloudSite, String migrationId, long totalCountOfAttachments, UploadState uploadState, Step step, long startTime) {
        SpaceAttachmentCount spaceAttachmentCount = this.attachmentService.getAttachmentsCountInSpaceAndMigrated(spaceKey, cloudSite.getCloudId(), totalCountOfAttachments);
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).build();
        logContext.addAdditionalProperties(MIGRATION_ID, migrationId, CLOUD_ID, cloudSite.getCloudId(), SPACE_KEY, spaceKey, "totalCountOfAttachments", totalCountOfAttachments, "contentAttachmentCount", spaceAttachmentCount.contentAttachmentCount, "retrievedMigAttachmentCount", spaceAttachmentCount.retrievedMigAttachmentCount, "unRetrievableMigAttachmentCount", spaceAttachmentCount.unRetrievableMigAttachmentCount);
        this.v4Logger.logInfo(log, logContext, String.format("Attachment details for spaceKey %s", spaceKey));
        this.attachmentMigrationAnalyticsService.buildAttachmentMigrationEventSuccessful(this.instantSupplier.get().toEpochMilli() - startTime, spaceAttachmentCount, uploadState, step);
    }

    private StepResult failedStepResult(MigrationErrorCode errorCode, String reason, Optional<Throwable> optionalThrowable, String migrationId, String cloudId, Step step, String spaceKey, Optional<PrcTask<AttachmentUploadTransferTask>> prcTask) {
        V4LogContext logContext = V4LogContext.builder().stepId(step.getId()).nodeExecutionId(step.getNodeExecutionId()).executionState(step.getExecutionState()).build();
        logContext.addAdditionalProperties(MIGRATION_ID, migrationId, CLOUD_ID, cloudId, SPACE_KEY, spaceKey, "errorCode", errorCode.getCode(), "reason", reason);
        this.v4Logger.logError(log, logContext, "Attachment upload failed", null);
        this.sendV4CompletionStatus(false, spaceKey, prcTask, null, reason);
        return optionalThrowable.map(throwable -> {
            this.attachmentMigrationAnalyticsService.buildAndSaveAnalyticEventsWhenStepFails(errorCode, throwable.getMessage(), migrationId, cloudId, step, spaceKey);
            return StepResult.failed(reason, throwable);
        }).orElseGet(() -> {
            this.attachmentMigrationAnalyticsService.buildAndSaveAnalyticEventsWhenStepFails(errorCode, reason, migrationId, cloudId, step, spaceKey);
            return StepResult.failed(reason);
        });
    }

    private static StepResult getStepResult(UploadState uploadState) {
        return StepResult.succeeded(AttachmentMigrationExecutor.getProgressMessage(uploadState));
    }

    private static String getProgressMessage(UploadState uploadState) {
        return String.format("Migrated %s of %s attachments", FileUtils.byteCountToDisplaySize((long)uploadState.uploadedBytes), FileUtils.byteCountToDisplaySize((long)uploadState.totalBytesToUpload));
    }

    private CloudSite validateAndUpdateMediaClientId(CloudSite cloudSite) {
        return this.ptx.write(() -> {
            String cloudId = cloudSite.getCloudId();
            MediaClientToken mediaToken = this.mediaClientTokenSupplier.getRefreshedToken(cloudId);
            String currentMediaClientId = mediaToken.getClientId();
            V4LogContext logContext = V4LogContext.builder().build();
            logContext.addAdditionalProperties(CLOUD_ID, cloudId, "currentMediaClientId", currentMediaClientId);
            if (currentMediaClientId.equals(cloudSite.getMediaClientId())) {
                this.v4Logger.logInfo(log, logContext, "MediaClientId is valid. Proceed with attachments migration");
                return cloudSite;
            }
            this.v4Logger.logInfo(log, logContext, "Current mediaClientId is not valid. Going to clean attachment migration records for the Cloud Site, which means that any previously uploaded attachments will be re-uploaded.");
            int deletedCount = this.attachmentService.deleteAttachmentMigrationTrackingByCloudSite(cloudSite);
            logContext.addAdditionalProperties("deletedCount", deletedCount);
            this.v4Logger.logInfo(log, logContext, "Deleted attachment migration records");
            return this.cloudSiteService.updateMediaClientId(cloudSite.getCloudId(), currentMediaClientId);
        });
    }

    @Override
    public StepType getStepType() {
        return StepType.ATTACHMENT_UPLOAD;
    }

    @Override
    public StepResult runStep(String stepId) {
        Step step = this.ptx.read(() -> this.stepStore.getStep(stepId));
        return this.wrapStepResultSupplier(this.attachmentMigrationAnalyticsService.getAnalyticsEventBuilder(), this.attachmentMigrationAnalyticsService.getAnalyticsEventService(), step, step.getConfig(), this.spaceManager, () -> this.doAttachmentMigration(step, step.getConfig(), Optional.empty()));
    }

    public StepResult runStepV4(Step step, PrcTask<AttachmentUploadTransferTask> prcTask) {
        return this.wrapStepResultSupplier(this.attachmentMigrationAnalyticsService.getAnalyticsEventBuilder(), this.attachmentMigrationAnalyticsService.getAnalyticsEventService(), step, step.getConfig(), this.spaceManager, () -> this.doAttachmentMigration(step, step.getConfig(), Optional.of(prcTask)));
    }

    private void cancelAttachmentMigrationConsumers(CompletableFuture[] consumers) {
        for (CompletableFuture consumer : consumers) {
            consumer.cancel(true);
        }
    }

    private Optional<Stream<Attachment>> getNonEmptyStream(Stream<Attachment> stream) {
        Iterator iterator = stream.iterator();
        if (iterator.hasNext()) {
            return Optional.of(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
        }
        return Optional.empty();
    }

    private void validateAndMarkInvalidUploadedAttachments(String spaceKey, CloudSite cloudSite, V4LogContext logContext, String migrationId) {
        List<Object> previouslyUploadedMediaIds = new ArrayList();
        long startTime = this.instantSupplier.get().toEpochMilli();
        try {
            this.v4Logger.logInfo(log, logContext, "Starting media validation for previously uploaded attachments");
            this.attachmentMigrationAnalyticsService.buildAndSaveValidateAttachmentsStartEvent(migrationId, cloudSite.getCloudId(), spaceKey);
            previouslyUploadedMediaIds = this.attachmentService.getPreviouslyUploadedMediaIds(spaceKey, cloudSite.getCloudId());
            if (previouslyUploadedMediaIds.isEmpty()) {
                this.v4Logger.logInfo(log, logContext, "No previously uploaded attachments found for validation");
                return;
            }
            this.v4Logger.logInfo(log, logContext, String.format("Validating %d previously uploaded media files", previouslyUploadedMediaIds.size()));
            Map<String, Boolean> validationResults = null;
            try {
                validationResults = this.mediaValidationService.validateMediaFiles(previouslyUploadedMediaIds, cloudSite);
            }
            catch (Exception e) {
                if (this.darkFeaturesManager.isMediaValidationErrorAsMissing()) {
                    this.v4Logger.logWarn(log, logContext, "Failed to validate previously migrated attachments, clearing migration tracking for all re-upload.", e);
                    this.attachmentService.clearMigrationTrackingForInvalidMediaFiles(previouslyUploadedMediaIds, cloudSite.getCloudId());
                    this.v4Logger.logInfo(log, logContext, "Cleared migration tracking for all media files");
                    this.attachmentMigrationAnalyticsService.buildAndSaveValidateAttachmentsEndEvent(false, this.instantSupplier.get().toEpochMilli() - startTime, migrationId, cloudSite.getCloudId(), spaceKey, previouslyUploadedMediaIds.size());
                    return;
                }
                throw e;
            }
            List<String> invalidMediaIds = validationResults.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
            if (!invalidMediaIds.isEmpty()) {
                this.v4Logger.logWarn(log, logContext, String.format("Found %d invalid media files out of %d validated. Clearing migration tracking for re-upload", invalidMediaIds.size(), previouslyUploadedMediaIds.size()));
                this.attachmentService.clearMigrationTrackingForInvalidMediaFiles(invalidMediaIds, cloudSite.getCloudId());
                logContext.addAdditionalProperties("invalidMediaFilesCount", invalidMediaIds.size());
                this.v4Logger.logInfo(log, logContext, "Cleared migration tracking for invalid media files");
            } else {
                this.v4Logger.logInfo(log, logContext, "All previously migrated media files are valid and available");
            }
            this.attachmentMigrationAnalyticsService.buildAndSaveValidateAttachmentsEndEvent(true, this.instantSupplier.get().toEpochMilli() - startTime, migrationId, cloudSite.getCloudId(), spaceKey, previouslyUploadedMediaIds.size());
        }
        catch (Exception e) {
            this.attachmentMigrationAnalyticsService.buildAndSaveValidateAttachmentsEndEvent(false, this.instantSupplier.get().toEpochMilli() - startTime, migrationId, cloudSite.getCloudId(), spaceKey, previouslyUploadedMediaIds.size());
            this.v4Logger.logWarn(log, logContext, "Failed to validate previously migrated attachments, proceeding with migration without media validation", e);
        }
    }

    private static /* synthetic */ CompletableFuture[] lambda$doAttachmentMigration$7(int x$0) {
        return new CompletableFuture[x$0];
    }

    private /* synthetic */ CompletableFuture lambda$doAttachmentMigration$6(AtomicBoolean failedToProduceOrConsumeAttachment, Map attachmentMigrationThrowableMap, V4LogContext logContext, AtomicBoolean mediaUploadFailed, CompletableFuture future) {
        return future.handle((result, throwable) -> {
            if (throwable != null) {
                failedToProduceOrConsumeAttachment.set(true);
                attachmentMigrationThrowableMap.put(PRODUCER_CONSUMER_THROWABLE, throwable);
                this.v4Logger.logError(log, logContext, "Attachment reader finished with exception", (Throwable)throwable);
                if (throwable.getCause() instanceof MediaUploadException) {
                    mediaUploadFailed.set(true);
                    attachmentMigrationThrowableMap.put(MEDIA_UPLOAD_THROWABLE, throwable);
                    this.v4Logger.logError(log, logContext, "Media Upload Failed with exception", (Throwable)throwable);
                }
            }
            return null;
        });
    }

    private static /* synthetic */ CompletableFuture lambda$doAttachmentMigration$4(ExecutorService executor, AttachmentsToMigrateConsumer consumer) {
        return CompletableFuture.runAsync(consumer, executor);
    }

    private /* synthetic */ AttachmentsToMigrateConsumer lambda$doAttachmentMigration$3(CloudSite cloudSite, BlockingQueue buffer, AttachmentsUploadTracker uploadTracker, AtomicBoolean allAttachmentsProduced, AtomicBoolean failedToProduceOrConsumeAttachment, String migrationId, int ignored) {
        return new AttachmentsToMigrateConsumer(cloudSite, buffer, this.attachmentMigrator, uploadTracker, allAttachmentsProduced::get, failedToProduceOrConsumeAttachment::get, migrationId, this.v4Logger);
    }

    private /* synthetic */ Object lambda$doAttachmentMigration$2(AtomicBoolean failedToProduceOrConsumeAttachment, Map attachmentMigrationThrowableMap, V4LogContext logContext, AtomicBoolean allAttachmentsProduced, Void result, Throwable throwable) {
        if (throwable != null) {
            failedToProduceOrConsumeAttachment.set(true);
            attachmentMigrationThrowableMap.put(PRODUCER_CONSUMER_THROWABLE, throwable);
            this.v4Logger.logError(log, logContext, "Attachment reader finished with exception", throwable);
        } else {
            allAttachmentsProduced.set(true);
            this.v4Logger.logInfo(log, logContext, "All attachments to migrate are read");
        }
        return null;
    }

    private /* synthetic */ void lambda$doAttachmentMigration$1(String stepId, Optional prcTask, UploadState uploadState) {
        this.updateProgress(stepId, uploadState, prcTask.isPresent() ? Optional.of((PrcTask)prcTask.get()) : Optional.empty());
    }
}

