/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.shadowExecutor;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.service.impl.StepSubType;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import java.util.Collections;
import java.util.Optional;

public class GlobalEntitiesShadowExecutor
extends ShadowMigrationExecutor {
    private final ProgressTracker progressTracker;

    public GlobalEntitiesShadowExecutor(StepStore stepStore, ProgressTracker progressTracker) {
        super(stepStore);
        this.progressTracker = progressTracker;
    }

    @Override
    public StepResult performShadowMigration(String stepId, PrcTask prcTask) {
        Step originalStep = this.getOriginalStep(prcTask, StepType.GLOBAL_ENTITIES_DATA_UPLOAD);
        this.sendProgressUpdate(stepId, prcTask);
        String originalStepResult = this.getOriginalStepResult(originalStep);
        this.sendCompletionStatus(prcTask, originalStepResult);
        return StepResult.succeeded("Global entities shadow upload completed successfully", originalStepResult);
    }

    private void sendProgressUpdate(String stepId, PrcTask prcTask) {
        this.progressTracker.progress(stepId, 100, StepSubType.GLOBAL_ENTITIES_UPLOAD.getDisplayName(), StepSubType.GLOBAL_ENTITIES_UPLOAD.getDetailedStatus(), Collections.emptyMap(), Optional.of(prcTask));
    }

    private String getOriginalStepResult(Step originalStep) {
        return originalStep.getProgress().getResult().orElse(null);
    }

    private void sendCompletionStatus(PrcTask prcTask, String originalStepResult) {
        this.progressTracker.sendV4GlobalEntitiesSuccessStatus(prcTask, originalStepResult, "Shadow Migration - Global entities upload completed successfully");
    }
}

