/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.media.impl;

import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.media.MediaFileUploaderFactory;
import com.atlassian.migration.agent.service.media.MediaValidationService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMediaValidationService
implements MediaValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMediaValidationService.class);
    private final MediaFileUploaderFactory mediaFileUploaderFactory;

    public DefaultMediaValidationService(MediaFileUploaderFactory mediaFileUploaderFactory) {
        this.mediaFileUploaderFactory = mediaFileUploaderFactory;
    }

    @Override
    public Map<String, Boolean> validateMediaFiles(List<String> mediaIds, CloudSite cloudSite) {
        if (mediaIds == null || mediaIds.isEmpty()) {
            return Collections.emptyMap();
        }
        log.debug("Validating {} media files", (Object)mediaIds.size());
        Map<String, Boolean> validationResults = this.mediaFileUploaderFactory.createMediaClient(cloudSite.getCloudId()).validateFiles(mediaIds);
        long availableCount = validationResults.values().stream().mapToLong(available -> available != false ? 1L : 0L).sum();
        log.info("Media validation results: {}/{} files are available", (Object)availableCount, (Object)mediaIds.size());
        return validationResults;
    }
}

