/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.model.ConfluenceShardResponse;
import com.atlassian.migration.agent.model.ProductEditionDetails;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.atlassian.migration.agent.v4.recipe.RecipeExecutionActionRequest;
import com.atlassian.migration.agent.v4.recipe.RecipeExecutionRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class MigrationPlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationPlatformService.class);
    private static final String GET_CONTAINER_TOKEN_VALIDITY_PATH = "/token/validation";
    private static final String CONFLUENCE = "confluence";
    private static final String SHARD = "shard";
    private static final String X_CONTAINER_TOKEN = "x-container-token";
    private static final String CREDENTIAL_USERNAME = "credential.username";
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;
    private final Gson gson = new Gson();

    public MigrationPlatformService(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        this(new HttpService(() -> MigrationPlatformService.buildHttpClient(userAgentInterceptor, okHttpProxyBuilder)), configuration);
    }

    @VisibleForTesting
    MigrationPlatformService(HttpService httpService, MigrationAgentConfiguration configuration) {
        this.httpService = httpService;
        this.configuration = configuration;
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout(60L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(60L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationServiceBaseUrl());
    }

    public Date getContainerTokenExpiry(String containerToken) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().path(GET_CONTAINER_TOKEN_VALIDITY_PATH).toUriString()).addHeader("Accept", "application/json").addHeader(CREDENTIAL_USERNAME, X_CONTAINER_TOKEN).get().build();
        return this.callJsonWithRetries(request, new TypeReference<ContainerTokenExpiryResponse>(){}).expiry;
    }

    public ConfluenceShardResponse getConfluenceShardDetails(String containerToken) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().pathSegment(new String[]{CONFLUENCE, SHARD}).toUriString()).addHeader("Accept", "application/json").addHeader(CREDENTIAL_USERNAME, X_CONTAINER_TOKEN).get().build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceShardResponse>(){});
    }

    public ProductEditionDetails fetchProductEditionDetails(String containerToken) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().path("/jira/producteditiondetails").toUriString()).addHeader("Accept", "application/json").addHeader(CREDENTIAL_USERNAME, X_CONTAINER_TOKEN).get().build();
        return this.callJsonWithRetries(request, new TypeReference<ProductEditionDetails>(){});
    }

    public void executeRecipe(String containerToken, String migrationId, String migrationScopeId, RecipeExecutionRequest recipeExecutionRequest) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().path("/lithium/confluence/{migrationId}/lio/recipes/{recipeName}/executions").buildAndExpand(new Object[]{migrationId, recipeExecutionRequest.getName()}).toUriString()).addHeader("Accept", "application/json").addHeader(CREDENTIAL_USERNAME, X_CONTAINER_TOKEN).addHeader("Cloud-Region", "").addHeader("MigrationScopeId", migrationScopeId).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.gson.toJson((Object)recipeExecutionRequest))).build();
        this.callJsonWithRetries(request);
    }

    public void stopRecipe(String containerToken, String migrationId, String migrationScopeId, RecipeExecutionActionRequest recipeExecutionActionRequest, String recipeName) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().path("/lithium/confluence/{migrationId}/lio/recipes/{recipeName}/executions/stop").buildAndExpand(new Object[]{migrationId, recipeName}).toUriString()).addHeader("Accept", "application/json").addHeader(CREDENTIAL_USERNAME, X_CONTAINER_TOKEN).addHeader("Cloud-Region", "").addHeader("MigrationScopeId", migrationScopeId).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.gson.toJson((Object)recipeExecutionActionRequest))).build();
        this.callJsonWithRetries(request);
    }

    public WorkplanConfigResponse getWorkplanConfig(String containerToken, String cloudId, String microsRegion, String migrationScopeId) {
        Request request = StargateHelper.requestBuilder(containerToken, this.configuration.isBypassStargate()).url(this.getUriBuilder().path("/workplan/confluence/config").toUriString()).addHeader("Accept", "application/json").addHeader(CREDENTIAL_USERNAME, X_CONTAINER_TOKEN).post(RequestBody.create((String)this.gson.toJson((Object)new ConfluenceWorkplanConfigRequest(cloudId, microsRegion, migrationScopeId)), (MediaType)MediaType.parse((String)"application/json"))).build();
        return this.callJsonWithRetries(request, new TypeReference<WorkplanConfigResponse>(){});
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        return (T)Failsafe.with(RetryPolicyBuilder.policyForMigrationServices(), (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callJson(request, bodyType));
    }

    private void callJsonWithRetries(Request request) {
        Failsafe.with(RetryPolicyBuilder.policyForMigrationServices(), (Policy[])new RetryPolicy[0]).get(() -> this.httpService.call(request));
    }

    static class ContainerTokenExpiryResponse {
        private Date expiry;

        @org.codehaus.jackson.annotate.JsonCreator
        @JsonCreator
        ContainerTokenExpiryResponse(@org.codehaus.jackson.annotate.JsonProperty(value="expiry") @JsonProperty(value="expiry") Date expiry) {
            this.expiry = expiry;
        }
    }

    static class ConfluenceWorkplanConfigRequest {
        private final String cloudId;
        private final String microsRegion;
        private final String migrationScopeId;

        @org.codehaus.jackson.annotate.JsonCreator
        @JsonCreator
        ConfluenceWorkplanConfigRequest(@org.codehaus.jackson.annotate.JsonProperty(value="cloudId") @JsonProperty(value="cloudId") String cloudId, @org.codehaus.jackson.annotate.JsonProperty(value="microsRegion") @JsonProperty(value="microsRegion") String microsRegion, @org.codehaus.jackson.annotate.JsonProperty(value="migrationScopeId") @JsonProperty(value="migrationScopeId") String migrationScopeId) {
            this.cloudId = cloudId;
            this.microsRegion = microsRegion;
            this.migrationScopeId = migrationScopeId;
        }
    }

    public static class WorkplanConfigResponse {
        @JsonProperty(value="workplanConfig")
        private Map<String, Object> workplanConfig;

        public Map<String, Object> getWorkplanConfig() {
            return this.workplanConfig;
        }
    }
}

