/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.impl.ConcurrencySettingsService;
import java.time.Clock;
import java.util.Optional;

@ParametersAreNonnullByDefault
public class ConcurrencySettingsAnalyticsService {
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final ConcurrencySettingsService concurrencySettingsService;
    private final Clock clock;

    public ConcurrencySettingsAnalyticsService(AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, ConcurrencySettingsService concurrencySettingsService) {
        this(analyticsEventService, analyticsEventBuilder, concurrencySettingsService, Clock.systemUTC());
    }

    public ConcurrencySettingsAnalyticsService(AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, ConcurrencySettingsService concurrencySettingsService, Clock clock) {
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.concurrencySettingsService = concurrencySettingsService;
        this.clock = clock;
    }

    public void buildStartEvent(Plan plan) {
        Optional<Plan> optionalPlan = Optional.of(plan);
        EventDto eventDto = this.analyticsEventBuilder.buildConcurrencySettingsStartEvent(plan, this.clock.instant().toEpochMilli(), this.concurrencySettingsService.getSettings(optionalPlan), this.concurrencySettingsService.getConcurrencyParameters(optionalPlan));
        this.analyticsEventService.saveAnalyticsEventAsync(() -> eventDto);
    }
}

