/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.service.impl.ConcurrencyLimitItem;

public class ConcurrencyFormulaEngine {
    private ConcurrencyFormulaEngine() {
    }

    public static int calculateAttachmentConcurrencyNodeMax(int cpu, int nodes, ConcurrencyLimitItem limits, boolean attachmentOnlyMigration, boolean skipAttachmentUploadEnabled) {
        if (attachmentOnlyMigration) {
            return ConcurrencyFormulaEngine.getValueWithinLimits(nodes, limits);
        }
        if (skipAttachmentUploadEnabled) {
            return 5;
        }
        return ConcurrencyFormulaEngine.getValueWithinLimits((double)cpu / 2.0 * 1.25, limits);
    }

    public static int calculateAttachmentConcurrencyClusterMax(int cpu, int nodes, ConcurrencyLimitItem limits, boolean attachmentOnlyMigration, boolean skipAttachmentUploadEnabled) {
        if (attachmentOnlyMigration) {
            return ConcurrencyFormulaEngine.getValueWithinLimits(nodes * 2, limits);
        }
        if (skipAttachmentUploadEnabled) {
            return 1;
        }
        return ConcurrencyFormulaEngine.getValueWithinLimits((double)(cpu * nodes) / 2.0 * 1.25, limits);
    }

    public static int calculateAttachmentUploadConcurrency(boolean skipUploadEnabled) {
        return skipUploadEnabled ? 5 : 20;
    }

    public static int calculateImportConcurrencyNodeMax(int cpu, ConcurrencyLimitItem limits) {
        return ConcurrencyFormulaEngine.getValueWithinLimits(cpu / 2, limits);
    }

    public static int calculateImportConcurrencyClusterMax(int cpu, int nodes, ConcurrencyLimitItem limits) {
        return ConcurrencyFormulaEngine.getValueWithinLimits(cpu * nodes / 2, limits);
    }

    public static int calculateExportConcurrencyNodeMax(int cpu, ConcurrencyLimitItem limits) {
        return ConcurrencyFormulaEngine.getValueWithinLimits(cpu / 2, limits);
    }

    public static int calculateExportConcurrencyClusterMax(int cpu, int nodes, ConcurrencyLimitItem limits) {
        return ConcurrencyFormulaEngine.getValueWithinLimits(cpu * nodes / 2, limits);
    }

    public static int calculateUploadConcurrencyNodeMax(int cpu, ConcurrencyLimitItem limits) {
        return ConcurrencyFormulaEngine.getValueWithinLimits(cpu / 4, limits);
    }

    public static int calculateUploadConcurrencyClusterMax(boolean v4Enabled, int cpu, int nodes, ConcurrencyLimitItem limits) {
        return ConcurrencyFormulaEngine.getValueWithinLimits(v4Enabled ? (double)(cpu * nodes) / 5.5 : (double)cpu / 4.0, limits);
    }

    public static int calculateSpaceUsersConcurrencyNodeMax(int cpu, ConcurrencyLimitItem limits) {
        return ConcurrencyFormulaEngine.getValueWithinLimits(cpu / 4, limits);
    }

    public static int calculateSpaceUsersConcurrencyMax(int cpu, int nodes, ConcurrencyLimitItem limits) {
        return ConcurrencyFormulaEngine.getValueWithinLimits(cpu * nodes / 4, limits);
    }

    private static int getValueWithinLimits(Number value, ConcurrencyLimitItem limits) {
        return Math.min(limits.getMaximumLimit(), Math.max(value.intValue(), limits.getMinimumLimit()));
    }
}

