/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.remote;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.agent.service.guardrails.remote.AssessmentCompletedEvent;
import com.atlassian.migration.agent.service.guardrails.remote.CloudJobType;
import com.atlassian.migration.agent.service.guardrails.remote.InstanceAssessmentUploadService;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceNotAvailableException;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AssessmentEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssessmentEventHandler.class);
    private final InstanceAssessmentUploadService instanceAssessmentUploadService;
    private final EventPublisher eventPublisher;

    @PostConstruct
    @jakarta.annotation.PostConstruct
    void init() {
        this.eventPublisher.register((Object)this);
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    void cleanup() {
        this.eventPublisher.unregister((Object)this);
    }

    public AssessmentEventHandler(InstanceAssessmentUploadService instanceAssessmentUploadService, EventPublisher eventPublisher) {
        this.instanceAssessmentUploadService = instanceAssessmentUploadService;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void onAssessmentCompletionEvent(AssessmentCompletedEvent event) {
        log.info("Received AssessmentCompletedEvent with status: {}", (Object)event.getStatus());
        try {
            if (this.instanceAssessmentUploadService.isConnected()) {
                log.info("Connected to cloud via Companion. Processing assessment.");
                if (event.getStatus() == AssessmentCompletedEvent.AssessmentEventStatus.COMPLETED) {
                    log.info("Assessment completed. Starting to generate and upload assessment ZIP.");
                    this.instanceAssessmentUploadService.generateAndUploadAssessmentZip();
                    log.info("Successfully generated and uploaded assessment ZIP.");
                } else if (event.getStatus() == AssessmentCompletedEvent.AssessmentEventStatus.CANCELLED) {
                    log.warn("Assessment cancelled. Initiating cancel handling in cloud.");
                    this.instanceAssessmentUploadService.cancelInCloud(CloudJobType.ASSESSMENT);
                    log.info("Successfully handled cancel in cloud.");
                }
            } else {
                log.info("Not connected to Org. Skipping assessment processing.");
            }
        }
        catch (IOException e) {
            log.error("IOException occurred during assessment processing: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to process assessment due to IO error.", e);
        }
        catch (CloudRequestServiceNotAvailableException e) {
            log.error("CloudRequestServiceNotAvailableException occurred during assessment processing: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to process assessment due to cloud service unavailability.", e);
        }
    }
}

