/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro.nbm.manager;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.guardrails.macro.nbm.model.NestedBodyMacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.util.SerializationUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;

public class NestedBodyMacroAssessmentStore {
    private static final int MAX_DOWNLOAD_DAYS = 7;
    public static final String ASSESSMENT_FILE_NAME = "nbm-assessment-store-%s.jsonl";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final BootstrapManager bootstrapManager;
    private final MigrationDarkFeaturesManager features;

    public void store(List<NestedBodyMacroAssessmentResult> assessment, LocalDate date) throws IOException {
        Path jsonPathFile = this.getNestedBodyMacroAssessmentPath(date);
        SerializationUtil.saveJsonL(jsonPathFile.toFile(), assessment);
    }

    public List<NestedBodyMacroAssessmentResult> getNestedBodyMacroAssessmentResult(LocalDate today) {
        File macroAssessmentStoreFile = this.getExistingNestedBodyMacroAssessmentPath(today);
        if (macroAssessmentStoreFile == null) {
            return null;
        }
        return SerializationUtil.deserializeJsonL(macroAssessmentStoreFile, NestedBodyMacroAssessmentResult.class);
    }

    private File getExistingNestedBodyMacroAssessmentPath(LocalDate today) {
        if (this.features.isNestedBodyMacrosAssessmentEnabled()) {
            for (int i = 0; i <= 7; ++i) {
                File file = this.getNestedBodyMacroAssessmentPath(today.minusDays(i)).toFile();
                if (!file.exists()) continue;
                return file;
            }
        }
        return null;
    }

    private Path getNestedBodyMacroAssessmentPath(LocalDate date) {
        String assessmentFileName = String.format(ASSESSMENT_FILE_NAME, DATE_FORMATTER.format(date));
        return Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), assessmentFileName);
    }

    @Generated
    public NestedBodyMacroAssessmentStore(BootstrapManager bootstrapManager, MigrationDarkFeaturesManager features) {
        this.bootstrapManager = bootstrapManager;
        this.features = features;
    }
}

