/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.json.JsonSerializingException;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.guardrails.QueryConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown=true)
public class InstanceAssessmentConfig {
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private String type;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private boolean collectBrowserMetrics;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private boolean collectUsageMetrics;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private boolean executeMacroAssessment;
    @org.codehaus.jackson.annotate.JsonProperty
    @JsonProperty
    private QueryConfig queryConfig;

    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public boolean isLongRunning() {
        return this.collectBrowserMetrics || this.collectUsageMetrics;
    }

    public InstanceAssessmentConfig(boolean collectBrowserMetrics, boolean collectUsageMetrics, boolean executeMacroAssessment) {
        this.collectBrowserMetrics = collectBrowserMetrics;
        this.collectUsageMetrics = collectUsageMetrics;
        this.executeMacroAssessment = executeMacroAssessment;
        this.queryConfig = QueryConfig.defaultConfig();
        this.type = "confluence";
    }

    public static Optional<InstanceAssessmentConfig> deserialize(@Nullable @jakarta.annotation.Nullable String configJson) {
        try {
            return Optional.ofNullable(configJson).map(json -> Jsons.readValue(json, InstanceAssessmentConfig.class));
        }
        catch (JsonSerializingException e) {
            return Optional.empty();
        }
    }

    public static InstanceAssessmentConfig full() {
        return InstanceAssessmentConfig.builder().collectBrowserMetrics(true).collectUsageMetrics(true).executeMacroAssessment(true).queryConfig(QueryConfig.defaultConfig()).build();
    }

    public static InstanceAssessmentConfig quick() {
        return InstanceAssessmentConfig.builder().collectBrowserMetrics(false).collectUsageMetrics(false).executeMacroAssessment(true).queryConfig(QueryConfig.defaultConfig()).build();
    }

    @Generated
    private static String $default$type() {
        return "confluence";
    }

    @Generated
    private static boolean $default$collectBrowserMetrics() {
        return true;
    }

    @Generated
    private static boolean $default$collectUsageMetrics() {
        return true;
    }

    @Generated
    private static boolean $default$executeMacroAssessment() {
        return true;
    }

    @Generated
    private static QueryConfig $default$queryConfig() {
        return QueryConfig.defaultConfig();
    }

    @Generated
    public static InstanceAssessmentConfigBuilder builder() {
        return new InstanceAssessmentConfigBuilder();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public boolean isCollectBrowserMetrics() {
        return this.collectBrowserMetrics;
    }

    @Generated
    public boolean isCollectUsageMetrics() {
        return this.collectUsageMetrics;
    }

    @Generated
    public boolean isExecuteMacroAssessment() {
        return this.executeMacroAssessment;
    }

    @Generated
    public QueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    @JsonProperty
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty
    @Generated
    public void setCollectBrowserMetrics(boolean collectBrowserMetrics) {
        this.collectBrowserMetrics = collectBrowserMetrics;
    }

    @JsonProperty
    @Generated
    public void setCollectUsageMetrics(boolean collectUsageMetrics) {
        this.collectUsageMetrics = collectUsageMetrics;
    }

    @JsonProperty
    @Generated
    public void setExecuteMacroAssessment(boolean executeMacroAssessment) {
        this.executeMacroAssessment = executeMacroAssessment;
    }

    @JsonProperty
    @Generated
    public void setQueryConfig(QueryConfig queryConfig) {
        this.queryConfig = queryConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceAssessmentConfig)) {
            return false;
        }
        InstanceAssessmentConfig other = (InstanceAssessmentConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCollectBrowserMetrics() != other.isCollectBrowserMetrics()) {
            return false;
        }
        if (this.isCollectUsageMetrics() != other.isCollectUsageMetrics()) {
            return false;
        }
        if (this.isExecuteMacroAssessment() != other.isExecuteMacroAssessment()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        QueryConfig this$queryConfig = this.getQueryConfig();
        QueryConfig other$queryConfig = other.getQueryConfig();
        return !(this$queryConfig == null ? other$queryConfig != null : !((Object)this$queryConfig).equals(other$queryConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InstanceAssessmentConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCollectBrowserMetrics() ? 79 : 97);
        result = result * 59 + (this.isCollectUsageMetrics() ? 79 : 97);
        result = result * 59 + (this.isExecuteMacroAssessment() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        QueryConfig $queryConfig = this.getQueryConfig();
        result = result * 59 + ($queryConfig == null ? 43 : ((Object)$queryConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InstanceAssessmentConfig(type=" + this.getType() + ", collectBrowserMetrics=" + this.isCollectBrowserMetrics() + ", collectUsageMetrics=" + this.isCollectUsageMetrics() + ", executeMacroAssessment=" + this.isExecuteMacroAssessment() + ", queryConfig=" + this.getQueryConfig() + ")";
    }

    @Generated
    protected InstanceAssessmentConfig() {
        this.type = InstanceAssessmentConfig.$default$type();
        this.collectBrowserMetrics = InstanceAssessmentConfig.$default$collectBrowserMetrics();
        this.collectUsageMetrics = InstanceAssessmentConfig.$default$collectUsageMetrics();
        this.executeMacroAssessment = InstanceAssessmentConfig.$default$executeMacroAssessment();
        this.queryConfig = InstanceAssessmentConfig.$default$queryConfig();
    }

    @Generated
    private InstanceAssessmentConfig(String type, boolean collectBrowserMetrics, boolean collectUsageMetrics, boolean executeMacroAssessment, QueryConfig queryConfig) {
        this.type = type;
        this.collectBrowserMetrics = collectBrowserMetrics;
        this.collectUsageMetrics = collectUsageMetrics;
        this.executeMacroAssessment = executeMacroAssessment;
        this.queryConfig = queryConfig;
    }

    @Generated
    public static class InstanceAssessmentConfigBuilder {
        @Generated
        private boolean type$set;
        @Generated
        private String type$value;
        @Generated
        private boolean collectBrowserMetrics$set;
        @Generated
        private boolean collectBrowserMetrics$value;
        @Generated
        private boolean collectUsageMetrics$set;
        @Generated
        private boolean collectUsageMetrics$value;
        @Generated
        private boolean executeMacroAssessment$set;
        @Generated
        private boolean executeMacroAssessment$value;
        @Generated
        private boolean queryConfig$set;
        @Generated
        private QueryConfig queryConfig$value;

        @Generated
        InstanceAssessmentConfigBuilder() {
        }

        @JsonProperty
        @Generated
        public InstanceAssessmentConfigBuilder type(String type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @JsonProperty
        @Generated
        public InstanceAssessmentConfigBuilder collectBrowserMetrics(boolean collectBrowserMetrics) {
            this.collectBrowserMetrics$value = collectBrowserMetrics;
            this.collectBrowserMetrics$set = true;
            return this;
        }

        @JsonProperty
        @Generated
        public InstanceAssessmentConfigBuilder collectUsageMetrics(boolean collectUsageMetrics) {
            this.collectUsageMetrics$value = collectUsageMetrics;
            this.collectUsageMetrics$set = true;
            return this;
        }

        @JsonProperty
        @Generated
        public InstanceAssessmentConfigBuilder executeMacroAssessment(boolean executeMacroAssessment) {
            this.executeMacroAssessment$value = executeMacroAssessment;
            this.executeMacroAssessment$set = true;
            return this;
        }

        @JsonProperty
        @Generated
        public InstanceAssessmentConfigBuilder queryConfig(QueryConfig queryConfig) {
            this.queryConfig$value = queryConfig;
            this.queryConfig$set = true;
            return this;
        }

        @Generated
        public InstanceAssessmentConfig build() {
            String type$value = this.type$value;
            if (!this.type$set) {
                type$value = InstanceAssessmentConfig.$default$type();
            }
            boolean collectBrowserMetrics$value = this.collectBrowserMetrics$value;
            if (!this.collectBrowserMetrics$set) {
                collectBrowserMetrics$value = InstanceAssessmentConfig.$default$collectBrowserMetrics();
            }
            boolean collectUsageMetrics$value = this.collectUsageMetrics$value;
            if (!this.collectUsageMetrics$set) {
                collectUsageMetrics$value = InstanceAssessmentConfig.$default$collectUsageMetrics();
            }
            boolean executeMacroAssessment$value = this.executeMacroAssessment$value;
            if (!this.executeMacroAssessment$set) {
                executeMacroAssessment$value = InstanceAssessmentConfig.$default$executeMacroAssessment();
            }
            QueryConfig queryConfig$value = this.queryConfig$value;
            if (!this.queryConfig$set) {
                queryConfig$value = InstanceAssessmentConfig.$default$queryConfig();
            }
            return new InstanceAssessmentConfig(type$value, collectBrowserMetrics$value, collectUsageMetrics$value, executeMacroAssessment$value, queryConfig$value);
        }

        @Generated
        public String toString() {
            return "InstanceAssessmentConfig.InstanceAssessmentConfigBuilder(type$value=" + this.type$value + ", collectBrowserMetrics$value=" + this.collectBrowserMetrics$value + ", collectUsageMetrics$value=" + this.collectUsageMetrics$value + ", executeMacroAssessment$value=" + this.executeMacroAssessment$value + ", queryConfig$value=" + this.queryConfig$value + ")";
        }
    }
}

