/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.guardrails.AssessmentOutputFileGenerator;
import com.atlassian.migration.agent.service.guardrails.GuardrailsCsvOutputStreamResult;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.InstanceMetadataCollector;
import com.atlassian.migration.agent.service.guardrails.remote.InstanceAssessmentConfigClient;
import com.atlassian.migration.agent.service.guardrails.util.ZipBuilder;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.util.AbstractMap;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

public class InstanceAssessmentCSVService {
    private static final Logger log = ContextLoggerFactory.getLogger(InstanceAssessmentCSVService.class);
    static final String ZIP_COMMENT = "atlassian-onprem-instance-assessment";
    private final BootstrapManager bootstrapManager;
    private final InstanceMetadataCollector instanceMetadataCollector;
    private final GuardrailsResponseGroupStore guardrailsResponseGroupStore;
    private final Set<AssessmentOutputFileGenerator> assessmentOutputFileGenerators;
    private final InstanceAssessmentConfigClient instanceAssessmentConfigClient;
    private final PluginTransactionTemplate ptx;

    public InstanceAssessmentCSVService(BootstrapManager bootstrapManager, InstanceMetadataCollector instanceMetadataCollector, GuardrailsResponseGroupStore guardrailsResponseGroupStore, Set<AssessmentOutputFileGenerator> assessmentOutputFileGenerators, InstanceAssessmentConfigClient instanceAssessmentConfigClient, PluginTransactionTemplate ptx) {
        this.bootstrapManager = bootstrapManager;
        this.instanceMetadataCollector = instanceMetadataCollector;
        this.guardrailsResponseGroupStore = guardrailsResponseGroupStore;
        this.assessmentOutputFileGenerators = assessmentOutputFileGenerators;
        this.instanceAssessmentConfigClient = instanceAssessmentConfigClient;
        this.ptx = ptx;
    }

    public GuardrailsCsvOutputStreamResult generateExample(LocalDate today, String date, OutputStream outputStream) {
        try {
            return this.generateInternal(today, date, this.instanceMetadataCollector.collectMetadata(Instant.now()), outputStream, true, this.instanceAssessmentConfigClient.resolveConfig());
        }
        catch (Exception e) {
            return GuardrailsCsvOutputStreamResult.failed(outputStream, false, new RuntimeException("Unable to generate file for download: " + e.getMessage(), e));
        }
    }

    public GuardrailsCsvOutputStreamResult generate(LocalDate today, String date, OutputStream outputStream) {
        Optional guardrailsResponseGroup = this.ptx.read(this.guardrailsResponseGroupStore::findLast);
        log.info("Guardrails are present: {}", (Object)guardrailsResponseGroup.isPresent());
        if (!guardrailsResponseGroup.isPresent()) {
            return GuardrailsCsvOutputStreamResult.failed(outputStream, false, new IllegalStateException("Unable to generate file for download: guardrails response group not found"));
        }
        try {
            GuardrailsResponseGroup guardrailsResponseGroupValue = (GuardrailsResponseGroup)guardrailsResponseGroup.get();
            InstanceAssessmentConfig config = this.instanceAssessmentConfigClient.resolveConfig(InstanceAssessmentConfig.deserialize(guardrailsResponseGroupValue.getConfigJson()).orElse(null));
            InstanceMetadataDto instanceMetadataDto = this.instanceMetadataCollector.collectMetadata(Instant.ofEpochMilli(guardrailsResponseGroupValue.getStartTimestamp()));
            return this.generateInternal(today, date, instanceMetadataDto, outputStream, false, config);
        }
        catch (Exception e) {
            guardrailsResponseGroup.ifPresent(responseGroup -> log.error("Unable to generate file for download: {} - {} - {}", new Object[]{responseGroup.getJobId(), e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)}));
            return GuardrailsCsvOutputStreamResult.failed(outputStream, false, new RuntimeException("Unable to generate file for download: " + e.getMessage(), e));
        }
    }

    private GuardrailsCsvOutputStreamResult generateInternal(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto, OutputStream outputStream, boolean example, InstanceAssessmentConfig config) throws IOException {
        ZipBuilder zipBuilder = this.createZipBuilder(outputStream);
        this.assessmentOutputFileGenerators.stream().filter(generator -> generator.shouldInclude(config)).flatMap(generator -> generator.generate(today, date, instanceMetadataDto, example).stream().map(path -> new AbstractMap.SimpleEntry<Path, Optional<Path>>((Path)path, generator.getBasePath()))).forEach(pair -> {
            Path path = (Path)pair.getKey();
            Optional maybeBasePath = (Optional)pair.getValue();
            if (maybeBasePath.isPresent()) {
                Path basePath = (Path)maybeBasePath.get();
                Path relativizedPath = basePath.relativize(path);
                Path parent = relativizedPath.getParent();
                zipBuilder.add(path, parent == null ? null : parent.toString());
            } else {
                zipBuilder.add(path);
            }
        });
        zipBuilder.create(true);
        return GuardrailsCsvOutputStreamResult.succeeded(outputStream);
    }

    public ZipBuilder createZipBuilder(OutputStream outputStream) {
        return new ZipBuilder(outputStream, ZIP_COMMENT, this.getPath());
    }

    public Path getPath() {
        return Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), "guardrails");
    }
}

