/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.analytics.events.CounterMetricEvent;
import com.atlassian.cmpt.analytics.events.TimerMetricEvent;
import com.atlassian.cmpt.check.base.CheckContext;
import com.atlassian.cmpt.check.base.CheckExecutor;
import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.check.email.EmailFormatChecker;
import com.atlassian.cmpt.check.mapper.ExecutionErrorCodes;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.CheckExecutionStatus;
import com.atlassian.migration.agent.entity.CheckResultEntity;
import com.atlassian.migration.agent.entity.MigrationStatus;
import com.atlassian.migration.agent.entity.TransferStatus;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.FeatureFlagService;
import com.atlassian.migration.agent.service.MigrationMetric;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventParams;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.FeatureFlagActionSubject;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.catalogue.TransferStatusesUpdateRequest;
import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistry;
import com.atlassian.migration.agent.service.check.CheckResultsService;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.ContextProviderUtil;
import com.atlassian.migration.agent.service.check.PreflightLogContext;
import com.atlassian.migration.agent.service.check.PreflightLogger;
import com.atlassian.migration.agent.service.check.UnsupportedUserHandler;
import com.atlassian.migration.agent.service.check.email.DuplicateEmailCheckContext;
import com.atlassian.migration.agent.service.check.email.InvalidEmailCheckContext;
import com.atlassian.migration.agent.service.email.InvalidEmailUserService;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class AsyncCheckExecutor
implements CheckExecutor,
JobRunner {
    private static final Logger log = ContextLoggerFactory.getLogger(AsyncCheckExecutor.class);
    private static final String EXECUTION_ID_KEY = "checkExecutionId";
    private static final String CHECK_TYPE_KEY = "checkType";
    private static final String INPUT_PARAMETER_PREFIX = "inputParameter-";
    private static final String UNIQUE_ID_KEY = "uniqueId";
    private static final String PREFLIGHT_ID = "preflightId";
    private static final String CONTAINER_ID = "containerId";
    private static final String TRANSFER_ID = "transferId";
    private static final String CLOUD_ID = "cloudId";
    private static final String SUCCESS = "Success";
    private static final String FAILED = "Failed";
    private static final String EXECUTION_FAILED = "ExecutionFailed";
    private static final Set<CheckType> INVALID_EMAILS_CHECK_TYPES = ImmutableSet.of((Object)CheckType.INVALID_EMAILS);
    private static final Set<CheckType> DUPLICATE_EMAILS_CHECK_TYPES = ImmutableSet.of((Object)CheckType.SHARED_EMAILS);
    private static final String CHECK_EXECUTION_ID_KEY = "checkExecutionId";
    private final SchedulerService schedulerService;
    private final CheckResultsService checkResultService;
    private final CheckRegistry checkerRegistry;
    private final PluginTransactionTemplate ptx;
    private final AnalyticsEventService analyticsEventService;
    private final FeatureFlagService featureFlagService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final InvalidEmailUserService invalidEmailUserService;
    private final UnsupportedUserHandler unsupportedUserHandler;
    private final PreflightLogger preflightLogger;
    private final PlatformService platformService;
    private final MigrationLogService migrationLogService;

    public AsyncCheckExecutor(SchedulerService schedulerService, CheckResultsService checkResultService, CheckRegistry checkerRegistry, PluginTransactionTemplate ptx, AnalyticsEventService analyticsEventService, MigrationDarkFeaturesManager migrationDarkFeaturesManager, InvalidEmailUserService invalidEmailUserService, FeatureFlagService featureFlagService, UnsupportedUserHandler unsupportedUserHandler, PreflightLogger preflightLogger, PlatformService platformService, MigrationLogService migrationLogService) {
        this.schedulerService = schedulerService;
        this.checkResultService = checkResultService;
        this.checkerRegistry = checkerRegistry;
        this.ptx = ptx;
        this.analyticsEventService = analyticsEventService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.invalidEmailUserService = invalidEmailUserService;
        this.unsupportedUserHandler = unsupportedUserHandler;
        this.featureFlagService = featureFlagService;
        this.preflightLogger = preflightLogger;
        this.platformService = platformService;
        this.migrationLogService = migrationLogService;
    }

    private static String getExecutionIdFromJobParams(Map<String, Serializable> params) {
        return (String)((Object)params.get("checkExecutionId"));
    }

    private static CheckType getCheckTypeFromJobParams(Map<String, Serializable> params) {
        return CheckType.fromString((String)((Object)params.get(CHECK_TYPE_KEY)));
    }

    private static Optional<UUID> getUniqueIdFromJobParams(Map<String, Serializable> params) {
        return Optional.ofNullable((String)((Object)params.get("inputParameter-uniqueId"))).map(UUID::fromString);
    }

    private static String getStringValueFromJobParams(Map<String, Serializable> params, String key) {
        String inputKey = INPUT_PARAMETER_PREFIX + key;
        return params.containsKey(inputKey) ? (String)((Object)params.get(inputKey)) : null;
    }

    private static Map<String, Object> getInputParamsFromJobParams(Map<String, Serializable> params) {
        Map<String, Object> inputParams = params.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(INPUT_PARAMETER_PREFIX)).collect(Collectors.toMap(entry -> StringUtils.substringAfter((String)((String)entry.getKey()), (String)INPUT_PARAMETER_PREFIX), Map.Entry::getValue));
        if (params.containsKey("checkExecutionId")) {
            inputParams.put("checkExecutionId", params.get("checkExecutionId"));
        }
        if (params.containsKey(CHECK_TYPE_KEY)) {
            inputParams.put(CHECK_TYPE_KEY, params.get(CHECK_TYPE_KEY));
        }
        return inputParams;
    }

    private static Map<String, Serializable> generateJobParameters(String executionId, CheckType checkType, @Nullable Map<String, Object> inputParameters) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("checkExecutionId", (Serializable)((Object)executionId));
        params.put(CHECK_TYPE_KEY, (Serializable)((Object)checkType.value()));
        if (inputParameters != null) {
            inputParameters.forEach((key, value) -> params.put(INPUT_PARAMETER_PREFIX + key, (Serializable)value));
        }
        return params;
    }

    @PostConstruct
    @jakarta.annotation.PostConstruct
    public void postConstruct() {
        CheckType.getStaticCheckTypes().forEach(checkType -> this.schedulerService.registerJobRunner(JobRunnerKey.of((String)this.jobKey((CheckType)checkType)), (JobRunner)this));
    }

    @javax.annotation.PreDestroy
    @PreDestroy
    public void cleanup() {
        CheckType.getStaticCheckTypes().forEach(checkType -> this.schedulerService.unregisterJobRunner(JobRunnerKey.of((String)this.jobKey((CheckType)checkType))));
    }

    public Optional<com.atlassian.cmpt.check.base.CheckExecutionStatus> getStatus(String executionId) {
        List<CheckResultEntity> results = this.checkResultService.getByExecutionId(executionId);
        if (CollectionUtils.isEmpty(results)) {
            return Optional.empty();
        }
        List statuses = results.stream().map(this::convertToCheckStatus).collect(Collectors.toList());
        return Optional.of(new com.atlassian.cmpt.check.base.CheckExecutionStatus(executionId, statuses));
    }

    public List<CheckStatus> getStatusByUniqueId(@Nullable String uniqueId) {
        if (StringUtils.isEmpty((CharSequence)uniqueId)) {
            return Collections.emptyList();
        }
        List<CheckResultEntity> results = this.checkResultService.getByUniqueId(uniqueId);
        return results.stream().map(this::convertToCheckStatus).collect(Collectors.toList());
    }

    public Optional<com.atlassian.cmpt.check.base.CheckExecutionStatus> getStatus(String executionId, CheckType checkType) {
        Optional<CheckResultEntity> checkResult = this.checkResultService.getByExecutionIdAndCheckType(executionId, checkType);
        return checkResult.map(checkResultEntity -> new com.atlassian.cmpt.check.base.CheckExecutionStatus(executionId, (List)ImmutableList.of((Object)this.convertToCheckStatus((CheckResultEntity)checkResultEntity))));
    }

    public void executeChecks(String executionId, List<CheckRequest> checkRequests) {
        List<String> enabledMigrationFeatures = this.featureFlagService.getAllEnabledMigrationFeatures();
        this.featureFlagService.saveFeatureFlagAnalyticEvent(FeatureFlagActionSubject.PREFLIGHT, executionId, enabledMigrationFeatures.toString());
        log.info("Enabled Migration plugin feature flags for executionId {} are {}", (Object)executionId, enabledMigrationFeatures);
        checkRequests.forEach(checkRequest -> this.scheduleCheck(executionId, (CheckRequest)checkRequest));
    }

    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        Map jobParams = jobRunnerRequest.getJobConfig().getParameters();
        String executionId = AsyncCheckExecutor.getExecutionIdFromJobParams(jobParams);
        CheckType checkType = AsyncCheckExecutor.getCheckTypeFromJobParams(jobParams);
        AnalyticsEventParams.AnalyticsEventParamsBuilder builder = AnalyticsEventParams.builder().startTime(Instant.now()).executionId(executionId).resultState(EXECUTION_FAILED).uniqueId(AsyncCheckExecutor.getUniqueIdFromJobParams(jobParams).orElse(null));
        try {
            this.updateTransferStatus(jobParams, TransferStatus.IN_PROGRESS, TransferStatus.IN_PROGRESS, null, null);
            CheckResult checkResult = this.executeChecker(jobParams, executionId);
            Optional<Integer> errorCodes = Optional.ofNullable(Checker.retrieveExecutionErrorCode((CheckResult)checkResult));
            AnalyticsEventParams eventParams = builder.checkResult(checkResult).resultState(errorCodes.map(error -> FAILED).orElse(checkResult.success ? SUCCESS : FAILED)).build();
            this.saveAnalyticsEventAfterCheckWasExecuted(checkType, eventParams);
            PreflightLogContext context = PreflightLogContext.builder().checkType(checkType.value()).isSuccess(checkResult.success).checkExecutionId(executionId).build();
            context.addAdditionalProperties("totalExecutionTimeMillis", eventParams.getTotalTime());
            this.preflightLogger.logInfo(log, context, "Finished Execution");
            boolean isPassed = checkResult.success || !checkType.blocksMigration();
            boolean isWarning = !checkResult.success && !checkType.blocksMigration();
            this.updateTransferStatus(jobParams, TransferStatus.SUCCESS, isPassed ? TransferStatus.SUCCESS : TransferStatus.FAILED, isWarning ? CheckExecutionStatus.WARNING.name() : null, null);
            return JobRunnerResponse.success((String)"ok");
        }
        catch (Exception e) {
            CheckResult failedCheckResult = Checker.buildCheckResultWithExecutionError((int)ExecutionErrorCodes.GENERIC.getErrorCode());
            this.checkResultService.saveCheckResult(executionId, checkType, failedCheckResult);
            AnalyticsEventParams eventParams = builder.checkResult(failedCheckResult).resultState(EXECUTION_FAILED).build();
            this.saveAnalyticsEventAfterCheckWasExecuted(checkType, eventParams);
            PreflightLogContext context = PreflightLogContext.builder().checkType(checkType.value()).isSuccess(false).checkExecutionId(executionId).build();
            context.addAdditionalProperties("totalExecutionTimeMillis", eventParams.getTotalTime());
            this.preflightLogger.logError(log, context, "Couldn't execute check", e);
            this.updateTransferStatus(jobParams, TransferStatus.FAILED, TransferStatus.FAILED, Status.EXECUTION_ERROR.value(), e.getMessage());
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    void updateTransferStatus(Map<String, Serializable> jobParams, TransferStatus executionStatus, TransferStatus businessStatus, @Nullable String customBusinessStatus, @Nullable String statusMessage) {
        if (!this.migrationDarkFeaturesManager.enableMcsPreflightMigration()) {
            return;
        }
        String cloudId = AsyncCheckExecutor.getStringValueFromJobParams(jobParams, CLOUD_ID);
        String preflightId = AsyncCheckExecutor.getStringValueFromJobParams(jobParams, PREFLIGHT_ID);
        String containerId = AsyncCheckExecutor.getStringValueFromJobParams(jobParams, CONTAINER_ID);
        String transferId = AsyncCheckExecutor.getStringValueFromJobParams(jobParams, TRANSFER_ID);
        if (cloudId == null || preflightId == null || containerId == null || transferId == null) {
            log.warn("Unable to update transfer status. Missing required parameters: cloudId={}, preflightId={}, containerId={}, transferId={}", new Object[]{cloudId, preflightId, containerId, transferId});
            return;
        }
        this.platformService.updateTransferStatus(cloudId, preflightId, transferId, new TransferStatusesUpdateRequest(executionStatus, businessStatus, customBusinessStatus, statusMessage));
        this.checkAndUpdateOverallPreflightStatus(jobParams, businessStatus, cloudId, preflightId, containerId);
    }

    void checkAndUpdateOverallPreflightStatus(Map<String, Serializable> jobParams, TransferStatus transferStatus, String cloudId, String preflightId, String containerId) {
        List<CheckStatus> statuses;
        if (transferStatus.isTerminal() && AsyncCheckExecutor.noRunningChecks(statuses = this.getStatusByUniqueId(AsyncCheckExecutor.getStringValueFromJobParams(jobParams, UNIQUE_ID_KEY)))) {
            boolean anyFailed = AsyncCheckExecutor.anyFailedCheck(statuses);
            boolean allFailed = AsyncCheckExecutor.allFailedChecks(statuses);
            this.platformService.queuePreflightStatusUpdate(cloudId, preflightId, containerId, AsyncCheckExecutor.calculateMigrationStatus(allFailed, anyFailed), AsyncCheckExecutor.calculateContainerStatus(allFailed, anyFailed));
            this.migrationLogService.uploadMigrationLogsZipFromClustersToMCS(cloudId, preflightId, AsyncCheckExecutor.getExecutionIdFromJobParams(jobParams));
        }
    }

    private static @NotNull AbstractContainer.ContainerStatus calculateContainerStatus(boolean allFailed, boolean anyFailed) {
        return allFailed ? AbstractContainer.ContainerStatus.FAILED : (anyFailed ? AbstractContainer.ContainerStatus.INCOMPLETE : AbstractContainer.ContainerStatus.SUCCESS);
    }

    @NotNull
    private static MigrationStatus calculateMigrationStatus(boolean allFailed, boolean anyFailed) {
        return allFailed ? MigrationStatus.FAILED : (anyFailed ? MigrationStatus.INCOMPLETE : MigrationStatus.SUCCESS);
    }

    private static boolean allFailedChecks(List<CheckStatus> statuses) {
        return statuses.stream().allMatch(checkResult -> checkResult.checkResult != null && !checkResult.checkResult.success && CheckType.fromString(checkResult.checkType).blocksMigration());
    }

    private static boolean anyFailedCheck(List<CheckStatus> statuses) {
        return statuses.stream().anyMatch(checkResult -> checkResult.checkResult != null && !checkResult.checkResult.success && CheckType.fromString(checkResult.checkType).blocksMigration());
    }

    private static boolean noRunningChecks(List<CheckStatus> statuses) {
        return statuses.stream().noneMatch(checkResult -> checkResult.checkResult == null);
    }

    private void saveAnalyticsEventAfterCheckWasExecuted(CheckType checkType, AnalyticsEventParams eventParams) {
        Map<String, String> tags = this.createTags(checkType.value(), eventParams.getResultState());
        ImmutableList analyticsCheckEvents = ImmutableList.of((Object)this.checkerRegistry.getAnalyticsEventModel(checkType, eventParams), (Object)((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MigrationMetric.PREFLIGHT_CHECK_METRIC.metricName).tags(tags)).build(), (Object)((TimerMetricEvent.Builder)new TimerMetricEvent.Builder(MigrationMetric.PREFLIGHT_CHECK_METRIC_TIMER.metricName, Long.valueOf(eventParams.getTotalTime())).tags(tags)).build());
        this.analyticsEventService.saveAnalyticsEvents(() -> AsyncCheckExecutor.lambda$saveAnalyticsEventAfterCheckWasExecuted$11((List)analyticsCheckEvents));
    }

    private CheckResult executeChecker(Map<String, Serializable> jobParams, String executionId) {
        CheckType checkType = AsyncCheckExecutor.getCheckTypeFromJobParams(jobParams);
        PreflightLogContext context = PreflightLogContext.builder().checkType(checkType.value()).isSuccess(null).checkExecutionId(executionId).build();
        this.preflightLogger.logInfo(log, context, "Starting Execution");
        Map<String, Object> inputParameters = AsyncCheckExecutor.getInputParamsFromJobParams(jobParams);
        CheckContextProvider<CheckContext> contextProvider = this.checkerRegistry.getCheckContextProvider(checkType);
        CheckContext checkContext = (CheckContext)contextProvider.apply((CheckContext)inputParameters);
        Checker<CheckContext> checker = this.checkerRegistry.getChecker(checkType);
        CheckResult checkResult = this.applyCheck(checkType, checker, checkContext);
        if (this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes()) {
            checkResult = this.handleGlobalEmailFixes(checkType, inputParameters, checkResult, checkContext);
        } else if (!this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes() && this.migrationDarkFeaturesManager.shouldHandleInvalidAndDuplicateEmailUsers()) {
            checkResult = this.captureInvalidEmailsAndOverrideCheckResult(jobParams, checkResult);
        }
        this.checkResultService.saveCheckResult(executionId, checkType, checkResult);
        return checkResult;
    }

    private CheckResult captureInvalidEmailsAndOverrideCheckResult(Map<String, Serializable> jobParams, CheckResult checkResult) {
        List emails;
        CheckType checkType = AsyncCheckExecutor.getCheckTypeFromJobParams(jobParams);
        if (INVALID_EMAILS_CHECK_TYPES.contains(checkType) && !(emails = EmailFormatChecker.retrieveInvalidEmails((Map)checkResult.details)).isEmpty()) {
            this.invalidEmailUserService.saveInvalidEmailUsers(emails);
            return new CheckResult(true);
        }
        return checkResult;
    }

    private CheckResult handleGlobalEmailFixes(CheckType checkType, Map<String, Object> params, CheckResult checkResult, CheckContext checkContext) {
        if (INVALID_EMAILS_CHECK_TYPES.contains(checkType)) {
            return this.handleInvalidEmailsCheck(params, checkResult, (InvalidEmailCheckContext)checkContext);
        }
        if (DUPLICATE_EMAILS_CHECK_TYPES.contains(checkType)) {
            return this.handleDuplicateEmailsCheck(params, checkResult, (DuplicateEmailCheckContext)checkContext);
        }
        return checkResult;
    }

    @NotNull
    private CheckResult handleDuplicateEmailsCheck(Map<String, Object> params, CheckResult checkResult, DuplicateEmailCheckContext checkContext) {
        return this.unsupportedUserHandler.resolveCheckResult(ContextProviderUtil.getCloudId(params), ContextProviderUtil.getUserKey(params), checkResult, checkContext);
    }

    @NotNull
    private CheckResult handleInvalidEmailsCheck(Map<String, Object> params, CheckResult checkResult, InvalidEmailCheckContext checkContext) {
        return this.unsupportedUserHandler.resolveCheckResult(ContextProviderUtil.getCloudId(params), ContextProviderUtil.getUserKey(params), checkResult, checkContext);
    }

    private CheckResult applyCheck(CheckType checkType, Checker<CheckContext> checker, CheckContext checkContext) {
        if (CheckType.SHARED_EMAILS.equals(checkType) && !this.migrationDarkFeaturesManager.shouldHandleGlobalEmailFixes() && this.migrationDarkFeaturesManager.shouldHandleInvalidAndDuplicateEmailUsers()) {
            log.info("Shared emails check has been disabled. Execution of check {} did not run and returning success.", (Object)checkType);
            return new CheckResult(true);
        }
        if (CheckType.MISSING_ATTACHMENTS.equals(checkType) && this.migrationDarkFeaturesManager.missingAttachmentsCheckDisabled()) {
            log.info("Missing attachments check has been disabled. Execution of check {} did not run and returning success.", (Object)checkType);
            return new CheckResult(true);
        }
        if (CheckType.APP_OUTDATED.equals(checkType) && this.migrationDarkFeaturesManager.appOutdatedCheckDisabled()) {
            log.info("App Outdated check has been disabled. Execution of check {} did not run and returning success.", (Object)checkType);
            return new CheckResult(true);
        }
        return checker.check(checkContext);
    }

    private void scheduleCheck(String executionId, CheckRequest request) {
        log.info("Scheduled check executionId: {} check: {}", (Object)executionId, (Object)request.checkType);
        CheckType checkType = CheckType.fromString(request.checkType);
        boolean isRunning = this.ptx.write(() -> {
            CheckResultEntity checkResultEntity = this.checkResultService.getOrCreate(executionId, checkType);
            if (this.migrationDarkFeaturesManager.enableMcsPreflightMigration()) {
                boolean isCheckRunning;
                String uniqueId = request.parameters != null ? (String)request.parameters.get(UNIQUE_ID_KEY) : null;
                checkResultEntity.setUniqueId(uniqueId);
                boolean bl = isCheckRunning = checkResultEntity.getStatus() == CheckExecutionStatus.RUNNING;
                if (isCheckRunning) {
                    log.info("Skipping check for executionID = {} and checkType = {} because status already is RUNNING.", (Object)executionId, (Object)checkType);
                } else {
                    checkResultEntity.setStatus(CheckExecutionStatus.RUNNING);
                }
                this.checkResultService.update(checkResultEntity);
                return isCheckRunning;
            }
            return this.checkRunningOld(checkResultEntity);
        });
        if (!isRunning) {
            this.scheduleAsyncJob(executionId, checkType, request);
        }
    }

    private boolean checkRunningOld(CheckResultEntity checkResultEntity) {
        if (checkResultEntity.getStatus() == CheckExecutionStatus.RUNNING) {
            log.info("Skipping check for executionID = {} and checkType = {} because status already is RUNNING.", (Object)checkResultEntity.getExecutionId(), (Object)checkResultEntity.getCheckType());
            return true;
        }
        checkResultEntity.setStatus(CheckExecutionStatus.RUNNING);
        this.checkResultService.update(checkResultEntity);
        return false;
    }

    private void scheduleAsyncJob(String executionId, CheckType checkType, CheckRequest request) {
        try {
            Map<String, Serializable> jobParams = AsyncCheckExecutor.generateJobParameters(executionId, checkType, request.parameters);
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)("migration-plugin:checks-runner." + checkType.value()))).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce(null)).withParameters(jobParams);
            String jobId = executionId + checkType.value();
            this.schedulerService.scheduleJob(JobId.of((String)jobId), jobConfig);
            log.info("Scheduled check executionId: {} checkType: {}, jobId = {}.", new Object[]{executionId, checkType, jobId});
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(String.format("Failed to schedule check %s", checkType), e);
        }
    }

    private CheckStatus convertToCheckStatus(CheckResultEntity entity) {
        CheckResult result = entity.getStatus() == CheckExecutionStatus.RUNNING ? null : (CheckResult)this.checkResultService.getCheckResult(entity).orElse(null);
        Long lastExecutionTime = entity.getLastExecutionTime() != null ? Long.valueOf(entity.getLastExecutionTime().toEpochMilli()) : null;
        return new CheckStatus(entity.getCheckType(), result, lastExecutionTime);
    }

    private String jobKey(CheckType checkType) {
        return "migration-plugin:checks-runner." + checkType.value();
    }

    private Map<String, String> createTags(String checkType, String resultState) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("result", resultState);
        tags.put("product", "confluence");
        tags.put("checktype", checkType);
        return tags;
    }

    public void unscheduleCheckJobs(String executionId) {
        CheckType.getStaticCheckTypes().forEach(checkType -> {
            String jobId = executionId + checkType.value();
            this.schedulerService.unscheduleJob(JobId.of((String)jobId));
            log.info("unscheduled check job for executionId: {}, checkType: {}, jobId: {}", new Object[]{executionId, checkType, jobId});
        });
    }

    void removeOverriddenChecks(List<String> preflightChecksToOverride, List<CheckRequest> checkRequests) {
        if (!CollectionUtils.isEmpty(preflightChecksToOverride)) {
            preflightChecksToOverride.forEach(overridden -> {
                checkRequests.removeIf(it -> it.checkType.equals(overridden));
                log.info("Preflight check {} excluded from check execution because it is being overridden", overridden);
            });
        }
    }

    private static /* synthetic */ Collection lambda$saveAnalyticsEventAfterCheckWasExecuted$11(List analyticsCheckEvents) {
        return analyticsCheckEvents;
    }
}

