/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.app;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.migration.agent.dto.AppListenerIssueType;
import com.atlassian.migration.agent.service.MigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.impl.MigrationAppAggregatorService;
import com.atlassian.migration.app.DefaultRegistrar;
import com.atlassian.migration.app.dto.MigrationPath;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class AppListenerIssueService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppListenerIssueService.class);
    private final MigrationAppAggregatorService appAggregatorService;
    private final DefaultRegistrar defaultRegistrar;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final AnalyticsEventService analyticsEventService;

    public AppListenerIssueService(MigrationAppAggregatorService appAggregatorService, DefaultRegistrar defaultRegistrar, AnalyticsEventBuilder analyticsEventBuilder, AnalyticsEventService analyticsEventService) {
        this.appAggregatorService = appAggregatorService;
        this.defaultRegistrar = defaultRegistrar;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.analyticsEventService = analyticsEventService;
    }

    public Set<String> getAppProblemMessages(Set<String> appKeys) {
        return appKeys.stream().map(appKey -> {
            AppListenerIssueType issueType = this.determineIssue((String)appKey);
            String message = null;
            if (issueType != null) {
                message = this.generateAppProblemMessage((String)appKey, issueType);
                try {
                    EventDto event = this.analyticsEventBuilder.buildAppServerListenerIssueEvent((String)appKey, issueType);
                    this.analyticsEventService.saveAnalyticsEvent(event);
                }
                catch (Exception e) {
                    log.error("Failed to send analytics event for app server listener issue", (Throwable)e);
                }
            }
            return message;
        }).collect(Collectors.toSet());
    }

    public AppListenerIssueType determineIssue(String appKey) {
        boolean hasRegisteredListener;
        MigrationAppAggregatorResponse maaResponse = this.appAggregatorService.getCachedServerAppData(appKey);
        MigrationPath migrationPath = maaResponse.getMigrationPath();
        boolean bl = hasRegisteredListener = !this.defaultRegistrar.getRegisteredCloudKeys(appKey).isEmpty();
        if (migrationPath == MigrationPath.INSTALL_ONLY && hasRegisteredListener) {
            return AppListenerIssueType.INSTALL_ONLY_WITH_SERVER_LISTENER;
        }
        if (migrationPath == MigrationPath.AUTOMATED && !hasRegisteredListener) {
            return AppListenerIssueType.AUTOMATED_WITHOUT_SERVER_LISTENER;
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    private String generateAppProblemMessage(String appKey, AppListenerIssueType issueType) {
        String appProblemMessage = null;
        if (issueType == AppListenerIssueType.INSTALL_ONLY_WITH_SERVER_LISTENER) {
            appProblemMessage = appKey + " may not be install only because a server listener was found. This app will be ignored during production app migrations (i.e. with dev mode turned off). Contact Atlassian support to remove this app from install only list.";
        } else if (issueType == AppListenerIssueType.AUTOMATED_WITHOUT_SERVER_LISTENER) {
            appProblemMessage = appKey + " has an automated path but missing a server listener. This app will be ignored during app migration.";
        }
        return appProblemMessage;
    }
}

