/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.entity.SortOrder;
import com.atlassian.migration.agent.rest.SpaceCatalogResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="space")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SpaceCatalogResourceJakarta {
    private final SpaceCatalogResource originalResource;

    @Inject
    public SpaceCatalogResourceJakarta(SpaceCatalogResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/")
    public Response getSpaces(@QueryParam(value="cloudId") String cloudId, @QueryParam(value="query") String nameQuery, @QueryParam(value="spaceType") String spaceType, @QueryParam(value="startIndex") int startIndex, @Nullable @QueryParam(value="statuses") String statuses, @Nullable @QueryParam(value="pageSize") Integer pageSize, @Nullable @QueryParam(value="sortKey") String sortKey, @Nullable @QueryParam(value="lastEditedStartDate") String lastEditedStartDateISO8601, @Nullable @QueryParam(value="lastEditedEndDate") String lastEditedEndDateISO8601, @DefaultValue(value="ASC") @QueryParam(value="sortOrder") SortOrder sortOrder) {
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.originalResource.getSpacesDto(pageSize, cloudId, nameQuery, spaceType, startIndex, statuses, sortKey, lastEditedStartDateISO8601, lastEditedEndDateISO8601, sortOrder)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

