/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.migration.agent.dto.PlanDto;
import com.atlassian.migration.agent.dto.PreflightCheckPlanDto;
import com.atlassian.migration.agent.dto.ProgressDto;
import com.atlassian.migration.agent.entity.CheckExecutionStatus;
import com.atlassian.migration.agent.entity.PlanActiveStatus;
import com.atlassian.migration.agent.entity.SortOrder;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventBuilder;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.check.AsyncCheckExecutor;
import com.atlassian.migration.agent.service.check.CheckResultsService;
import com.atlassian.migration.agent.service.impl.CloudTypeNotEnabledException;
import com.atlassian.migration.agent.service.impl.InvalidPlanException;
import com.atlassian.migration.agent.service.impl.PlanDecoratorService;
import com.atlassian.migration.agent.service.impl.SpaceTypeFilter;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@Path(value="plan")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PlanResource {
    private final AnalyticsEventService analyticsEventService;
    private final AnalyticsEventBuilder analyticsEventBuilder;
    private final PlanDecoratorService planDecoratorService;
    private final AsyncCheckExecutor checkExecutor;
    private final CheckResultsService checkResultService;
    private static int MIN_PAGE_SIZE = 10;
    private static int MAX_PAGE_SIZE = 100;
    private static int DEFAULT_START_IDX = 0;
    private static SpaceTypeFilter DEFAULT_SPACE_TYPE = SpaceTypeFilter.ALL;

    @Inject
    public PlanResource(AnalyticsEventService analyticsEventService, AnalyticsEventBuilder analyticsEventBuilder, PlanDecoratorService planDecoratorService, AsyncCheckExecutor checkExecutor, CheckResultsService checkResultService) {
        this.analyticsEventService = analyticsEventService;
        this.analyticsEventBuilder = analyticsEventBuilder;
        this.planDecoratorService = planDecoratorService;
        this.checkExecutor = checkExecutor;
        this.checkResultService = checkResultService;
    }

    @GET
    @Path(value="/{planId}")
    public Response getPlan(@PathParam(value="planId") String planId, @DefaultValue(value="false") @QueryParam(value="omitSpaceTasks") Boolean omitSpaceTasks) {
        return Response.ok((Object)this.getPlanDto(planId, omitSpaceTasks)).build();
    }

    @GET
    @Path(value="/")
    public Response getAllPlans() {
        return Response.ok((Object)this.getAllPlansDto()).build();
    }

    @POST
    @Path(value="/")
    public Response createPlan(PlanDto plan, @QueryParam(value="omitTasks") @DefaultValue(value="false") Boolean shouldOmitTasks) {
        Pair<Integer, Object> result = this.createPlanDto(plan, shouldOmitTasks);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @PUT
    @Path(value="/")
    public Response updatePlan(PlanDto planDto) {
        return Response.ok((Object)this.updatePlanDto(planDto)).build();
    }

    @PUT
    @Path(value="/{planId}/apps")
    public Response updatePlanApps(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.updatePlanAppsDto(planId)).build();
    }

    @GET
    @Path(value="/{planId}/progress")
    public Response getProgress(@PathParam(value="planId") String planId) {
        Pair<Integer, Object> result = this.getProgressDto(planId);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @POST
    @Path(value="/{planId}/start")
    public Response start(@PathParam(value="planId") String planId) {
        Pair<Integer, Object> result = this.startDto(planId);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @POST
    @Path(value="/{planId}/stop")
    public Response stop(@PathParam(value="planId") String planId) {
        Pair<Integer, Object> result = this.stopDto(planId);
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    @GET
    @Path(value="/validate/nameExists")
    public Response checkPlanNameExists(@QueryParam(value="name") String planName, @javax.annotation.Nullable @QueryParam(value="planId") String planId) {
        return Response.ok((Object)this.checkPlanNameExistsDto(planName, planId)).build();
    }

    @POST
    @Path(value="/{planId}/copy")
    public Response copy(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.copyDto(planId)).build();
    }

    @POST
    @Path(value="{planId}/archive")
    public Response archive(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.archiveDto(planId)).build();
    }

    @DELETE
    @Path(value="{planId}/archive")
    public Response undoArchive(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.undoArchiveDto(planId)).build();
    }

    @DELETE
    @Path(value="{planId}")
    public Response delete(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.deleteDto(planId)).build();
    }

    @GET
    @Path(value="{planId}/spaces")
    public Response getSpaces(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.getSpacesDto(planId)).build();
    }

    @GET
    @Path(value="{planId}/paginated-spaces")
    public Response getSpaces(@PathParam(value="planId") String planId, @javax.annotation.Nullable @QueryParam(value="startIndex") Integer startIndex, @javax.annotation.Nullable @QueryParam(value="pageSize") Integer pageSize, @javax.annotation.Nullable @QueryParam(value="spaceType") String spaceType, @javax.annotation.Nullable @QueryParam(value="status") String status, @javax.annotation.Nullable @QueryParam(value="query") String nameQuery, @javax.annotation.Nullable @QueryParam(value="sortKey") String sortKey, @DefaultValue(value="ASC") @QueryParam(value="sortOrder") SortOrder sortOrder) {
        try {
            return Response.ok((Object)this.getSpacesPaginatedDto(planId, startIndex, pageSize, spaceType, status, nameQuery, sortKey, sortOrder)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new MessageDto(e.getMessage())).build();
        }
    }

    public Object getPlanDto(String planId, Boolean omitSpaceTasks) {
        return this.planDecoratorService.getPlanWithOrWithoutSpaces(planId, Boolean.TRUE.equals(omitSpaceTasks));
    }

    public Object getAllPlansDto() {
        return this.planDecoratorService.getAllPlans();
    }

    public Pair<Integer, Object> createPlanDto(PlanDto plan, Boolean shouldOmitTasks) {
        try {
            PlanDto planDto = this.planDecoratorService.createPlan(plan, shouldOmitTasks);
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            this.analyticsEventService.sendAnalyticsEventsAsync(() -> this.analyticsEventBuilder.buildCreatePlanAndTasksAnalyticsEvents(planDto, confluenceUser, Optional.empty()));
            return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)this.planDecoratorService.getPreflightCheckPlanDto(planDto, true));
        }
        catch (InvalidPlanException | IllegalArgumentException e) {
            return Pair.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)new MessageDto(e.getMessage()));
        }
    }

    public Object updatePlanDto(PlanDto planDto) {
        return this.planDecoratorService.updatePlan(planDto);
    }

    public Object updatePlanAppsDto(String planId) {
        return this.planDecoratorService.updatePlanApps(planId);
    }

    public Pair<Integer, Object> getProgressDto(String planId) {
        try {
            return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)this.planDecoratorService.getPlanProgress(planId));
        }
        catch (IllegalArgumentException e) {
            return Pair.of((Object)Response.Status.NOT_FOUND.getStatusCode(), (Object)new MessageDto(String.format("Plan with id=%s hasn't been found", planId)));
        }
    }

    public Pair<Integer, Object> startDto(String planId) {
        try {
            PreflightCheckPlanDto planDto = this.planDecoratorService.verifyAndStart(planId);
            return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)planDto);
        }
        catch (IllegalArgumentException e) {
            return Pair.of((Object)Response.Status.CONFLICT.getStatusCode(), (Object)new MessageDto(String.format("Plan with id=%s has already been started", planId)));
        }
        catch (CloudTypeNotEnabledException e) {
            return Pair.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)new MessageDto(e.getMessage()));
        }
    }

    public Pair<Integer, Object> stopDto(String planId) {
        this.checkExecutor.unscheduleCheckJobs(planId);
        this.checkResultService.updateStatus(planId, CheckExecutionStatus.STOPPED);
        boolean hasPlanBeenStopped = this.planDecoratorService.stop(planId);
        if (!hasPlanBeenStopped) {
            return Pair.of((Object)Response.Status.CONFLICT.getStatusCode(), (Object)new MessageDto(String.format("Plan with id=%s cannot be stopped as it is not running", planId)));
        }
        return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)this.planDecoratorService.getPlan(planId));
    }

    public Object checkPlanNameExistsDto(String planName, String planId) {
        return this.planDecoratorService.planNameExists(planName, Objects.toString(planId, ""));
    }

    public Object copyDto(String planId) {
        return this.planDecoratorService.copy(planId);
    }

    public Object archiveDto(String planId) {
        return this.planDecoratorService.updateActiveStatus(planId, PlanActiveStatus.ARCHIVED);
    }

    public Object undoArchiveDto(String planId) {
        return this.planDecoratorService.updateActiveStatus(planId, PlanActiveStatus.ACTIVE);
    }

    public Object deleteDto(String planId) {
        return this.planDecoratorService.deletePlan(planId);
    }

    public Object getSpacesDto(String planId) {
        return this.planDecoratorService.getSpaces(planId);
    }

    public Object getSpacesPaginatedDto(String planId, @javax.annotation.Nullable @Nullable Integer startIndex, @javax.annotation.Nullable @Nullable Integer pageSize, @javax.annotation.Nullable @Nullable String spaceType, @javax.annotation.Nullable @Nullable String status, @javax.annotation.Nullable @Nullable String nameQuery, @javax.annotation.Nullable @Nullable String sortKey, SortOrder sortOrder) {
        if (startIndex == null) {
            startIndex = DEFAULT_START_IDX;
        }
        if (pageSize == null) {
            pageSize = MIN_PAGE_SIZE;
        }
        SpaceTypeFilter spaceTypeFilter = Strings.isNullOrEmpty((String)spaceType) ? DEFAULT_SPACE_TYPE : SpaceTypeFilter.valueOf(spaceType.trim().toUpperCase(Locale.ENGLISH));
        if (Strings.isNullOrEmpty((String)status)) {
            status = ProgressDto.getAllProgressStatusesDelimitedByComma();
        }
        Preconditions.checkNotNull((Object)planId, (Object)"planId must be set");
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0, (Object)"startIndex must be greater than or equal to zero");
        Preconditions.checkArgument((pageSize >= MIN_PAGE_SIZE && pageSize <= MAX_PAGE_SIZE ? 1 : 0) != 0, (Object)String.format("pageSize must be at least %d and at most %d", MIN_PAGE_SIZE, MAX_PAGE_SIZE));
        return this.planDecoratorService.getSpacesPaginatedForPlan(planId, startIndex, pageSize, spaceTypeFilter, status, nameQuery, sortKey, sortOrder);
    }
}

