/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.agent.rest.MigratedResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="migrated")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MigratedResourceJakarta {
    private final MigratedResource originalResource;

    @Inject
    public MigratedResourceJakarta(MigratedResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Path(value="/")
    public Response getAllMigratedSpaces() {
        return Response.ok(this.originalResource.getAllMigratedSpacesDto()).build();
    }

    @GET
    @Path(value="/{spacekey}")
    public Response getMigratedSpace(@PathParam(value="spacekey") String spacekey) {
        return Response.ok((Object)this.originalResource.getMigratedSpaceDto(spacekey)).build();
    }
}

