/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.rest.MessageDto;
import com.atlassian.migration.agent.service.encryption.EncryptionService;
import com.atlassian.migration.agent.service.encryption.exception.EncryptionException;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;

@ParametersAreNonnullByDefault
@Path(value="encryption")
@ReadOnlyAccessAllowed
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EncryptionResource {
    private final EncryptionService encryptionService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    @Inject
    public EncryptionResource(EncryptionService encryptionService, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.encryptionService = encryptionService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @GET
    @Path(value="/validate")
    public Response validateEncryption() {
        Pair<Integer, MessageDto> result = this.validateEncryptionDto();
        return Response.status((int)((Integer)result.getLeft())).entity(result.getRight()).build();
    }

    public Pair<Integer, MessageDto> validateEncryptionDto() {
        if (!this.migrationDarkFeaturesManager.isTokenEncryptionEnabled()) {
            return Pair.of((Object)Response.Status.BAD_REQUEST.getStatusCode(), (Object)new MessageDto("FedRAMP is not enabled"));
        }
        try {
            this.encryptionService.validateEncryption();
        }
        catch (EncryptionException e) {
            return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)new MessageDto(e.getEncryptionErrorCode().toString()));
        }
        catch (Exception e) {
            return Pair.of((Object)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Object)new MessageDto(e.getMessage()));
        }
        return Pair.of((Object)Response.Status.OK.getStatusCode(), (Object)new MessageDto("VALID_SECRET_KEY"));
    }
}

