/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.assessment.BrowserMetricsDto;
import com.atlassian.migration.agent.rest.BrowserMetricsCheckResponse;
import com.atlassian.migration.agent.rest.BrowserMetricsResource;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="browser-metrics")
@LicensedOnly
@Consumes(value={"application/json"})
public class BrowserMetricsResourceJakarta {
    private final BrowserMetricsResource originalResource;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    @Inject
    public BrowserMetricsResourceJakarta(BrowserMetricsResource originalResource, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.originalResource = originalResource;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @GET
    @Path(value="/enabled")
    @Produces(value={"application/json"})
    public BrowserMetricsCheckResponse isBrowserMetricsEnabled() {
        if (this.migrationDarkFeaturesManager.isBrowserMetricsApisDisabled()) {
            return new BrowserMetricsCheckResponse(false);
        }
        return this.originalResource.isBrowserMetricsEnabledDto();
    }

    @POST
    public Response addBrowserMetrics(BrowserMetricsDto browserMetricsDto, @Context HttpServletRequest request) {
        if (this.migrationDarkFeaturesManager.isBrowserMetricsApisDisabled()) {
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        this.originalResource.addBrowserMetricsDto(browserMetricsDto, request.getProtocol());
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }
}

