/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.rest.AppMigrationResource;
import com.atlassian.migration.agent.rest.StartAppMigRequestDto;
import com.atlassian.migration.app.dto.TransferLogResponse;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@Path(value="app-migration")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AppMigrationResourceJakarta {
    private static final String TEXT_CSV = "text/csv";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private final AppMigrationResource originalResource;

    @Inject
    public AppMigrationResourceJakarta(AppMigrationResource originalResource) {
        this.originalResource = originalResource;
    }

    @GET
    @Deprecated
    @Path(value="/rerun/{planId}")
    @Consumes(value={"*/*"})
    public Response startMigration(@PathParam(value="planId") String planId) {
        try {
            this.originalResource.startMigrationDto(planId);
            return Response.noContent().build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/trigger/{planId}")
    @Consumes(value={"*/*"})
    public Response triggerAppMigration(@PathParam(value="planId") String planId) {
        try {
            this.originalResource.triggerAppMigrationDto(planId);
            return Response.noContent().build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/trigger/{planId}")
    @Consumes(value={"*/*"})
    public Response startMigration(@PathParam(value="planId") String planId, StartAppMigRequestDto request) {
        return Response.ok((Object)this.originalResource.startMigrationDto(planId, request)).build();
    }

    @GET
    @Path(value="/check/{planId}/run/{appKey}")
    public Response executeAppOwnedPreflightCheck(@PathParam(value="appKey") String serverAppKey, @PathParam(value="planId") String planId) {
        try {
            this.originalResource.executeAppOwnedPreflightCheckDto(serverAppKey, planId);
            return Response.noContent().build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/rerun/{planId}/{containerId}/enabled")
    public Response isRerunEnabled(@PathParam(value="containerId") String containerId, @PathParam(value="planId") String planId, @QueryParam(value="serverAppKey") String serverAppKey) {
        try {
            return Response.ok((Object)this.originalResource.isRerunEnabledDto(containerId, planId, serverAppKey)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/rerun/{planId}/{containerId}/{transferId}/enabled")
    public Response isRerunEnabled(@PathParam(value="containerId") String containerId, @PathParam(value="planId") String planId, @PathParam(value="transferId") String transferId, @QueryParam(value="serverAppKey") String serverAppKey) {
        try {
            return Response.ok((Object)this.originalResource.isRerunEnabledDto(containerId, planId, transferId, serverAppKey)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/rerun/{planId}/{containerId}")
    public void rerunAppMigration(@PathParam(value="containerId") String containerId, @PathParam(value="planId") String planId, @QueryParam(value="serverAppKey") String serverAppKey) {
        this.originalResource.rerunAppMigrationDto(containerId, planId, serverAppKey);
    }

    @POST
    @Path(value="/rerun/{planId}/{containerId}/{transferId}")
    public void rerunAppMigration(@PathParam(value="containerId") String containerId, @PathParam(value="planId") String planId, @PathParam(value="transferId") String transferId, @QueryParam(value="serverAppKey") String serverAppKey) {
        this.originalResource.rerunAppMigrationDto(containerId, planId, transferId, serverAppKey);
    }

    @GET
    @Path(value="/transfer/log/csv")
    public Response getTransferLogCsv(@QueryParam(value="planId") String planId, @QueryParam(value="containerId") String containerId, @QueryParam(value="transferId") String transferId) {
        TransferLogResponse response = this.originalResource.getTransferLogCsvDto(planId, containerId, transferId);
        return Response.ok((Object)response.getCsv()).type(TEXT_CSV).header(CONTENT_DISPOSITION, (Object)response.getContentDispositionHeader()).build();
    }

    @GET
    @Path(value="/transfer/log/enabled")
    public Response getTransferLogEnabled(@QueryParam(value="planId") String planId, @QueryParam(value="containerId") String containerId, @QueryParam(value="transferId") String transferId) {
        return Response.ok((Object)this.originalResource.getTransferLogEnabledDto(planId, containerId, transferId)).build();
    }

    @POST
    @Path(value="/cancel/{planId}/{containerId}")
    public Response cancelAppMigration(@PathParam(value="planId") String plandId, @PathParam(value="containerId") String containerId) {
        this.originalResource.cancelAppMigrationDto(plandId, containerId);
        return Response.ok().build();
    }

    @POST
    @Path(value="/cancel/{planId}/{containerId}/{transferId}")
    public Response cancelAppMigration(@PathParam(value="planId") String plandId, @PathParam(value="containerId") String containerId, @PathParam(value="transferId") String transferId) {
        this.originalResource.cancelAppMigrationDto(plandId, containerId, transferId);
        return Response.ok().build();
    }

    @GET
    @Path(value="/progress/{planId}")
    public Response getProgressForHuman(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.originalResource.getProgressForHumanDto(planId)).build();
    }

    @GET
    @Path(value="/progress/cloud-id/{cloudId}/migration-id/{migrationId}")
    public Response getProgressForMigration(@PathParam(value="cloudId") String cloudId, @PathParam(value="migrationId") String migrationId) {
        return Response.ok(this.originalResource.getAppMigrationProgress(cloudId, migrationId)).build();
    }
}

