/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.dto.AppsProgressDto;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.rest.AppMigrationRerunDto;
import com.atlassian.migration.agent.rest.StartAppMigRequestDto;
import com.atlassian.migration.agent.service.check.PreflightService;
import com.atlassian.migration.agent.service.impl.AppCancellationService;
import com.atlassian.migration.agent.service.impl.AppMigrationDevelopmentService;
import com.atlassian.migration.agent.service.impl.AppRerunService;
import com.atlassian.migration.agent.service.impl.AppTransferLogService;
import com.atlassian.migration.app.dto.TransferLogEnablement;
import com.atlassian.migration.app.dto.TransferLogResponse;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;

@Path(value="app-migration")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AppMigrationResource {
    private static final String TEXT_CSV = "text/csv";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String EXCEPTION_MESSAGE_PREFIX = "Exception: ";
    private final AppMigrationDevelopmentService appMigrationDevelopmentService;
    private final PreflightService preflightService;
    private final AppRerunService appRerunService;
    private final AppTransferLogService appTransferLogService;
    private final AppCancellationService appCancellationService;
    private static final Logger log = ContextLoggerFactory.getLogger(AppMigrationResource.class);

    @Inject
    public AppMigrationResource(AppMigrationDevelopmentService appMigrationDevelopmentService, PreflightService preflightService, AppRerunService appRerunService, AppTransferLogService appTransferLogService, AppCancellationService appCancellationService) {
        this.appMigrationDevelopmentService = appMigrationDevelopmentService;
        this.preflightService = preflightService;
        this.appRerunService = appRerunService;
        this.appTransferLogService = appTransferLogService;
        this.appCancellationService = appCancellationService;
    }

    @GET
    @Deprecated
    @Path(value="/rerun/{planId}")
    @Consumes(value={"*/*"})
    public Response startMigration(@PathParam(value="planId") String planId) {
        try {
            this.startMigrationDto(planId);
        }
        catch (Exception e) {
            log.warn(EXCEPTION_MESSAGE_PREFIX, (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/trigger/{planId}")
    @Consumes(value={"*/*"})
    public Response triggerAppMigration(@PathParam(value="planId") String planId) {
        try {
            this.triggerAppMigrationDto(planId);
        }
        catch (Exception e) {
            log.warn(EXCEPTION_MESSAGE_PREFIX, (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/trigger/{planId}")
    @Consumes(value={"*/*"})
    public Response startMigration(@PathParam(value="planId") String planId, StartAppMigRequestDto request) {
        return Response.ok((Object)this.startMigrationDto(planId, request)).build();
    }

    @GET
    @Path(value="/check/{planId}/run/{appKey}")
    public Response executeAppOwnedPreflightCheck(@PathParam(value="appKey") String serverAppKey, @PathParam(value="planId") String planId) {
        try {
            this.executeAppOwnedPreflightCheckDto(serverAppKey, planId);
        }
        catch (Exception e) {
            log.warn(EXCEPTION_MESSAGE_PREFIX, (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/rerun/{planId}/{containerId}/enabled")
    public Response isRerunEnabled(@PathParam(value="containerId") String containerId, @PathParam(value="planId") String planId, @QueryParam(value="serverAppKey") String serverAppKey) {
        try {
            return Response.ok((Object)this.isRerunEnabledDto(containerId, planId, serverAppKey)).build();
        }
        catch (Exception e) {
            log.warn(EXCEPTION_MESSAGE_PREFIX, (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/rerun/{planId}/{containerId}/{transferId}/enabled")
    public Response isRerunEnabled(@PathParam(value="containerId") String containerId, @PathParam(value="planId") String planId, @PathParam(value="transferId") String transferId, @QueryParam(value="serverAppKey") String serverAppKey) {
        try {
            return Response.ok((Object)this.isRerunEnabledDto(containerId, planId, transferId, serverAppKey)).build();
        }
        catch (Exception e) {
            log.warn(EXCEPTION_MESSAGE_PREFIX, (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/rerun/{planId}/{containerId}")
    public void rerunAppMigration(@PathParam(value="containerId") String containerId, @PathParam(value="planId") String planId, @QueryParam(value="serverAppKey") String serverAppKey) {
        this.rerunAppMigrationDto(containerId, planId, serverAppKey);
    }

    @POST
    @Path(value="/rerun/{planId}/{containerId}/{transferId}")
    public void rerunAppMigration(@PathParam(value="containerId") String containerId, @PathParam(value="planId") String planId, @PathParam(value="transferId") String transferId, @QueryParam(value="serverAppKey") String serverAppKey) {
        this.rerunAppMigrationDto(containerId, planId, transferId, serverAppKey);
    }

    @GET
    @Path(value="/transfer/log/csv")
    public Response getTransferLogCsv(@QueryParam(value="planId") String planId, @QueryParam(value="containerId") String containerId, @QueryParam(value="transferId") String transferId) {
        TransferLogResponse response = this.getTransferLogCsvDto(planId, containerId, transferId);
        return Response.ok((Object)response.getCsv()).type(TEXT_CSV).header(CONTENT_DISPOSITION, (Object)response.getContentDispositionHeader()).build();
    }

    @GET
    @Path(value="/transfer/log/enabled")
    public Response getTransferLogEnabled(@QueryParam(value="planId") String planId, @QueryParam(value="containerId") String containerId, @QueryParam(value="transferId") String transferId) {
        return Response.ok((Object)this.getTransferLogEnabledDto(planId, containerId, transferId)).build();
    }

    @POST
    @Path(value="/cancel/{planId}/{containerId}")
    public Response cancelAppMigration(@PathParam(value="planId") String plandId, @PathParam(value="containerId") String containerId) {
        this.cancelAppMigrationDto(plandId, containerId);
        return Response.ok().build();
    }

    @POST
    @Path(value="/cancel/{planId}/{containerId}/{transferId}")
    public Response cancelAppMigration(@PathParam(value="planId") String plandId, @PathParam(value="containerId") String containerId, @PathParam(value="transferId") String transferId) {
        this.cancelAppMigrationDto(plandId, containerId, transferId);
        return Response.ok().build();
    }

    @GET
    @Path(value="/progress/{planId}")
    public Response getProgressForHuman(@PathParam(value="planId") String planId) {
        return Response.ok((Object)this.getProgressForHumanDto(planId)).build();
    }

    @GET
    @Path(value="/progress/cloud-id/{cloudId}/migration-id/{migrationId}")
    public Response getProgressForMigration(@PathParam(value="cloudId") String cloudId, @PathParam(value="migrationId") String migrationId) {
        return Response.ok(this.getAppMigrationProgress(cloudId, migrationId)).build();
    }

    public void startMigrationDto(String planId) {
        log.warn("You are using a deprecated endpoint. Please update your scripts to use GET /app-migration/trigger/{planId}");
        this.appMigrationDevelopmentService.rerunAppMigrationForPlan(planId);
    }

    public void triggerAppMigrationDto(String planId) {
        this.appMigrationDevelopmentService.rerunAppMigrationForPlan(planId);
    }

    public AppMigrationRerunDto startMigrationDto(String planId, StartAppMigRequestDto request) {
        return this.appMigrationDevelopmentService.rerunAppMigrationForPlan(planId, request.includeServerAppKeys);
    }

    public List<AppsProgressDto.App> getAppMigrationProgress(String cloudId, String migrationId) {
        return this.appMigrationDevelopmentService.getAppMigrationProgress(cloudId, migrationId);
    }

    public void executeAppOwnedPreflightCheckDto(String serverAppKey, String planId) {
        try {
            this.preflightService.executeAllAppVendorChecksForApp(planId, serverAppKey);
        }
        catch (Exception e) {
            log.warn(EXCEPTION_MESSAGE_PREFIX, (Throwable)e);
            throw e;
        }
    }

    public Object isRerunEnabledDto(String containerId, String planId, String serverAppKey) {
        try {
            return this.appRerunService.isRerunEnabled(planId, containerId, serverAppKey);
        }
        catch (Exception e) {
            log.warn(EXCEPTION_MESSAGE_PREFIX, (Throwable)e);
            throw e;
        }
    }

    public Object isRerunEnabledDto(String containerId, String planId, String transferId, String serverAppKey) {
        try {
            return this.appRerunService.isRerunEnabled(planId, containerId, serverAppKey, transferId);
        }
        catch (Exception e) {
            log.warn(EXCEPTION_MESSAGE_PREFIX, (Throwable)e);
            throw e;
        }
    }

    public void rerunAppMigrationDto(String containerId, String planId, String serverAppKey) {
        this.appRerunService.rerunAppMigration(planId, containerId, serverAppKey);
    }

    public void rerunAppMigrationDto(String containerId, String planId, String transferId, String serverAppKey) {
        this.appRerunService.rerunAppMigration(planId, containerId, serverAppKey, transferId);
    }

    public TransferLogResponse getTransferLogCsvDto(String planId, String containerId, String transferId) {
        return this.appTransferLogService.getTransferLogResponse(planId, containerId, transferId);
    }

    public TransferLogEnablement getTransferLogEnabledDto(String planId, String containerId, String transferId) {
        return this.appTransferLogService.isTransferLogsEnabled(planId, containerId, transferId);
    }

    public void cancelAppMigrationDto(String plandId, String containerId) {
        this.appCancellationService.cancelAppMigration(plandId, containerId, "Cancellation requested by user");
    }

    public void cancelAppMigrationDto(String plandId, String containerId, String transferId) {
        this.appCancellationService.cancelAppMigration(plandId, containerId, "Cancellation requested by user", transferId);
    }

    public Object getProgressForHumanDto(String planId) {
        return this.appMigrationDevelopmentService.getAppMigrationProgress(planId);
    }
}

