/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.rest;

import com.atlassian.migration.agent.dto.analytics.ScreenAnalyticsEventDto;
import com.atlassian.migration.agent.dto.analytics.TrackAnalyticsEventDto;
import com.atlassian.migration.agent.dto.analytics.UIAnalyticsEventDto;
import com.atlassian.migration.agent.rest.AnalyticsEventResource;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="mas")
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AnalyticsEventResourceJakarta {
    private final AnalyticsEventResource originalResource;

    @Inject
    public AnalyticsEventResourceJakarta(AnalyticsEventResource originalResource) {
        this.originalResource = originalResource;
    }

    @POST
    @Path(value="/event/ui")
    public Response saveAnalyticsEvent(UIAnalyticsEventDto uiEvent) {
        this.originalResource.saveUIAnalyticsEventDto(uiEvent);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/event/screen")
    public Response saveAnalyticsEvent(ScreenAnalyticsEventDto screenEvent) {
        this.originalResource.saveScreenAnalyticsEventDto(screenEvent);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/event/track")
    public Response saveAnalyticsEvent(TrackAnalyticsEventDto trackEvent) {
        this.originalResource.saveTrackAnalyticsEventDto(trackEvent);
        return Response.noContent().build();
    }
}

